---
name: slack-writer
description: Draft Slack messages with appropriate tone. Use when writing messages to teammates or customers over Slack.
---

# Slack Message Writer

## Core Principle
Every word does work. No filler. No hedging. Say the thing, then stop.

## Tone Guidelines
- **Friendly but professional** - warm without being overly casual
- **Concise** - respect people's time, get to the point
- **Confident** - speak with authority, not arrogance
- **Action-oriented** - clear next steps when applicable
- **Empathetic** - acknowledge concerns before solving

## Structure
1. Brief acknowledgment or greeting (1 line max)
2. Core message (2-3 sentences)
3. Clear ask or next step (if needed)

## Examples

**Customer asking about a feature:**
> Thanks for reaching out! That feature is on our roadmap for Q2. I'll flag your interest with the product team and keep you posted.

**Internal teammate update:**
> Quick update on Acme Corp. Spoke with their team today, they're moving forward with the pilot. I'll send over the SOW by EOD tomorrow.

**Addressing a concern:**
> I hear you. That's frustrating. Let me dig into this and get back to you within the hour with a clear answer.

**Following up:**
> Circling back on this. Any updates from your side? Happy to jump on a call if that's easier.

## Avoid These

### Weak Openers
- "Just wanted to..." (say what you want)
- "I think maybe..." (commit or don't)
- "Sorry to bother you" (you're not bothering)

### Corporate Filler
- "Per my last email" (passive aggressive)
- "Going forward" (filler)
- "At the end of the day" (filler)
- "Leverage" (use "use")
- "Synergy" / "alignment" (say what you mean)
- "Touch base" (say "check in" or "talk")

### AI-Sounding Language
- "I wanted to reach out to..."
- "I hope this message finds you well"
- "Please don't hesitate to..."
- "Thank you for your patience"
- "As per our conversation"

## What To Do Instead
- State things directly
- One clear ask per message
- Name specific times ("by 3pm" not "soon")
- Name specific people ("I'll ask Sarah" not "I'll check with the team")
- End on action, not atmosphere
