---
name: sme-interview
description: Helps extract and structure knowledge from Subject Matter Expert interviews. Use when preparing SME interviews, documenting expert knowledge, structuring content from experts, or when user mentions "SME interview," "expert knowledge," "content extraction," "subject matter expert," or "knowledge capture."
---

# SME Interview Guide

Framework for extracting and structuring knowledge from Subject Matter Experts.

## Interview Preparation

### Pre-Interview Checklist

- [ ] Review existing documentation on the topic
- [ ] Identify knowledge gaps to fill
- [ ] Prepare specific questions (see templates below)
- [ ] Schedule 60-90 minute session
- [ ] Get permission to record (if applicable)
- [ ] Share agenda with SME in advance
- [ ] Prepare examples/scenarios for discussion

### SME Briefing Template

Send to SME before the interview:

```markdown
**Subject:** Preparing for Our [Topic] Knowledge Capture Session

Hi [SME Name],

Thank you for agreeing to share your expertise on [topic]. Here's what to expect:

**Meeting Details:**
- Date/Time: [Date/Time]
- Duration: [60-90 minutes]
- Format: [In-person/Video call]

**What We'll Cover:**
1. [Key area 1]
2. [Key area 2]
3. [Key area 3]

**How to Prepare:**
- Think of 2-3 examples or scenarios you commonly encounter
- Consider common mistakes or misconceptions
- Gather any reference materials you use

**Our Goal:**
Create training that helps [target audience] [achieve outcome].

Questions? Let me know!

[Your name]
```

## Interview Question Templates

### Process/Procedure Topics

```markdown
## [Process Name] Interview Questions

### Overview
1. Can you walk me through [process] from start to finish?
2. What triggers this process? When does someone need to do this?
3. How long does this typically take?

### Steps
4. What's the first thing someone should do?
5. What comes next? And after that?
6. Are there any decision points where the path might branch?
7. What tools or systems are used at each step?

### Expertise
8. What's the trickiest part of this process?
9. What mistakes do beginners commonly make?
10. What separates someone who's good at this from someone who's great?
11. Are there any shortcuts or tips you've learned?

### Edge Cases
12. What happens if [scenario]?
13. How do you handle [exception]?
14. What should someone do if something goes wrong?

### Verification
15. How do you know you've done it correctly?
16. What does a good outcome look like?
```

### Concept/Knowledge Topics

```markdown
## [Concept] Interview Questions

### Foundation
1. How would you explain [concept] to someone new?
2. Why is this important? Why should learners care?
3. What background knowledge is needed to understand this?

### Deep Dive
4. What are the key components or elements?
5. How do these parts relate to each other?
6. Are there different types or categories?
7. What are the underlying principles?

### Application
8. When would someone apply this knowledge?
9. Can you give me a real-world example?
10. What does this look like in practice?

### Common Issues
11. What do people often get wrong about this?
12. What misconceptions do beginners have?
13. What's the most important thing to remember?

### Advanced
14. What nuances should more experienced people know?
15. How has your understanding of this evolved over time?
```

### Skills/Tasks Topics

```markdown
## [Skill/Task] Interview Questions

### Task Overview
1. What exactly does [task] involve?
2. When would someone need to perform this?
3. What's the end result or deliverable?

### Prerequisites
4. What should someone know before attempting this?
5. What tools/resources/access do they need?
6. Is there anything they should do first?

### Demonstration
7. Can you show me how you do this? (screen share/demo)
8. What are you thinking as you do each step?
9. How do you make decisions along the way?

### Quality & Standards
10. What makes the difference between acceptable and excellent?
11. What are the quality standards or criteria?
12. How would you evaluate someone's work?

### Troubleshooting
13. What problems commonly occur?
14. How do you diagnose issues?
15. What are the fixes for common problems?

### Efficiency
16. How can someone do this faster without sacrificing quality?
17. What tools or techniques save time?
18. What would you do differently knowing what you know now?
```

## Interview Techniques

### Effective Probing

| When They Say | Follow Up With |
|---------------|----------------|
| "It depends" | "What does it depend on? Give me the main scenarios." |
| "You just know" | "How did you learn to 'just know'? What cues do you look for?" |
| "It's common sense" | "Walk me through your thought process. What factors do you consider?" |
| "That rarely happens" | "But when it does happen, what should someone do?" |
| Technical jargon | "How would you explain [term] to someone new?" |

### Capturing Tacit Knowledge

Questions to surface unspoken expertise:

- "What do you notice that others might miss?"
- "What would you tell your past self when you were learning this?"
- "What do you wish someone had told you earlier?"
- "What separates the experts from the novices?"
- "What do you do automatically now that used to require thought?"

### Example Elicitation

- "Can you give me a specific example of when [situation] happened?"
- "Think of a recent time you did this. Walk me through it."
- "What's the best example of [success/failure] you've seen?"
- "If I were shadowing you, what would I see?"

## Interview Documentation

### Real-Time Notes Template

```markdown
# SME Interview Notes

**Date:** [Date]
**SME:** [Name, Title]
**Topic:** [Topic]
**Interviewer:** [Name]

---

## Key Concepts

### [Concept 1]
- Definition:
- Why it matters:
- Example:

### [Concept 2]
- Definition:
- Why it matters:
- Example:

---

## Process/Steps

1. **[Step 1]**
   - Action:
   - Tool/System:
   - Tips:

2. **[Step 2]**
   - Action:
   - Tool/System:
   - Tips:

---

## Common Mistakes
- [Mistake 1]: [How to avoid]
- [Mistake 2]: [How to avoid]

---

## Expert Tips
- [Tip 1]
- [Tip 2]

---

## Quotes (for scenarios/examples)
> "[Direct quote from SME]" - regarding [context]

---

## Follow-Up Needed
- [ ] [Question or clarification needed]
- [ ] [Additional resource to request]

---

## Action Items
- [ ] [Next step]
- [ ] [Review item]
```

### Post-Interview Summary

```markdown
# Content Summary: [Topic]

**Source:** SME Interview with [Name] on [Date]
**For Course:** [Course Name]
**Module:** [Module Number/Name]

---

## Learning Objectives Supported

This content supports the following objectives:
- Objective X.X: [Objective text]
- Objective X.X: [Objective text]

---

## Content Outline

### Topic 1: [Title]

**Key Points:**
1. [Point 1]
2. [Point 2]
3. [Point 3]

**Example/Scenario:**
[Description of example from SME]

**Common Mistake:**
[What learners often get wrong and how to avoid it]

---

### Topic 2: [Title]

**Key Points:**
1. [Point 1]
2. [Point 2]

**Process Steps:**
1. [Step 1]
2. [Step 2]
3. [Step 3]

**Expert Tip:**
[Insight from SME]

---

## Recommended Assessments

Based on SME input, assess learners on:
- [Skill/knowledge to test]
- [Scenario to present]

---

## Additional Resources Mentioned

- [Resource 1]: [Description]
- [Resource 2]: [Description]

---

## SME Review Status

- [ ] Summary sent to SME for accuracy review
- [ ] SME approved content
- [ ] Revisions incorporated
```

## Content Transformation

### From Interview to Learning Content

| SME Says | Transform To |
|----------|--------------|
| Long explanation | Chunked bullet points (5-7 items) |
| Jargon | Plain language + glossary term |
| "In my experience..." | Scenario or case study |
| List of steps | Numbered procedure |
| Common mistake | Knowledge check question |
| Expert tip | Callout box or pro tip |

### Quality Check

After transforming SME content:

- [ ] Aligned to learning objectives
- [ ] Language appropriate for audience
- [ ] Technical terms defined
- [ ] Examples are realistic
- [ ] Steps are complete and in order
- [ ] SME has reviewed for accuracy

## File Output

Save to: `course-template/00-analysis/` or `course-template/01-design/`

Naming:
- `sme-interview-notes-[topic]-[date].md`
- `content-summary-[topic].md`
