---
name: social-media
description: Social media strategy, content creation, and platform optimization. Use when creating social content, developing engagement strategies, optimizing for platform algorithms, or building community.
---

# Social Media

Social media strategy, content creation, and community building across platforms.

## Language & Quality Standards

**CRITICAL**: Respond in the same language the user is using. If Vietnamese, respond in Vietnamese. If Spanish, respond in Spanish.

**Standards**: Token efficiency, sacrifice grammar for concision, list unresolved questions at end.

---

## When to Use This Skill

Apply social media expertise when:
- Creating social content strategies
- Developing platform-specific content
- Optimizing for platform algorithms
- Building engagement and community
- Planning social media calendars
- Analyzing social performance

## Core Concepts

### Platform Selection Matrix

| Platform | Best For | Primary Audience | Content Type | B2B/B2C |
|----------|----------|------------------|--------------|---------|
| LinkedIn | Professional, B2B | Decision makers, 25-54 | Long-form, documents, carousel | B2B |
| Twitter/X | News, tech, thought leadership | Early adopters, industry | Short-form, threads | Both |
| Instagram | Visual brands, lifestyle | Millennials, Gen Z | Reels, carousels, Stories | B2C |
| TikTok | Entertainment, trends | Gen Z, younger millennials | Short video, trends | B2C |
| Facebook | Local, community, groups | Broad, 35-65+ | Video, groups, events | Both |
| YouTube | Education, how-to, long-form | All ages | Long-form video | Both |

### Content Pillar Strategy

**The 4 Content Pillars**:
| Pillar | Purpose | Ratio | Examples |
|--------|---------|-------|----------|
| Educational | Build trust, authority | 40% | Tips, how-tos, industry insights |
| Entertaining | Build engagement, reach | 30% | Humor, trends, behind-scenes |
| Inspirational | Build connection, emotion | 20% | Stories, motivation, culture |
| Promotional | Drive action, revenue | 10% | Offers, product, CTAs |

### Platform Algorithm Factors

**LinkedIn Algorithm**:
- Dwell time (time spent reading)
- Comments > Shares > Reactions
- First hour engagement critical
- Native content preferred
- No outbound links in body (put in comments)

**Instagram Algorithm**:
- Relationship (DMs, comments, story replies)
- Interest (based on past behavior)
- Timeliness (recent posts prioritized)
- Reels heavily promoted
- Story engagement matters

**TikTok Algorithm**:
- Watch time / completion rate
- Shares > Comments > Likes
- Video information (captions, hashtags)
- Device and account settings
- Trending sounds boost reach

**Twitter/X Algorithm**:
- Engagement velocity (first 30 min)
- Replies and conversations
- Media (images, video) preferred
- Threads for depth
- Profile authority matters

### Optimal Posting Times

| Platform | Best Days | Best Times (local) | Frequency |
|----------|-----------|-------------------|-----------|
| LinkedIn | Tue-Thu | 8-10am, 12pm | 1-2/day |
| Instagram | Mon-Fri | 11am, 2pm, 7pm | 1-2/day + Stories |
| TikTok | Tue-Thu | 7-9pm | 1-3/day |
| Twitter/X | Wed-Fri | 9am, 12pm, 5pm | 3-5/day |
| Facebook | Wed-Fri | 1-4pm | 1-2/day |

### Engagement Tactics

**Proactive Engagement**:
- Respond to comments within 1 hour
- Ask questions in posts
- Use polls and interactive features
- Tag relevant accounts
- Join conversations in niche

**Community Building**:
- Create exclusive groups
- Feature user-generated content
- Host live sessions
- Run challenges/contests
- Spotlight community members

### Content Format Optimization

**Carousel Best Practices**:
- Hook on slide 1 (problem/question)
- Value in slides 2-8
- CTA on final slide
- Consistent design
- Save-worthy information

**Video Best Practices**:
- Hook in first 3 seconds
- Captions always (80% watch muted)
- Vertical for mobile
- Under 60s for most platforms
- Strong ending/CTA

**Text Post Best Practices**:
- Strong first line (hook)
- White space for readability
- Bullets and formatting
- Single CTA
- Hashtags strategically placed

## Best Practices

### Content Excellence
1. **Platform-Native**: Adapt format per platform
2. **Consistency**: Regular posting schedule
3. **Value-First**: Give before you ask
4. **Authenticity**: Real voice, real stories

### Engagement Excellence
1. **Respond Fast**: Speed shows you care
2. **Be Human**: Personality over perfection
3. **Encourage Conversation**: Ask, don't just broadcast
4. **Celebrate Community**: UGC and recognition

### Growth Excellence
1. **Collaboration**: Partner with others in niche
2. **Trends**: Participate when relevant
3. **Cross-Promotion**: Leverage other channels
4. **Paid Boost**: Amplify best organic content

## Agent Integration

| Agent | How They Use This Skill |
|-------|------------------------|
| `copywriter` | Social copy creation |
| `brainstormer` | Campaign ideation |
| `planner` | Social calendar planning |
| `continuity-specialist` | Community engagement strategy |

## Anti-Patterns to Avoid

| Anti-Pattern | Why It's Wrong | Do This Instead |
|--------------|----------------|-----------------|
| Same content everywhere | Platforms differ | Adapt per platform |
| Posting and ghosting | Kills engagement | Engage in comments |
| All promotion | No one follows for ads | 90% value, 10% promo |
| Ignoring analytics | Repeating what doesn't work | Analyze and iterate |
| Buying followers | Fake engagement, hurts reach | Grow organically |

## Metrics & Benchmarks

| Metric | Good | Excellent | Calculate |
|--------|------|-----------|-----------|
| Engagement Rate | 1-3% | 3%+ | (Engagements / Followers) × 100 |
| Follower Growth | 2-5%/mo | 5%+/mo | Monthly net new / Total |
| Share Rate | 1-2% | 2%+ | Shares / Reach |
| Save Rate | 2-5% | 5%+ | Saves / Reach |

## Related Commands

- `/social/schedule` - Create posting schedule
- `/social/engage` - Develop engagement strategy
- `/social/viral` - Create viral-potential content
- `/content/social` - Platform-specific content

## References

- `references/platform-algorithms.md` - How each algorithm works
- `references/content-formats.md` - Format best practices
- `references/engagement-tactics.md` - Building engagement
- `references/viral-mechanics.md` - What makes content spread
