---
name: "Social Media Investigation"
description: "Find and analyze social media profiles and digital presence"
allowed-tools:
  - src.tools.social_media
---

# Social Media Investigation

## Purpose

Discover and analyze social media profiles, online presence, and digital footprint for background checks, due diligence, and investigative purposes.

## When to Use

- Executive and employee background verification
- Digital footprint analysis for due diligence
- Investigation of potentially fraudulent identities
- Reputation risk assessment for business partnerships
- Verification of claims made in applications or interviews
- Analysis of professional networks and associations
- Investigation of suspicious online activities
- Compliance screening for public-facing roles

## How to Use

The social media tool searches across multiple platforms and analyzes:

- **Profile Discovery**: Facebook, Twitter, LinkedIn, Instagram, TikTok, others
- **Content Analysis**: Posts, photos, videos, comments, professional content
- **Network Analysis**: Connections, followers, professional associations
- **Activity Patterns**: Posting frequency, engagement levels, timeline
- **Verification Status**: Verified accounts, blue checkmarks, authenticity
- **Professional Presence**: Work history, skills, endorsements, recommendations

## Examples

**Executive background check:**
```
Subject: Michael Thompson, proposed board member
Investigation: LinkedIn confirms claimed experience, professional network
Red flags: Twitter posts with controversial political views
Assessment: Professional qualifications verified, reputation risk identified
```

**Identity verification:**
```
Applicant: Jane Smith claims specific background
Analysis: LinkedIn profile matches resume, Facebook confirms location history
Photos: Consistent personal photos across platforms
Conclusion: Identity appears authentic and verified
```

**Fraud investigation:**
```
Suspect: "John Davis" in investment scheme
Investigation: No credible social media presence found
Red flags: Generic photos, minimal online footprint
Evidence: Likely fraudulent identity with manufactured background
```

**Due diligence on business partner:**
```
Individual: Sarah Chen, startup co-founder
Research: Active tech industry presence, speaking engagements
Network: Connections to legitimate VCs and tech leaders
Assessment: Credible background and industry reputation
```

## Important Notes

- Respect privacy settings and platform terms of service
- Consider authenticity - profiles can be fake or manipulated
- Social media content may not reflect current views or circumstances
- Be aware of cultural and generational differences in social media use
- Some individuals deliberately maintain minimal online presence
- Cross-reference information across multiple platforms for accuracy
- Consider legal and ethical implications of social media investigation
- Document findings carefully while respecting privacy rights
- Be aware that absence of social media presence isn't necessarily suspicious