---
name: Social Post Creator
slug: social-post-creator
description: Generate engaging social media posts optimized for each platform
category: communication
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "create social post"
  - "write social media"
  - "draft social content"
  - "social post"
tags:
  - social-media
  - content-creation
  - marketing
  - engagement
---

# Social Post Creator

The Social Post Creator skill helps you craft engaging, platform-optimized social media posts that drive engagement and achieve your communication goals. Whether you're sharing company updates on LinkedIn, engaging with your community on Twitter/X, building brand awareness on Instagram, or driving discussion on Threads, this skill ensures your content fits the platform and resonates with your audience.

This skill understands that each social platform has its own culture, format preferences, and engagement patterns. What works on LinkedIn won't work on Twitter, and Instagram requires different content than Threads. The skill helps you adapt your message to each platform while maintaining your authentic voice.

Great social content starts conversations, builds relationships, and drives action. This skill makes creating it efficient while keeping quality and platform best practices front and center.

## Core Workflows

### Workflow 1: Single Platform Post
1. **Define Goal**: Understand what you want to achieve
2. **Choose Platform**: Select primary social channel
3. **Craft Message**: Write platform-optimized content
4. **Add Media**: Include images, videos, or links
5. **Optimize Hashtags**: Add relevant tags for discovery
6. **Schedule**: Determine optimal posting time

### Workflow 2: Cross-Platform Campaign
1. **Develop Core Message**: Create main theme
2. **Adapt per Platform**: Customize for each channel
3. **Maintain Consistency**: Keep key points across all versions
4. **Vary Format**: Use each platform's strengths
5. **Coordinate Timing**: Stagger or synchronize posts
6. **Track Performance**: Monitor which versions resonate

### Workflow 3: Content Calendar Planning
1. **Identify Themes**: Plan content pillars
2. **Map to Calendar**: Schedule posts in advance
3. **Balance Content Types**: Mix promotional, educational, entertaining
4. **Create Templates**: Build reusable formats
5. **Batch Create**: Write multiple posts efficiently

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| LinkedIn post | "Write LinkedIn post about [topic]" |
| Twitter/X thread | "Create Twitter thread on [topic]" |
| Instagram caption | "Draft Instagram caption for [content]" |
| Threads post | "Write Threads post about [topic]" |
| Cross-platform | "Create social posts for all platforms about [topic]" |
| Announcement | "Draft social announcement for [news]" |
| Engagement post | "Create engagement post asking [question]" |
| Thought leadership | "Write thought leadership post on [topic]" |

## Platform-Specific Guidelines

### LinkedIn

**Character Limit:** 3,000 (but optimal is 150-300)

**Best Practices:**
- Lead with value in first 2 lines (before "see more")
- Use professional but conversational tone
- Include personal insights or stories
- Add relevant hashtags (3-5 max)
- Tag people and companies when relevant
- Include call-to-action
- Post during business hours (Tue-Thu, 8am-2pm)

**Content Types:**
- Professional insights
- Career lessons
- Industry trends
- Company updates
- Thought leadership
- Success stories
- Tips and how-tos

**Format:**
```
[Hook - First 2 lines that grab attention]

[Main content - story, insight, or value]

[Key takeaways or lessons]

[Call-to-action or question]

[3-5 relevant #hashtags]
```

**Example:**
```
The best product managers I've worked with all share one trait.

It's not technical skill. It's not design sense.

It's the ability to say no.

Early in my career, I said yes to everything. Every feature request, every stakeholder ask, every "quick win." Our roadmap became a mess. Nothing shipped well.

Then I worked with a PM who said no to 90% of requests. At first, it seemed rude. But here's what happened:

→ We actually shipped our core features on time
→ The features we built worked better (more focused)
→ Stakeholders respected her MORE, not less

Saying no isn't about being difficult. It's about protecting what matters.

The best PMs I know:
• Say no to preserve yes
• Say no with empathy and data
• Say no to protect the team's focus

What's the hardest thing you've had to say no to lately?

#ProductManagement #Leadership #Focus
```

### Twitter/X

**Character Limit:** 280 (or longer posts with premium)

**Best Practices:**
- Front-load the hook
- One clear idea per post
- Use line breaks for readability
- Leverage threads for longer thoughts
- Include visuals when possible
- 1-2 hashtags max (or none)
- Post frequently (multiple times per day okay)

**Content Types:**
- Hot takes
- Quick insights
- Questions
- Threads (deep dives)
- Links with commentary
- Replies and engagement

**Thread Format:**
```
1/ [Hook tweet - make them want to read more]

2/ [Context or setup]

3/ [Main point 1]

4/ [Main point 2]

5/ [Main point 3]

6/ [Conclusion or call-to-action]
```

**Example Single Tweet:**
```
Startup advice nobody tells you:

Your first 10 customers will ask for 10 completely different features.

If you build them all, you'll build a mess.

Pick ONE and build it so well the others can't help but want it too.
```

**Example Thread:**
```
1/ I've reviewed 500+ startup pitches as an investor. Here are the 5 mistakes I see in almost every deck:

2/ Mistake #1: Starting with the solution

Investors don't care about your product until they care about the problem. Lead with pain, not features.

3/ Mistake #2: Generic market size slides

"The market is $50B" tells me nothing. Show me your specific wedge and how you'll own it.

4/ Mistake #3: No proof

At seed stage, you need SOME signal: users, revenue, waitlist, anything. Ideas alone don't raise rounds.

5/ Mistake #4: Buried ask

Tell me what you're raising (how much, at what valuation) by slide 3. Don't make me hunt for it.

6/ Mistake #5: No clear next step

End with: "We're raising $X for Y. Can we follow up next week to discuss?" Make it easy to say yes.

Want the full breakdown? I wrote a guide: [link]
```

### Instagram

**Caption Limit:** 2,200 characters

**Best Practices:**
- Front-load value (first 2 lines visible)
- Use emojis for visual breaks
- Include call-to-action
- 5-10 hashtags in caption or first comment
- Tag location for local discovery
- Post consistently (1-2x per day)
- Use Stories for behind-the-scenes

**Content Types:**
- Visual storytelling
- Behind-the-scenes
- User-generated content
- Tips and tutorials
- Inspirational quotes
- Product showcases

**Format:**
```
[Hook emoji + first line that grabs attention]

[Story or value - use line breaks for readability]

[Key points with emoji bullets]
✨ Point 1
💡 Point 2
🚀 Point 3

[Call-to-action]

[Hashtags]
```

**Example:**
```
📸 This photo almost didn't happen.

We were wrapping up the shoot, everyone was tired, and I was ready to pack it in.

Then my designer said, "One more try. Different angle."

That "one more try" became our most-liked post ever (👆 this one).

Here's what I learned about creative work:

✨ The best stuff often comes AFTER you think you're done
💡 Fresh perspectives change everything
🎯 One more iteration usually beats calling it quits
🚀 Trust your team's instincts

Whether it's a photoshoot, a design, or a piece of writing - when your gut says "almost there," push for one more try.

What's your "one more try" story? Drop it below 👇

#CreativeProcess #Photography #TeamWork #NeverSettle #BehindTheScenes
```

### Threads (Meta)

**Character Limit:** 500 per post

**Best Practices:**
- Conversational, casual tone
- Use threads for longer thoughts
- Engage with replies quickly
- Mix text, images, and links
- Less formal than Twitter
- Foster community discussion

**Content Types:**
- Personal takes
- Ask me anything
- Quick tips
- Discussion starters
- Industry commentary

**Format:**
```
[Conversational hook]

[Main point with personality]

[Optional: Thread continuation]

[Question to drive engagement]
```

**Example:**
```
Hot take: Your personal brand isn't your LinkedIn headshot and a fancy title.

It's showing up consistently and being helpful.

I see so many people optimize their profiles and then... crickets. No posts, no engagement, no value shared.

Meanwhile, someone with a blank profile who drops great insights in replies every day? That person builds a real brand.

Brand = reputation over time.

Stop optimizing your appearance. Start showing up.

What's your take on personal branding? 🤔
```

### Facebook

**Best Practices:**
- More personal, community-focused
- Longer posts perform okay
- Use questions to drive comments
- Facebook Groups for niche communities
- Video content performs well

**Content Types:**
- Community updates
- Events
- Behind-the-scenes
- User stories
- Polls and questions

## Content Types & Templates

### 1. Announcement Post

**LinkedIn:**
```
Big news: [Announcement] 🎉

[Context - why this matters]

What this means:
• [Benefit 1]
• [Benefit 2]
• [Benefit 3]

[Call-to-action]

[Link]

#hashtag1 #hashtag2
```

**Twitter:**
```
We just launched [X]! 🚀

[One sentence on what it is]

[Link]

This has been months in the making. Thread on why we built it 👇
```

### 2. Thought Leadership

**LinkedIn:**
```
[Contrarian or interesting take]

Everyone tells you [common advice].

But here's what actually works:

[Your insight based on experience]

[Evidence or story]

[Key takeaway]

What's your experience with this?

#hashtag
```

**Twitter:**
```
Unpopular opinion:

[Your take]

Here's why:
[Thread or single tweet with reasoning]

Change my mind.
```

### 3. Value/Educational

**LinkedIn:**
```
[Number] lessons from [experience]:

1. [Lesson] - [Why it matters]
2. [Lesson] - [Why it matters]
3. [Lesson] - [Why it matters]

Which resonates most with you?

#hashtag
```

**Twitter Thread:**
```
1/ [Hook - promise value]

2/ [Lesson 1 with example]

3/ [Lesson 2 with example]

...

N/ [Recap and CTA]
```

### 4. Engagement/Question

**LinkedIn:**
```
Quick question for [audience]:

[Specific, interesting question]

[Optional: Your answer or context]

Drop your thoughts below 👇

#hashtag
```

**Twitter:**
```
[Simple, provocative question]

[Optional: Poll or context]

Go 👇
```

### 5. Story/Case Study

**LinkedIn:**
```
[Hook about a problem or situation]

[The challenge you faced]

Here's what we did:
→ [Action 1]
→ [Action 2]
→ [Action 3]

Results:
• [Outcome 1]
• [Outcome 2]

The lesson: [Key takeaway]

[Question or CTA]

#hashtag
```

### 6. Behind-the-Scenes

**Instagram:**
```
Real talk: [Honest admission] 😅

[Story about what really happened]

The highlight reel doesn't show:
✨ [Reality 1]
💡 [Reality 2]
🎯 [Reality 3]

Who else can relate? 👇

#authenticity #reallife #hashtag
```

## Hashtag Strategy

### LinkedIn
- 3-5 hashtags max
- Mix of broad and niche
- Place at end of post
- Use established, popular tags

Examples:
- #ProductManagement #Leadership
- #StartupLife #Entrepreneurship
- #TechCareer #SoftwareEngineering

### Twitter/X
- 1-2 max (or none)
- Only use if adds value
- Don't overdo it
- May use in replies

### Instagram
- 5-10 hashtags
- Mix of sizes (popular + niche)
- In caption or first comment
- Use relevant, searchable tags

### Threads
- Emerging - use sparingly
- More casual than Twitter
- Test what works

## Engagement Best Practices

### When to Post

**LinkedIn:**
- Tue-Thu: 8am-2pm
- Avoid weekends

**Twitter/X:**
- Mon-Fri: 8am-4pm
- Evening threads work too
- Multiple times per day okay

**Instagram:**
- Wed 11am, Fri 10am-11am
- Consistency matters more

**Threads:**
- Still emerging - test times
- Real-time engagement matters

### How to Drive Engagement

**Ask Questions:**
- End posts with questions
- Make them specific and interesting
- Respond to every comment

**Use Storytelling:**
- Personal stories > generic advice
- Specifics > generalities
- Vulnerability > perfection

**Be Visual:**
- Include images, videos, graphics
- Carousel posts (LinkedIn, Instagram)
- Screenshots with highlights

**Respond Quickly:**
- First hour is critical
- Reply to comments
- Like and engage back

**Tag Strategically:**
- Tag people mentioned
- Tag collaborators
- Don't over-tag

## Content Calendar Framework

**Weekly Mix (LinkedIn example):**
- Monday: Motivational/kick-off week
- Tuesday: Educational/tips
- Wednesday: Industry news/commentary
- Thursday: Personal story/lesson
- Friday: Wins/celebration

**Content Pillars:**
Choose 3-5 themes to rotate:
- Expertise/thought leadership
- Behind-the-scenes
- Team/culture
- Product/service
- Industry news/trends

## Common Pitfalls to Avoid

- **Over-Promoting**: 80% value, 20% promotion
- **Being Too Generic**: Specific stories beat platitudes
- **Ignoring Comments**: Engagement is a conversation
- **Inconsistent Posting**: Consistency beats perfection
- **Wrong Platform Tone**: LinkedIn isn't Twitter
- **Hashtag Spam**: More isn't better
- **No Call-to-Action**: Tell them what to do
- **Posting and Ghosting**: Engage with responses

## Metrics to Track

- **Engagement Rate**: Likes + comments + shares / followers
- **Reach**: How many people saw it
- **Click-Through Rate**: For posts with links
- **Follower Growth**: Are you attracting the right people?
- **Best Performing Content**: What to do more of

## Integration Points

- **Scheduling Tools**: Buffer, Hootsuite, Later
- **Analytics**: Native platform insights
- **Content Library**: Bank of images, quotes, stats
- **Brand Guidelines**: Tone, hashtags, visual style
- **CRM**: Track social leads and interactions
