# Difficult Workplace Conversations Skill

A structured framework for navigating challenging workplace conversations with confidence and effectiveness. This skill provides comprehensive guidance for preparation, delivery, and follow-up of difficult discussions including conflicts, performance issues, sensitive feedback, and emotionally charged interactions.

## Purpose

Workplace conversations become difficult when emotions run high, stakes feel significant, or relationships are at risk. This skill exists to help you:

- Transform anxiety-inducing conversations into productive discussions
- Prepare thoroughly so you enter conversations with clarity and confidence
- Navigate defensive reactions and emotional moments gracefully
- Achieve resolution while preserving or strengthening relationships
- Follow up effectively to ensure lasting change

The skill is built on the Preparation-Delivery-Followup framework, which research shows dramatically improves conversation outcomes.

## When to Use

Activate this skill when you need to:

- Prepare for a challenging conversation with a colleague, manager, or direct report
- Address performance issues or missed expectations
- Deliver difficult or critical feedback
- Navigate conflict between yourself and others (or mediate between team members)
- Discuss sensitive topics (compensation, promotion, termination, personal matters)
- Handle emotional or defensive reactions during discussions
- Follow up after difficult conversations to ensure agreements stick

**Trigger Phrases:**
- "I need to have a tough conversation with..."
- "How do I address this performance issue?"
- "Help me prepare for a difficult discussion"
- "What should I say when giving critical feedback?"
- "How do I handle conflict with my coworker?"
- "I need to talk to my manager about..."

## How It Works

### The Three-Phase Framework

The skill guides you through three distinct phases, each critical to success:

**Phase 1: Preparation (40% of Success)**

Most difficult conversations fail before they start. Thorough preparation includes:
1. Clarifying the facts (separating observations from interpretations)
2. Checking your emotional state and identifying triggers
3. Considering the other person's perspective and constraints
4. Defining clear goals (outcome, relationship, and identity goals)
5. Planning the time, place, and your opening statement

**Phase 2: Delivery (The Conversation)**

The actual conversation follows a structured flow:
1. Open neutrally with purpose, intent, and an invitation to dialogue
2. Share your perspective using the SBI model (Situation-Behavior-Impact)
3. Listen actively to understand their viewpoint
4. Explore together to find common ground and solutions
5. Agree on specific actions, timelines, and check-ins

**Phase 3: Follow-up (Ensuring Lasting Change)**

After the conversation:
1. Document agreements within 24 hours
2. Check progress at scheduled intervals
3. Acknowledge improvements and address continued issues
4. Maintain the relationship separate from the issue

## Key Features

### Core Frameworks

- **Preparation-Delivery-Followup Model**: The three-phase approach that structures your entire process
- **SBI Model**: Situation-Behavior-Impact framework for delivering feedback without triggering defensiveness
- **Impact vs. Intent Separation**: Focusing on observable behavior and its effects rather than assumed intentions

### Ready-to-Use Resources

- **Opening Scripts**: Templates for starting conversations in performance, conflict, feedback, and sensitive topic contexts
- **Response Phrases**: Techniques for acknowledging without agreeing, redirecting to facts, buying time, and returning to your main point
- **Reframing Techniques**: Transform blame into curiosity, character judgments into behavior observations, and positions into interests

### Emotional Regulation Support

- Pre-conversation rituals for managing anxiety and anger
- In-the-moment techniques for staying calm when triggered
- Post-conversation processing for learning and recovery
- Long-term resilience building practices

### Comprehensive Templates

- Quick Prep worksheet (10 minutes) for time-constrained situations
- Full Prep worksheet (30 minutes) for high-stakes conversations
- Specialized prompts for performance, conflict, upward, and compensation conversations

## Usage Examples

### Example 1: Addressing Missed Deadlines

```
You: I need to have a difficult conversation with a team member who has missed
three deadlines this month. How should I approach this?

Claude: [Activates difficult-workplace-conversations skill]

Let me help you prepare using the three-phase framework...

**Preparation:**
- Issue: Three missed deadlines in past month
- Impact: Project delayed, team members blocked
- Goal: Understand root cause, agree on prevention plan

**Suggested Opening:**
"I wanted to check in about the recent deliverables. I've noticed the last
three have come in past deadline, and I'd like to understand what's happening
and how we can address it together."

[Continues with full preparation guidance...]
```

### Example 2: Peer Conflict Resolution

```
You: A colleague publicly criticized my work in a meeting yesterday.
I'm hurt and angry. What should I do?

Claude: [Activates difficult-workplace-conversations skill]

Let me help you process this and prepare for a productive conversation...

First, let's separate facts from interpretations:
- Fact: Your colleague said [specific words] in the meeting
- Impact: You felt embarrassed and trust was damaged
- Story you might be telling: "They don't respect me"

Before having this conversation, check your emotional readiness. Since you're
feeling hurt and angry, consider waiting 24 hours...

[Provides full guidance including opening script, response phrases for
defensive reactions, and follow-up plan...]
```

### Example 3: Asking for a Raise

```
You: I want to ask my manager for a raise. I'm nervous about it.
Can you help me prepare?

Claude: [Activates difficult-workplace-conversations skill]

Let's prepare using the full preparation template for compensation conversations...

**Additional Questions to Consider:**
1. What is your market value? (Gather research data)
2. What are your key accomplishments since your last adjustment?
3. What is the timing relative to budget cycles?
4. What alternatives to salary might you accept?

**Suggested Opening:**
"I'd like to discuss my compensation. I've been here two years, taken on the
payments project leadership, and want to make sure my salary reflects my
contributions and the current market."

[Continues with negotiation strategies and response handling...]
```

## Key Principles

### Separate Impact from Intent

- **What happened**: Observable behavior only
- **What you felt**: Your emotional response
- **What you assume**: Their intention (often wrong)

Focus your conversation on behavior and impact, not assumed intentions.

### Managing Emotions Before They Manage You

| If You Feel | Before Acting |
|-------------|---------------|
| Angry | Wait 24 hours, write but don't send |
| Hurt | Talk to a neutral party first |
| Anxious | Practice the conversation |
| Defensive | Identify your contribution |

### When to Escalate

Escalate to HR or management when:
- Safety is at risk
- Legal issues are involved
- Repeated conversations haven't worked
- Power dynamics prevent resolution
- You need formal documentation

## Best Practices

### Do

- Prepare thoroughly, especially for high-stakes conversations
- Focus on observable behaviors, not character judgments
- Use "I" statements instead of "you always" accusations
- Listen to understand, not just to respond
- Follow up as promised
- Allow time for emotions to settle before having the conversation

### Avoid

**In Preparation:**
- Scripting every word (you'll sound robotic)
- Building a case (this isn't a trial)
- Waiting too long (issues compound)

**In Delivery:**
- Starting with "You always..." (triggers defensiveness)
- Burying the lead (get to the point)
- Asking leading questions ("Don't you think...")

**In Follow-up:**
- Forgetting to check in (without follow-up, nothing changes)
- Holding grudges (issue resolved means relationship continues)
- Over-documenting (not everything needs a written record)

## Success Metrics

A successful difficult conversation achieves:

- Both parties feel heard
- Specific actions are agreed upon
- The relationship is preserved or improved
- The issue doesn't recur (or has clear escalation path)
- Neither party is blindsided later

## Related Skills

- **feedback-mastery**: Deep dive into the SBI feedback model (more focused on feedback mechanics)
- **professional-effective-communication**: General workplace communication patterns

## Reference Materials

This skill includes detailed reference documents that are loaded progressively as needed:

- **conversation-framework.md**: Complete three-phase framework with scripts and examples
- **preparation-template.md**: Worksheets for preparing before difficult conversations
- **delivery-scripts.md**: Opening lines, response handling, and reframing techniques
- **emotional-regulation.md**: Managing your own emotions before, during, and after conversations
