---
name: difficult-workplace-conversations
description: Structured approach to workplace conflicts, performance discussions, and challenging feedback using preparation-delivery-followup framework. Use when preparing for tough conversations, addressing conflicts, giving critical feedback, or navigating sensitive workplace discussions.
allowed-tools: Read, Glob, Grep
---

# Difficult Conversations Skill

A structured framework for approaching challenging workplace conversations including conflicts, performance issues, sensitive feedback, and emotionally charged discussions.

## When to Use This Skill

- Preparing for a challenging conversation with a colleague
- Addressing performance issues with a team member
- Delivering difficult feedback to a peer or manager
- Navigating conflict between team members
- Discussing sensitive topics (salary, promotion, termination)
- Handling emotional or defensive reactions
- Following up after difficult discussions

## Core Framework: Preparation-Delivery-Followup

Difficult conversations succeed or fail based on three phases:

### Phase 1: Preparation (Before)

**Purpose:** Set yourself up for a productive conversation

1. **Clarify the Issue**
   - What specifically happened? (Observable facts only)
   - What is the impact? (On you, team, work)
   - What do you need to change?

2. **Check Your Emotions**
   - What am I feeling? Why?
   - Am I calm enough to have this conversation?
   - What might trigger me during this conversation?

3. **Consider Their Perspective**
   - How might they see this situation?
   - What constraints or pressures might they have?
   - What do they care about that I can acknowledge?

4. **Define Your Goal**
   - What outcome do I want?
   - What is the minimum acceptable result?
   - What am I willing to compromise on?

### Phase 2: Delivery (During)

**Purpose:** Have the conversation effectively

1. **Open Neutrally**
   - Start with facts, not judgments
   - Express intent to understand, not accuse
   - Create psychological safety

2. **Share Your Perspective**
   - Describe behavior, not character
   - Focus on impact, not intention
   - Use "I" statements, not "you always"

3. **Listen Actively**
   - Ask clarifying questions
   - Acknowledge their viewpoint
   - Look for shared interests

4. **Seek Resolution**
   - Propose specific actions
   - Agree on next steps
   - Set check-in timeline

### Phase 3: Followup (After)

**Purpose:** Ensure lasting resolution

1. **Document Agreements**
   - What was agreed?
   - Who does what by when?
   - How will you measure success?

2. **Check Progress**
   - Follow up as promised
   - Acknowledge improvements
   - Address continued issues promptly

3. **Maintain Relationship**
   - Separate issue from person
   - Rebuild trust over time
   - Watch for regression

## Key Principles

### Separate Impact from Intent

**What happened:** Observable behavior
**What I felt:** Your emotional response
**What I assume:** Their intention (often wrong)

Focus conversation on behavior and impact, not assumed intentions.

### The SBI Model

**Situation:** When and where did this happen?
**Behavior:** What specifically did they do/say?
**Impact:** What was the effect on you, the team, or the work?

### Managing Emotions

| If You Feel | Before Acting |
| ----------- | ------------- |
| Angry | Wait 24 hours, write but don't send |
| Hurt | Talk to neutral party first |
| Anxious | Practice the conversation |
| Defensive | Identify your contribution |

### When to Escalate

Escalate when:

- Safety is at risk
- Legal issues involved
- Repeated conversations haven't worked
- Power dynamics prevent resolution
- You need documentation

## Conversation Types

### Performance Feedback

- Lead with specific examples
- Connect to expectations/standards
- Focus on future improvement
- Offer support and resources

### Conflict Resolution

- Hear both sides separately first
- Identify underlying interests
- Look for win-win solutions
- Document agreements

### Sensitive Topics

- Choose private, neutral setting
- Allow time for processing
- Be direct but compassionate
- Respect confidentiality

### Receiving Feedback

- Thank them for feedback
- Ask clarifying questions
- Don't defend immediately
- Reflect before responding

## References (Load When Needed)

### Detailed Frameworks

- **[Conversation Framework](references/conversation-framework.md)**: Complete three-phase framework with scripts and examples
- **[Preparation Template](references/preparation-template.md)**: Worksheet for preparing before difficult conversations
- **[Delivery Scripts](references/delivery-scripts.md)**: Opening lines, response handling, reframing techniques
- **[Emotional Regulation](references/emotional-regulation.md)**: Managing your own emotions before and during

## See Also

- `feedback-mastery` skill - SBI feedback model (overlaps but more feedback-focused)
- `professional-effective-communication` skill - General communication patterns

## Example Scenarios

### Scenario 1: Addressing Missed Deadlines

```markdown
**Issue:** Team member missed 3 deadlines in past month
**Impact:** Project delayed, others blocked
**Goal:** Understand root cause, agree on prevention plan

**Opening:** "I wanted to check in about the recent deliverables. I've noticed
the last three have come in past deadline, and I'd like to understand what's
happening and how we can address it together."
```

### Scenario 2: Peer Conflict

```markdown
**Issue:** Colleague publicly criticized your work in meeting
**Impact:** Embarrassed, trust damaged
**Goal:** Address behavior, rebuild working relationship

**Opening:** "I'd like to talk about what happened in yesterday's standup.
When you said my code 'missed obvious issues,' I felt called out in front
of the team. I'd like to understand your concerns and find a better way
to handle code quality feedback."
```

### Scenario 3: Asking Manager for Raise

```markdown
**Issue:** Feel underpaid relative to market/contribution
**Impact:** Demotivation, considering leaving
**Goal:** Discuss compensation, get timeline or adjustment

**Opening:** "I'd like to discuss my compensation. I've been here two years,
taken on the payments project leadership, and want to make sure my salary
reflects my contributions and the current market."
```

## Anti-Patterns to Avoid

### In Preparation

- **Scripting every word** - You'll sound robotic; prepare themes, not scripts
- **Building a case** - This isn't a trial; seek understanding, not winning
- **Waiting too long** - Issues compound; address promptly

### In Delivery

- **Starting with "You always..."** - Triggers defensiveness immediately
- **Burying the lead** - Get to the point; don't soften excessively
- **Asking leading questions** - "Don't you think..." isn't asking

### In Followup

- **Forgetting to check in** - Without follow-up, nothing changes
- **Holding grudges** - Issue resolved means relationship continues
- **Over-documenting** - Not everything needs written record

## Success Metrics

A successful difficult conversation:

- Both parties feel heard
- Specific actions are agreed
- Relationship is preserved or improved
- The issue doesn't recur (or has clear escalation)
- Neither party is blindsided later
