# Delivery Scripts for Difficult Conversations

Ready-to-use scripts, phrases, and techniques for navigating challenging moments.

## Opening Scripts

### Opening Formula

```text
[Purpose] + [Intent] + [Invitation]
```

### General Openings

**Collaborative tone:**
> "I'd like to talk about [topic]. My goal is to understand your perspective and share mine so we can [outcome]. Is this a good time?"

**Direct tone:**
> "We need to discuss [topic]. I want to be straightforward with you, and I also want to hear your side. Can we talk now?"

**Curious tone:**
> "I've noticed [observation] and I'd like to understand what's happening. Can you help me see your perspective?"

### Specific Situation Openings

**For Performance Issues:**
> "I wanted to check in about [specific area]. I've noticed [specific observation], and I'd like to understand what's happening from your end so we can address it together."

**For Conflict with Peer:**
> "I'd like to clear the air about [incident/pattern]. I value our working relationship and want to address this before it affects our collaboration. Can we talk?"

**For Feedback to Manager:**
> "I have some feedback I'd like to share. I'm bringing this up because I want our working relationship to be as effective as possible. Are you open to hearing it?"

**For Requesting Something (Raise, Promotion):**
> "I'd like to discuss my [compensation/career path]. I've prepared some thoughts, and I'm also interested in understanding your perspective on my trajectory here."

**For Sensitive Personal Topic:**
> "I need to discuss something personal that's affecting my work. I want to be transparent with you while also keeping some boundaries. Is now a good time?"

## Response Phrases

### Acknowledging Without Agreeing

When you need to show you heard them without conceding your point:

- "I hear that you see it differently..."
- "I understand that's your experience..."
- "That makes sense from your perspective..."
- "I can see why you'd feel that way..."
- "Thank you for helping me understand your view..."

### Redirecting to Facts

When the conversation gets emotional or accusatory:

- "Let's go back to what actually happened..."
- "Can we focus on the specific incident?"
- "Setting aside intentions, what was the impact?"
- "What would a video camera have shown?"

### Buying Time

When you need a moment to think:

- "That's an interesting point. Let me think about that."
- "I want to respond thoughtfully. Give me a moment."
- "I hadn't considered that angle. Let me process it."
- "Can you say more about that? I want to make sure I understand."

### Returning to Your Point

When the conversation has drifted:

- "I want to make sure we address the main issue..."
- "Coming back to what we were discussing..."
- "Let me return to my original concern..."
- "Before we close, I want to revisit..."

## Handling Defensive Responses

### When They Deny

**They say:** "That didn't happen" / "That's not what I said"

**Options:**

- "Help me understand how you remember it. Let's compare notes."
- "I have a different recollection. Can we look at [evidence]?"
- "Whether or not we agree on what happened, can we agree on [impact]?"
- "I may have misunderstood. Tell me your version."

### When They Deflect

**They say:** "What about when YOU did X?" / "Everyone does that"

**Options:**

- "I'm happy to discuss that separately. Right now, I'd like to focus on..."
- "You may be right about that. And, I still need to address this."
- "I appreciate you raising that. Can we first finish discussing this?"
- "Let's park that for now and come back to it. My concern right now is..."

### When They Attack

**They say:** "You're being unfair" / "You're overreacting"

**Options:**

- "I understand you see it that way. Can you help me understand your perspective?"
- "I hear that you feel this is unfair. Tell me what fairness looks like to you."
- "I'm trying to have a constructive conversation. What do you need from me?"
- "I may be wrong. Help me see what I'm missing."

### When They Shut Down

**Signs:** Silence, one-word answers, crossed arms, looking away

**Options:**

- "I notice you've gotten quiet. What's coming up for you?"
- "It seems like something I said landed wrong. Can we talk about it?"
- "I want to hear your perspective. What would help you share it?"
- "Would it help to take a break and come back to this?"

### When They Get Emotional

**Signs:** Tears, raised voice, visible distress

**Options:**

- "I can see this is bringing up strong feelings. Take your time."
- "Would you like a moment? We can pause."
- "Your reaction tells me this matters to you. Help me understand."
- "I didn't mean to upset you. What did I say that hit hard?"

## Reframing Techniques

### From Blame to Curiosity

**Instead of:** "Why did you miss the deadline?"
**Try:** "Help me understand what happened with the timeline."

**Instead of:** "You should have told me."
**Try:** "I would have liked to know earlier. What prevented that?"

### From Character to Behavior

**Instead of:** "You're unreliable."
**Try:** "When deadlines are missed, it creates problems for the team."

**Instead of:** "You're being difficult."
**Try:** "I'm having trouble understanding your position. Can you explain?"

### From Past to Future

**Instead of:** "You always do this."
**Try:** "Going forward, how can we handle this differently?"

**Instead of:** "That presentation was a disaster."
**Try:** "For the next presentation, let's talk about what would make it stronger."

### From Positions to Interests

**Instead of:** "I need you to do X."
**Try:** "The outcome I'm trying to achieve is Y. What would work for you?"

**Instead of:** "That won't work for me."
**Try:** "My concern with that is... What alternatives can we explore?"

## Closing Scripts

### Summarizing Agreement

> "Let me make sure I understand what we've agreed:
> [Person A] will [action] by [date].
> [Person B] will [action] by [date].
> We'll check in on [date].
> Does that match your understanding?"

### Acknowledging Progress

> "I appreciate you having this conversation with me. Even if we don't have everything solved, I feel like we understand each other better."

### Setting Follow-Up

> "I'd like to check in on this in [timeframe]. Does [date/time] work for you?"

### Leaving Door Open

> "If anything comes up before our check-in, please let me know. I want to address things as they arise."

### When Resolution Isn't Reached

> "We don't seem to be reaching agreement today. I'd like to [sleep on it / get more information / involve X]. Can we reconvene [when]?"

## Specific Scenario Scripts

### Performance Conversation

**Opening:**
> "I wanted to discuss your work on [project/area]. I've noticed [specific observation] and want to understand what's happening so we can address it."

**Sharing Impact:**
> "When [behavior], the impact is [effect]. For example, [specific instance]."

**Inviting Response:**
> "I'd like to hear your perspective. What's been going on from your end?"

**Moving to Solution:**
> "Given what we've discussed, what do you think would help improve this?"

**Setting Expectation:**
> "Going forward, I need to see [specific behavior]. Let's check in [when] to see how it's going."

### Giving Critical Feedback to Peer

**Opening:**
> "I wanted to share some feedback about [topic]. I'm bringing this up because I value working with you and think this could help."

**The Feedback:**
> "In [situation], when [behavior], the impact was [effect]. I want to share this because [positive intent]."

**Seeking Dialogue:**
> "How does this land with you? I'm curious about your perspective."

### Receiving Difficult Feedback

**Acknowledging:**
> "Thank you for telling me. I appreciate you being direct."

**Clarifying:**
> "Can you give me a specific example so I can understand better?"

**Processing:**
> "I need some time to think about this. Can I follow up with you [when]?"

**Committing:**
> "I hear what you're saying about [summary]. I'm going to work on [specific action]."

### Upward Feedback (to Manager)

**Opening:**
> "I have some feedback I'd like to share. I'm hoping this can help us work together even better."

**The Feedback:**
> "When [situation], I find myself [feeling/struggling with] because [impact]. I'm wondering if [alternative approach] might work better."

**Inviting Response:**
> "I may be missing context. Help me understand your perspective."

### Escalating an Issue

**Opening:**
> "I need to bring something to your attention. I've tried to address it directly, and I'm now at a point where I need your help."

**Background:**
> "Here's what's happened: [facts]. Here's what I've tried: [attempts]. Here's where we are: [current state]."

**Ask:**
> "I'm hoping you can [specific help needed]. What do you think the right next step is?"
