# Domain Name Brainstormer

Generates creative domain name ideas for your project and checks availability across multiple TLDs (.com, .io, .dev, .ai, etc.). Saves hours of brainstorming and manual checking.

## Purpose

Finding the perfect domain name is time-consuming and frustrating. You think of a great name, only to find it's taken. This skill automates the entire process by generating creative, relevant domain options and checking which ones are actually available to register.

## When to Use This Skill

Use this skill when you need to:
- Find a domain name for a new project, startup, or company
- Launch a product or service
- Create a personal brand or portfolio site
- Rebrand an existing project
- Find available alternatives when your first choice is taken
- Discover creative naming options you haven't considered

## How It Works

1. **Understanding**: Analyzes your project description, target audience, and key features
2. **Generation**: Creates memorable, brandable domain name options
3. **Availability Check**: Verifies domain availability across multiple TLDs (.com, .io, .dev, .ai, .app, etc.)
4. **Recommendations**: Provides ranked suggestions with branding insights
5. **Alternatives**: Suggests variations and similar options if top choices are taken

## Key Features

- **Multiple TLD Support**: Checks .com, .io, .dev, .ai, .app, .co, .xyz, and more
- **Branding Insights**: Explains why certain names work well for your use case
- **Availability Status**: Shows which domains are available, taken, or premium
- **Pricing Context**: Provides estimated costs for different domain types
- **Industry-Specific**: Tailored suggestions based on your project type
- **Creative Variations**: Generates alternatives you might not think of

## Usage Examples

### Basic Usage

```
I'm building a project management tool for remote teams. Suggest domain names.
```

```
Help me brainstorm domain names for a personal finance app
```

### With Preferences

```
I need a domain name for my AI writing assistant. Prefer short names with .ai or .io extension.
```

```
Suggest domain names using the words "pixel" or "studio" for my design agency
```

### Advanced Usage

```
Check availability for "codebase" and similar variations across .com, .io, .dev
```

```
Suggest domain names for a sustainable fashion brand, checking .eco and .fashion TLDs
```

## Example Output

For a developer tool for sharing code snippets:

```
🎯 Domain Name Suggestions

## Available (.com)
1. ✓ snippetbox.com - Clear, memorable, available!
   Why: Directly describes the product, easy to remember

2. ✓ codeclip.com - Short and snappy
   Why: Implies quick code sharing, only 8 characters

## Available (Alternative TLDs)
3. ✓ snippet.dev - Perfect extension for developers
   Why: .dev extension signals developer tool

4. ✓ codebox.io - Tech-forward
   Why: .io popular with tech startups, clean name

## Recommendations

🏆 Top Pick: snippet.dev
- Perfect for developer audience
- Short and memorable
- .dev extension adds credibility
- Available now!
```

## Tips for Success

1. **Act Fast**: Good domains get taken quickly once found
2. **Register Variations**: Secure both .com and industry-specific TLDs
3. **Avoid Numbers**: They're hard to communicate verbally
4. **Check Social Media**: Ensure @username is available too
5. **Say It Out Loud**: Test if it's easy to pronounce
6. **Think Long-term**: Will it still make sense in 5 years?

## What Makes a Good Domain

- **Short**: Under 15 characters is ideal
- **Memorable**: Easy to recall and spell
- **Pronounceable**: Can be said in conversation
- **Descriptive**: Hints at what you do
- **Brandable**: Unique enough to stand out
- **No Hyphens**: Easier to share verbally

## TLD Guide

- **.com**: Universal, trusted, great for businesses
- **.io**: Tech startups, developer tools
- **.dev**: Developer-focused products
- **.ai**: AI/ML products
- **.app**: Mobile or web applications
- **.co**: Alternative to .com
- **.design**: Creative/design agencies
- **.tech**: Technology companies

## See Also

For detailed documentation, workflows, and advanced features, see [SKILL.md](./SKILL.md).
