# Professional Communication

A comprehensive guide for effective professional communication in software development contexts, covering email structure, team messaging etiquette, meeting communications, and adapting messages for different audiences.

## Purpose

This skill provides frameworks and best practices for clear, professional written communication. It helps software developers improve their communication effectiveness across emails, team chats, meetings, and cross-functional interactions.

**Core principle:** Effective communication isn't about proving how much you know - it's about ensuring your message is received and understood.

## When to Use This Skill

Use this skill when you need help with:

- **Email composition** - Writing professional emails to teammates, managers, or stakeholders
- **Team messaging** - Crafting effective Slack/Teams/Discord messages
- **Meeting preparation** - Preparing agendas, summaries, and talking points
- **Audience adaptation** - Translating technical concepts for non-technical audiences
- **Status updates** - Structuring progress reports and project communications
- **Communication improvement** - Enhancing clarity and professionalism of written messages

**Trigger keywords**: email, chat, teams, slack, discord, message, writing, communication, meeting, agenda, status update, report

## How It Works

The skill is organized around several core frameworks:

### 1. The What-Why-How Structure
A universal framework for organizing any professional message:
- **What** - State the topic/request clearly
- **Why** - Explain the reasoning
- **How** - Outline next steps/action items

### 2. Three Golden Rules
1. Start with a clear subject/purpose
2. Use bullets, headlines, and scannable formatting
3. Put key messages first

### 3. Audience Calibration
Before communicating, consider:
- Who is the audience?
- What level of detail do they need?
- What's the value for them?

## Key Features

### Email Best Practices
- Subject line formulas
- Structured email templates
- Common email types (status update, request, escalation, FYI)
- Email vs chat decision framework

### Team Messaging Etiquette
- When to use chat vs email
- Thread management and @mention guidelines
- The "No Hello" principle for async communication
- Channel organization best practices

### Technical vs Non-Technical Communication
- Audience-specific approaches
- Jargon translation strategies
- Simplification without losing accuracy
- Plain language examples

### Writing Clarity Principles
- Active vs passive voice
- Eliminating filler words
- The "So What?" test
- Professional tone guidelines

### Meeting Communication
- Agenda best practices
- Facilitation tips
- Meeting summary format
- Action item tracking

## Usage Examples

### Example 1: Writing a Status Update Email

**Before (ineffective):**
```
Subject: Updates

Hey everyone, just wanted to give you an update on the project. We've been
working on a lot of things and making progress. There are some issues but
we're handling them. Let me know if you have questions.
```

**After (using frameworks from this skill):**
```
Subject: Project X: Week 12 Status Update - On Track with Minor Delay

Hi team,

We're on track for the Q1 release with a minor 1-week delay due to a critical bug.

**Progress This Week:**
- Completed authentication module (100%)
- API integration at 80% (was 60%)
- Found critical bug in payment processing

**Blockers:**
- Payment bug requires full regression testing
- Waiting on design approval for checkout flow

**Next Steps:**
- QA will complete retest by Thursday
- I'll update stakeholders Friday with revised timeline
- Design review scheduled for Monday

New target date: March 15 (was March 8)

Best,
[Your name]
```

### Example 2: Team Chat Message

**Before (ineffective):**
```
Hey
Are you there?
Can I ask you something?
```

**After (using "No Hello" principle):**
```
Hi Sarah - quick question about the deployment script.

Getting a permission error on line 42 when running deploy.sh:
`Error: Permission denied for /var/www/app`

Have you seen this before? I checked file permissions and they look correct.
```

### Example 3: Technical to Non-Technical Translation

**Before (too technical):**
```
We're implementing a microservices architecture with asynchronous message
processing via a Kafka event bus to enable horizontal scalability.
```

**After (accessible):**
```
We're splitting our system into smaller, independent pieces that communicate
through messages. This means:
- Each part can be updated without affecting the others
- We can easily add more resources to handle increased traffic
- The system processes tasks in the background for better performance
```

### Example 4: Meeting Agenda

**Before (vague):**
```
Meeting: Project Discussion
Time: Tuesday 2pm
Please attend.
```

**After (structured):**
```
Meeting: Project X Architecture Review
Time: Tuesday 2pm-3pm

**Objective:** Decide on database architecture for user data scaling

**Agenda:**
1. Review current limitations (10 min)
2. Present three scaling options (20 min)
3. Discuss tradeoffs (20 min)
4. Make decision (10 min)

**Preparation Required:**
- Review the architecture doc sent Monday (link)
- Come prepared with questions/concerns

**Expected Outcome:** Decision on which architecture to implement
```

## Additional Resources

This skill includes supporting reference documents:

- `references/email-templates.md` - Ready-to-use email templates by type
- `references/meeting-structures.md` - Structures for standups, retros, reviews
- `references/jargon-simplification.md` - Technical-to-plain-language translations

## Quick Reference Checklist

Before sending any professional communication, verify:

- [ ] Clear purpose - Can recipient understand intent in 5 seconds?
- [ ] Right audience - Is this the appropriate person/channel?
- [ ] Key message first - Is the main point upfront?
- [ ] Scannable - Are there bullets, headers, short paragraphs?
- [ ] Action clear - Does recipient know what they need to do?
- [ ] Jargon check - Will the audience understand terminology?
- [ ] Tone appropriate - Is it professional but not cold?
- [ ] Proofread - Any typos or unclear phrasing?

## Companion Skills

- `feedback-mastery` - For difficult conversations and feedback delivery
- `/draft-email` - Generate emails using these frameworks

## Version

- **v1.0.0** (2025-12-26) - Initial release
- Last Updated: 2025-12-22

---

**Note:** While this skill is designed for software developers, the frameworks and principles apply to professional communication in any field.
