# Citation Patterns for Medical Study Guides

## Purpose

Best practices for citing source material in study guides to enable easy verification.

---

## Why Citation Matters

**Verification:** Students/instructors can check any fact against source

**Accountability:** Every fact traceable to specific source location

**Quality assurance:** Makes hallucination detection easier

**Learning:** Students see where information came from in lecture/notes

---

## Citation Methods

### Method 1: Page Numbers (PDF Sources)

**Format:** Include page number after fact

```
Drug A blocks enzyme X (p. 45)
Drug A indicated for hypertension (p. 47)
```

**When to use:**
- PDF sources with page numbers
- Long documents where facts are on different pages

**Benefits:**
- Precise location
- Easy verification
- Standard academic format

### Method 2: Section Headers (Text Sources)

**Format:** Reference section name

```
Drug A mechanism (Source: Section 3 - Mechanisms of Action)
Drug A side effects (Source: Section 5 - Adverse Effects)
```

**When to use:**
- Text files with clear section headers
- Markdown files with headings

### Method 3: No Citation (Simple Sources)

**Format:** No citation if source is short

**When to use:**
- Source is <5 pages
- All information from same brief document
- Citation would be repetitive

**Add note at top:**
```
All information from: [source filename]
```

---

## Citation Placement

### Inline Citations (Preferred for Mixed Sources)

```
Drug A blocks enzyme X (p. 45), leading to decreased blood pressure.
Common side effects include nausea (p. 52) and headache (p. 53).
```

### End-of-Section Citations (Cleaner for Single-Source Sections)

```
Drug A Mechanism:
Drug A blocks enzyme X, leading to decreased blood pressure.

(Source: Lecture Notes pp. 45-46)
```

---

## Special Cases

### Conflicting Information in Source

**Mark both with citations:**
```
Dosing: 100mg daily (p. 12) OR 200mg daily (p. 45)
Note: Source contains conflicting information - verify with instructor
```

### Information from Tables/Figures

```
Drug comparison table (Source: Table 3, p. 67)
Mechanism diagram (Source: Figure 2, p. 23)
```

### Source References External Materials

```
Detailed mechanism: See First Aid p. 123 (reference in source, not included)
```

---

## Summary

**Best practices:**
- Cite page numbers for PDF sources
- Reference section headers for text sources
- Be consistent throughout study guide
- Enable easy verification

**Balance:**
- Don't over-cite (every sentence)
- Don't under-cite (no traceability)
- Use judgment based on source length and complexity

---

**See also:**
- [Source Validation Guide](source-validation-guide.md)
- [Complete Examples](complete-examples.md)
