# Learning Objective Preservation Guide

## Purpose

This guide ensures learning objective (LO) STATEMENTS are extracted exactly as written in source material - no paraphrasing, no rewording, no "improvements."

---

## Core Rule

<verbatim-requirement>
CRITICAL: Learning objective STATEMENTS must be copied EXACTLY as they appear in the source.
- Copy word-for-word, character-for-character
- Do NOT rephrase, summarize, or "improve" wording
- Preserve original numbering and sequence
- If an LO is long, still copy it completely
</verbatim-requirement>

---

## Scope: What This Applies To

### MUST be verbatim:
- Learning objective statements/questions
- The actual LO text from source (e.g., "Describe the mechanism of action...")
- Original numbering (1, 2, 3...)
- Original sequence/order

### Can be paraphrased (from source):
- Answers to the learning objectives
- Explanatory content
- Supporting information
- Drug details, mechanisms, side effects, etc.

---

## Examples

### CORRECT - Verbatim Extraction

**Source file:**
```
Learning Objectives:
1. Describe the mechanism of action of beta-blockers
2. List the adverse effects of beta-blocker therapy
3. Identify contraindications for beta-blocker use
```

**Study guide (CORRECT):**
```
1. Describe the mechanism of action of beta-blockers
   Answer: Beta-blockers competitively inhibit catecholamine binding at beta-adrenergic receptors...

2. List the adverse effects of beta-blocker therapy
   Answer: Bradycardia, hypotension, bronchospasm, fatigue...

3. Identify contraindications for beta-blocker use
   Answer: Severe bradycardia, heart block, decompensated heart failure...
```

✓ LO statements are EXACT copies
✓ Answers are paraphrased/organized from source content
✓ Original numbering preserved

---

### INCORRECT - Paraphrased LO Statements

**Source file:**
```
Learning Objectives:
1. Describe the mechanism of action of beta-blockers
2. List the adverse effects of beta-blocker therapy
3. Identify contraindications for beta-blocker use
```

**Study guide (INCORRECT):**
```
1. Explain how beta-blockers work  ← WRONG
   Answer: ...

2. What are the side effects of beta-blockers?  ← WRONG
   Answer: ...

3. When should beta-blockers be avoided?  ← WRONG
   Answer: ...
```

✗ LO statements were reworded
✗ "Describe" changed to "Explain"
✗ "adverse effects" changed to "side effects"
✗ "Identify contraindications" changed to "When should...be avoided"

---

## Common Paraphrasing Mistakes

| Source Says | Incorrect Paraphrase | Why It's Wrong |
|-------------|---------------------|----------------|
| "Describe the mechanism" | "Explain how it works" | Different verb, simplified |
| "List adverse effects" | "What are the side effects" | Changed to question format |
| "Identify contraindications" | "When not to use" | Oversimplified |
| "Compare and contrast" | "Explain the differences" | Lost "compare" aspect |
| "Discuss the pharmacokinetics" | "How is it absorbed/metabolized" | Broken into parts |

---

## Edge Cases

### Acceptable modifications:
- **Capitalization**: "describe" → "Describe" (for sentence start) ✓
- **Punctuation**: Adding period at end if missing ✓
- **Trimming whitespace**: Extra spaces removed ✓

### NOT acceptable:
- **Synonym substitution**: "adverse effects" → "side effects" ✗
- **Verb changes**: "Describe" → "Explain" ✗
- **Restructuring**: "Compare A and B" → "What's the difference between A and B" ✗
- **Shortening**: "Describe the mechanism of action" → "MOA of..." ✗
- **Expanding**: "List side effects" → "List and explain the side effects and their mechanisms" ✗

---

## Multi-Part Learning Objectives

**If source has compound LO:**
```
1. Describe the mechanism of action and list the indications for metformin
```

**CORRECT:** Copy entire compound LO as-is
```
1. Describe the mechanism of action and list the indications for metformin
```

**INCORRECT:** Split into separate LOs
```
1a. Describe the mechanism of action of metformin
1b. List the indications for metformin
```

---

## Verification Checklist

Before finalizing any study guide:

- [ ] Every LO statement matches source word-for-word
- [ ] LO numbering matches source order
- [ ] No LOs were combined or split
- [ ] No verbs were changed (describe/explain/list/identify/etc.)
- [ ] No synonyms were substituted
- [ ] Long LOs were copied completely (not shortened)

---

## Why This Matters

1. **Exam alignment**: Professors test on exact LO wording
2. **Consistency**: Same LO appears identically across all study materials
3. **Searchability**: Ctrl+F works when text is verbatim
4. **Verification**: Easy to confirm source accuracy
5. **Trust**: Users know LOs haven't been "interpreted"

---

## Quick Reference

| Component | Verbatim Required? |
|-----------|-------------------|
| LO statement text | YES - exact copy |
| LO numbering | YES - preserve order |
| Answer content | NO - can paraphrase from source |
| Drug names | YES - spell exactly |
| Formatting of answers | NO - can use bullets/tables |

---

## See Also

- [Source Validation Guide](source-validation-guide.md)
- [Hallucination Prevention](hallucination-prevention.md)
- [6-Step Verification Protocol](../study-guide-verifier/resources/6-step-protocol-detailed.md)
