# Verification Checklists

## Purpose

Step-by-step checklists for verifying source-only policy compliance at different stages of study guide creation.

---

## Pre-Creation Verification Checklist

**Run BEFORE starting study guide creation:**

### Source File Validation
- [ ] Source file path provided by user
- [ ] Source file exists and is readable
- [ ] Source file is medical/educational content
- [ ] Source file has sufficient detail (>100 words minimum)
- [ ] Source file format supported (.txt, .md, .pdf, .docx)

### Template Compatibility
- [ ] Source content matches requested template type
- [ ] Source has information for ALL required template sections
- [ ] Identified any gaps in source coverage
- [ ] Informed user of any incomplete sections

### Pre-Creation Documentation
- [ ] Confirmed source file location in session notes
- [ ] Noted template type to be used
- [ ] Documented any known gaps or limitations
- [ ] User approved proceeding despite any gaps

**If ANY checkbox unchecked → BLOCK creation until resolved**

---

## During-Creation Verification Checklist

**Monitor WHILE building study guide:**

### Fact-by-Fact Verification
- [ ] Reading facts directly from source (not from memory)
- [ ] Each fact can be traced to source location
- [ ] No facts added from general medical knowledge
- [ ] No inferences or extrapolations made
- [ ] Abbreviations used as-is from source (not expanded externally)

### Gap Handling
- [ ] Empty sections marked "Not covered in source material"
- [ ] Incomplete information noted (not silently filled)
- [ ] Missing details flagged for user awareness
- [ ] No assumptions made to fill gaps

### Mnemonic Management
- [ ] Using mnemonic-researcher agent for any researched mnemonics
- [ ] All researched mnemonics marked with (*)
- [ ] Source attribution provided for each mnemonic
- [ ] No invented mnemonics included
- [ ] Source-provided mnemonics used without asterisk

### Quality Monitoring
- [ ] Checking for accidental external additions
- [ ] Verifying facts against source periodically
- [ ] Marking [VERIFY] for any uncertain facts
- [ ] Maintaining source fidelity over completeness

---

## Post-Creation Verification Checklist

**Run AFTER completing study guide:**

### Comprehensive Review
- [ ] Re-read entire source file
- [ ] Cross-check every fact in study guide against source
- [ ] Verify all citations are accurate (page numbers, sections)
- [ ] Confirm no external facts added

### Mnemonic Verification
- [ ] Every researched mnemonic has asterisk (*)
- [ ] Every researched mnemonic has source attribution
- [ ] No unmarked mnemonics present
- [ ] Source-provided mnemonics properly distinguished

### Gap Documentation
- [ ] All incomplete sections marked clearly
- [ ] Gaps explained to user
- [ ] No silent gap-filling detected
- [ ] User aware of what's missing

### Template Compliance
- [ ] All required template sections present
- [ ] Template structure followed correctly
- [ ] Formatting consistent throughout
- [ ] No template violations

### Final QA
- [ ] Random sample of 10 facts verified against source
- [ ] No hallucinations detected
- [ ] Study guide usable for intended purpose
- [ ] Ready for post-creation verification (6-step protocol)

**If ANY checkbox unchecked → Fix before finalizing**

---

## Emergency Checklist (If Hallucination Suspected)

**Use if you think external facts may have been added:**

### Detection Steps
1. [ ] Re-read source file completely
2. [ ] List all facts in study guide
3. [ ] For each fact, find source location
4. [ ] Mark any facts you can't find in source

### Remediation Steps
1. [ ] Remove all facts not found in source
2. [ ] Replace removed facts with [Not in source] notation
3. [ ] Document what was removed (for learning)
4. [ ] Re-verify remaining facts

### Prevention Going Forward
1. [ ] Identify what caused hallucination
2. [ ] Apply appropriate prevention technique
3. [ ] Use more frequent verification
4. [ ] Consider requesting more detailed source

---

## Template-Specific Checklists

### Excel Drug Chart Checklist

**Verify each drug has ONLY source information:**
- [ ] Drug name spelled as in source
- [ ] Mechanism from source only
- [ ] Indications from source only (no standard uses added)
- [ ] Contraindications from source only (none if not in source)
- [ ] Side effects from source only (complete list from source, nothing added)
- [ ] Monitoring from source only (marked as missing if not in source)
- [ ] All tabs filled from source content only

### HTML Learning Objectives Guide Checklist

**Verify LO answers match source:**
- [ ] Each LO question answered from source
- [ ] No additional information added to answers
- [ ] Comparison tables built from source facts only
- [ ] Master tables extract source facts only (no new info)
- [ ] Summary tab synthesizes source only

### Clinical Assessment Guide Checklist

**Verify clinical content from source:**
- [ ] Chief complaints from source
- [ ] History questions from source (OLDCAARTS if applicable)
- [ ] Physical exam maneuvers from source
- [ ] Expected findings from source
- [ ] No standard physical exam additions if not in source

---

## Quick 5-Minute Verification

**Fast check before finalizing:**

1. **Random fact check (2 min):**
   - Pick 5 random facts
   - Find each in source
   - If can't find one → full audit needed

2. **Mnemonic scan (1 min):**
   - Search for asterisk (*)
   - Verify all researched mnemonics marked
   - Check source attributions present

3. **Gap check (1 min):**
   - Scan for "Not covered" markers
   - Verify gaps are real (check source)
   - Confirm no silent filling

4. **Template scan (1 min):**
   - Verify structure matches template
   - Check all required sections present
   - Confirm formatting correct

**If any issues → Run full post-creation checklist**

---

## Verification Documentation Template

**For session notes:**

```
STUDY GUIDE VERIFICATION RECORD
================================

Study Guide: [filename]
Source File: [source filename]
Template Type: [Excel/HTML/Word, specific template]
Created: [date/time]

Pre-Creation Verification: ✅ PASS / ❌ FAIL
- Source file validated: [Y/N]
- Template compatibility confirmed: [Y/N]
- Known gaps documented: [list or none]

During-Creation Monitoring: ✅ PASS / ❌ FAIL
- Source-only policy maintained: [Y/N]
- Gaps marked appropriately: [Y/N]
- Mnemonics researched and marked: [Y/N]

Post-Creation Verification: ✅ PASS / ❌ FAIL
- Random fact check: [X/10 verified]
- Mnemonic verification: [all marked Y/N]
- Gap documentation complete: [Y/N]
- Hallucinations detected: [Y/N - if yes, describe]

Final Status: ✅ APPROVED / ⚠️ NEEDS REVISION / ❌ FAILED

Notes: [any issues, concerns, or special considerations]
```

---

## Escalation Protocol

**If verification fails:**

1. **Minor issues (1-2 external facts):**
   - Remove facts
   - Mark sections as gaps
   - Document what was removed
   - Proceed with caution

2. **Moderate issues (3-5 external facts):**
   - Full source re-read required
   - Complete fact-by-fact audit
   - Remove all external additions
   - Consider redoing study guide

3. **Major issues (6+ external facts or systematic hallucination):**
   - STOP and review process
   - Identify root cause (sparse source? rushing? complexity?)
   - Discard study guide and restart
   - Apply stricter verification (section-by-section method)

---

## Summary

**Three verification gates:**
1. **Pre-Creation:** Validate source before starting
2. **During-Creation:** Monitor for external additions
3. **Post-Creation:** Comprehensive final check

**Core verification principle:**
Every fact must be traceable to source location

**When in doubt:**
Over-verify rather than under-verify

**Remember:**
Source fidelity > Study guide completeness

---

**See also:**
- [Source Validation Guide](source-validation-guide.md)
- [Hallucination Prevention](hallucination-prevention.md)
- [Complete Examples](complete-examples.md)
