---
name: space-monitor
description: Monitor and manage disk space usage across WSL and Windows with intelligent cleanup recommendations
---

# space-monitor

## Overview

Monitor disk space usage in real-time, especially critical for WSL environments where Windows C: drive space can become constrained. Provides intelligent cleanup recommendations and tracks space during operations.

## Usage

```bash
space-monitor <command> [options]
```

## Commands

### Quick Status
```bash
space-monitor check          # Show current space usage with color-coded warnings
space-monitor status         # Alias for check
```

### Monitor Operations
```bash
space-monitor watch <cmd>    # Monitor space during command execution
                            # Example: space-monitor watch "docker compose build"
```

### Analysis
```bash
space-monitor analyze        # Deep dive into space usage
                            # Shows Docker, caches, large directories
```

### Cleanup
```bash
space-monitor cleanup        # Safe cleanup recommendations
space-monitor cleanup --auto # Auto-cleanup safe items (caches, temp files)
space-monitor cleanup --docker # Docker-specific cleanup
```

### Trends
```bash
space-monitor trends         # Show space usage history
space-monitor trends --predict # Predict when space will run out
```

## When to Use

✅ **Use this skill when:**
- Starting Docker builds or large operations
- System feels slow or space warnings appear
- Before installing large packages or dependencies
- Planning cleanup to free space
- Troubleshooting "no space left" errors

⚠️ **Especially important for:**
- WSL environments (Windows C: drive constraints)
- Docker-heavy development
- Node.js projects with many node_modules
- Systems with < 10GB free space

## Color-Coded Warnings

- 🟢 **Green** (>10GB free): Healthy
- 🟡 **Yellow** (5-10GB free): Monitor
- 🟠 **Orange** (2-5GB free): Clean soon
- 🔴 **Red** (<2GB free): Critical - clean now!

## Quick Examples

```bash
# Before starting Docker
space-monitor check

# Monitor during build
space-monitor watch "docker compose up --build -d"

# Find space hogs
space-monitor analyze

# Get cleanup suggestions
space-monitor cleanup
```

## Scripts

- `scripts/main.sh` - Core monitoring and analysis functionality

Claude can execute this script directly without loading it into context.

## Additional Resources

For detailed information, see:
- [reference/thresholds.md](reference/thresholds.md) - Warning thresholds and meanings
- [reference/cleanup-guide.md](reference/cleanup-guide.md) - Safe cleanup strategies
- [reference/examples.md](reference/examples.md) - Common usage patterns

## Integration with Other Skills

Works well with:
- `docker-manage` - Docker cleanup recommendations
- `deps-manager` - Node modules analysis
- `backup-restore` - Before major operations
