---
name: spec-generator
description: Generate project and session specifications for large tasks. Use when estimated changes exceed max_commit_change_lines (250). Automatically extracts atomic tasks from complex requirements.
---

# Spec Generator Skill

You create and manage project and session specifications for complex features.

## When to Use This Skill

- Estimated changes exceed `max_commit_change_lines` (default: 250)
- User requests work on a complex feature requiring multiple stages
- Task needs to be broken down into atomic commits
- No current session_spec exists for the work

## Configuration

Read from `.ai/ai-settings.json`:
```json
{
  "framework": {
    "specs": {
      "project_spec": ".ai/specs/project_spec.md",
      "session_spec": ".ai/specs/session_spec.md",
      "max_commit_change_lines": 250,
      "extract_session_spec_when_estimated_commit_exceeds_limit": true
    }
  }
}
```

## Workflow

### Step 1: Estimate Commit Size

Review the planned changes and estimate lines changed:
```bash
# Check current diff
git diff --stat

# Or estimate based on files to be created/modified
```

If estimate > `max_commit_change_lines`:
- Proceed to spec generation
- Otherwise, work can proceed without formal specs

### Step 2: Check Existing Specs

```bash
# Check if project_spec exists
test -f .ai/specs/project_spec.md && echo "EXISTS" || echo "NEW"

# Check if session_spec exists
test -f .ai/specs/session_spec.md && echo "EXISTS" || echo "NEW"
```

### Step 3: Generate Project Spec (if new)

If `project_spec.md` doesn't exist, create it with:

**Structure**:
```markdown
# [Feature Name] - Feature Specification

> **Date:** YYYY-MM-DD
> **Branch:** `feature/branch-name`
> **Status:** In Progress

---

## Видение (Vision)

[2-3 sentence description of what this feature achieves]

---

## План реализации

### Этап 1: [Stage name]
**Цель:** [Goal description]

**Задачи:**
- [ ] Task 1
- [ ] Task 2

**Артефакты:**
- File1 ✅
- File2 ✅

**Критерий приёмки:** [Acceptance criteria]

---

## Критерии приёмки фичи

- [ ] Criterion 1
- [ ] Criterion 2

---

## Session Specs

Текущая сессия: [session_spec.md](.ai/specs/session_spec.md)
```

### Step 4: Generate Session Spec

Always create/update `session_spec.md` for atomic task:

**Structure**:
```markdown
# Session Spec: [Stage name]

> Атомарная задача в рамках feature/branch-name
> **Оценка:** ~250 строк изменений

---

## Цель

[Specific goal for this session]

---

## Scope (что входит)

1. **Component 1** (`path/to/file1`)
   - Detail 1
   - Detail 2

2. **Component 2** (`path/to/file2`)
   - Detail 1

---

## Out of Scope (не входит)

- Work for future stages
- Optional enhancements

---

## Критерии приёмки этапа

- [ ] Acceptance criterion 1
- [ ] Acceptance criterion 2

---

## Структура создаваемых/обновляемых файлов

[File tree or list]

---

## Статус: В ПРОЦЕССЕ

### Планируемые коммиты:

1. **commit-type(scope): description** (~est. lines)
   - Changes ✅
```

### Step 5: Update References

In `project_spec.md`, add/update:
```markdown
## Session Specs

Текущая сессия: [session_spec.md](.ai/specs/session_spec.md)
```

### Step 6: Atomic Task Extraction

Break down large work into chunks <=250 lines:

**Strategy**:
1. Group related files together
2. Ensure each chunk is logically complete
3. Order dependencies first
4. Testable units get their own commits

**Example breakdown**:
```
Stage: ThermoCalc Integration (total: ~800 lines)

Session 1: Config and Schemas (~200 lines)
  - config.py: ThermocalcConfig
  - schemas.py: Pydantic schemas
  - exceptions.py: Exception hierarchy

Session 2: HTTP Client (~150 lines)
  - client.py: ThermocalcClient
  - dependencies.py: FastAPI DI

Session 3: Router Integration (~200 lines)
  - router.py: API endpoints
  - events.py: Domain events
  - event_handlers.py: Event handlers

Session 4: UI Templates (~250 lines)
  - index.html: Main page
  - partials/: Result templates
```

## Output Format

### Spec Generation Success

```
Specifications Generated

**Project Spec:** .ai/specs/project_spec.md
- Feature: ThermoCalc API Integration
- Total Stages: 4
- Est. Total Changes: ~800 lines

**Session Spec:** .ai/specs/session_spec.md
- Current Stage: Stage 1 - Config and Schemas
- Est. Changes: ~200 lines
- Status: Ready to start

Next:
1. Review specs with user
2. Create feature branch if not exists
3. Begin Stage 1 implementation
```

## Triggers

Automatic invocation when:
1. User asks to implement a feature
2. Estimated changes > 250 lines
3. `extract_session_spec_when_estimated_commit_exceeds_limit: true`

## References

See [spec_templates.md](spec_templates.md) for full template documentation.
See [atomic_extraction.md](atomic_extraction.md) for task breakdown strategies.
See [templates/](templates/) for spec template files.
