# Spec Templates Reference

Complete templates for project and session specifications.

## Project Spec Template

```markdown
# [Feature Name] - Feature Specification

> **Дата:** YYYY-MM-DD
> **Ветка:** `feature/{short-description}`

---

## Видение

[2-3 sentence description of what this feature achieves]

---

## План реализации

### Этап 1: [Stage name]
**Цель:** [Goal description]

**Задачи:**
- [ ] Task 1
- [ ] Task 2

**Артефакты:**
- `path/to/file1.py` ✅
- `path/to/file2.py` ✅

**Критерий приёмки:** [Acceptance criteria]

---

## Критерии приёмки фичи

- [ ] Criterion 1
- [ ] Criterion 2

---

## Session Specs

Текущая сессия: [session_spec.md](.ai/specs/session_spec.md)
```

## Session Spec Template

```markdown
# Session Spec: [Stage name]

> Атомарная задача в рамках `feature/{branch-name}`
> **Оценка:** ~250 строк изменений

---

## Цель

[Specific goal for this session]

---

## Scope (что входит)

1. **Component 1** (`path/to/file1.py`)
   - Detail 1
   - Detail 2

2. **Component 2** (`path/to/file2.py`)
   - Detail 1

---

## Out of Scope (не входит)

- Work for future stages
- Optional enhancements

---

## Критерии приёмки этапа

- [ ] Acceptance criterion 1
- [ ] Acceptance criterion 2

---

## Статус: В ПРОЦЕССЕ

### Планируемые коммиты:

1. **feat(scope): description** (~est. lines)
   - [file1.py](../../path/to/file1.py) ✅
```

## Writing Good Specs

### Vision
✅ Good: "Integrate ThermoCalc API to provide thermodynamic calculations through web interface."
❌ Bad: "Add calculations."

### Acceptance Criteria
✅ Good: "Client successfully connects to localhost:8000 and returns status 200."
❌ Bad: "Client works."

### Atomic Commits
Break work into chunks <=250 lines:
1. Config and schemas (~200 lines)
2. HTTP client (~150 lines)
3. Router integration (~200 lines)
4. UI templates (~250 lines)
