---
name: steering
description: 作業指示毎の作業計画、タスクリストをドキュメントに記録するためのスキル。ユーザーからの指示をトリガーとした作業計画時、実装時、検証時に読み込む。
---

# Steering スキル

機能追加や大きな変更を行う際、このスキルに従って作業を進めてください。

## いつ使うか

- 新機能の追加
- 複数ファイルにまたがる変更
- 1時間以上かかりそうな作業

**使わなくていい場合**: バグ修正、ドキュメント更新、単一ファイルの小さな変更

## ディレクトリ構造

```
.steering/
└── YYYYMMDD-機能名/
    ├── requirements.md    # 要件定義（必須）
    ├── design.md          # 設計書（必須）
    └── tasklist.md        # タスクリスト（必須）
```

例: `.steering/20250102-book-crud/`

## テンプレート

各ファイルのテンプレートは `templates/` ディレクトリを参照:

- [requirements.md](templates/requirements.md) - 要件定義
- [design.md](templates/design.md) - 設計書
- [tasklist.md](templates/tasklist.md) - タスクリスト

---

## 4つのモード

### 1. 計画モード

**目的**: 作業を始める前に要件とタスクを明確にする

**手順**:

1. `.steering/YYYYMMDD-機能名/` ディレクトリを作成
2. `requirements.md` を作成（ユーザーと要件を確認）
3. `design.md` を作成（設計判断を記録）
4. `tasklist.md` を作成（具体的なタスクに分解）

---

### 2. 実装モード

**目的**: tasklist.md に従って実装を進める

**ルール**:

1. **tasklist.md が正式なドキュメント**
   - TodoWrite ツールは補助的に使用
   - ユーザーが見るのは tasklist.md
2. **タスク完了時は即座に更新**
   - `- [ ]` → `- [x]` に変更
   - 次のタスクに着手する前に必ず更新
3. **スキップは理由を明記**
   - 技術的な理由でスキップする場合のみ許可
   - `- [~] タスク名 (スキップ理由: xxx)` の形式
4. **追加タスクは末尾に追記**
   - 実装中に発見したタスクは tasklist.md に追加

**進捗更新の例**:

```markdown
### フェーズ1: 基盤

- [x] データベーススキーマ定義
- [x] リポジトリ層の実装
- [ ] サービス層の実装 ← 現在ここ
```

---

### 3. 振り返りモード

**目的**: 作業完了後に学びを記録

**手順**:

1. tasklist.md の「完了」日付を記入
2. tasklist.md 末尾の振り返りセクションを記入
3. 重要な決定事項は `docs/CONTEXT.md` にも転記

---

### 4. フィードバック対応モード

**目的**: 完了した機能に対するフィードバック（UX改善、バグ修正等）を継続対応する

**いつ使うか**:

`/continue-feature` コマンドで呼び出される。以下の条件を満たす場合に使用:

- 既存機能に対するフィードバック対応
- 複数ファイルに変更が必要
- 1時間以上の作業見込み

#### 軽微な修正の判断基準

以下の**両方**を満たす場合は、ステアリング不要で直接修正する:

| 条件     | 基準                          |
| -------- | ----------------------------- |
| 影響範囲 | 変更ファイルが1-2ファイル以内 |
| 作業時間 | 1時間未満で完了する見込み     |

**例**:

- 軽微: タイポ修正、スタイル微調整、エラーメッセージ変更
- 継続作業: 新規API追加、複数コンポーネント変更、ロジック修正

#### 追加対応セクションの形式

既存の `tasklist.md` に以下の形式で追記する:

```markdown
---

## 追加対応 (YYYY-MM-DD)

### フィードバック内容

- フィードバック1の概要
- フィードバック2の概要

### 追加タスク

- [ ] タスク1
- [ ] タスク2
```

**ルール**:

- 元のタスクリストは変更しない（履歴として保持）
- 追加対応セクションは複数回追記可能（日付で区別）
- 振り返りは追加対応ごとに記載

---

## 重要なルール

### やるべきこと

- 作業開始前に requirements.md を作成し、ユーザーの承認を得る
- tasklist.md は常に最新の状態を維持
- 1タスク完了ごとに tasklist.md を更新
- 作業完了後は振り返りを記録

### やってはいけないこと

- 未完了タスクを残したまま作業を終了
- tasklist.md の更新を後回しにする
- 要件を確認せずに実装を始める

---

## ワークフロー図

```
[ユーザーからの依頼]
        ↓
[計画モード] requirements.md 作成
        ↓
[ユーザー承認] ← 要件に問題あれば修正
        ↓
[計画モード] design.md 作成
        ↓
[ユーザー承認] ← 設計に問題あれば修正
        ↓
[計画モード] tasklist.md 作成
        ↓
[実装モード] タスクを1つずつ実行
        ↓ （各タスク完了時に tasklist.md 更新）
[全タスク完了]
        ↓
[振り返りモード] 学びを記録
        ↓
[完了]
```
