# Business Model Canvas Guide

The Business Model Canvas is a strategic tool for documenting and testing your startup's hypotheses about how you'll create, deliver, and capture value.

## The Nine Building Blocks

### 1. Customer Segments (CS)
**Who are your most important customers?**

**Questions to Answer:**
- For whom are you creating value?
- Who are your most important customers?
- Are they mass market, niche market, segmented, diversified, or multi-sided platform?

**Examples:**
- B2B: Small software teams (5-20 developers)
- B2C: Busy parents with children under 5
- B2B2C: Doctors prescribing to patients
- Multi-sided: Advertisers + Content Consumers (like Facebook)

**Validation Activities:**
- Interview 50+ people in target segment
- Verify they have the problem you're solving
- Confirm they can make buying decisions
- Test if they're accessible via your channels

**Hypotheses to Test:**
- Do they have the budget?
- Can you reach them cost-effectively?
- Are there enough of them?
- Do they buy similar products/services?

---

### 2. Value Propositions (VP)
**What value do you deliver to the customer?**

**Questions to Answer:**
- What problem are you solving?
- What customer need are you satisfying?
- What bundle of products/services are you offering?
- Why will customers choose you over alternatives?

**Value Proposition Types:**
- Newness (new solution to new problem)
- Performance (better/faster/stronger)
- Customization (tailored to specific needs)
- Design (superior user experience)
- Brand/Status (association with brand)
- Price (better value for money)
- Cost Reduction (save customers money)
- Risk Reduction (reduce customer risk)
- Accessibility (available to new customers)
- Convenience/Usability (easier to use)

**Validation Activities:**
- Test problem hypotheses with customers
- Validate customers care about the problem
- Confirm your solution solves the problem
- Verify customers will pay for the solution
- Test minimum viable product (MVP)

**Strong Value Prop Format:**
"We help [target customer] [solve problem/achieve goal] by [unique approach]."

Example: "We help software teams ship faster by automating code reviews."

---

### 3. Channels (CH)
**How do you reach and deliver value to customers?**

**Channel Phases:**
1. **Awareness:** How do customers learn about you?
2. **Evaluation:** How do customers evaluate your offering?
3. **Purchase:** How do customers buy from you?
4. **Delivery:** How do you deliver the value proposition?
5. **After-Sales:** How do you provide support?

**Channel Types:**
- **Direct:** Sales force, web sales, own stores
- **Indirect:** Partner stores, wholesalers, affiliates
- **Owned:** Company website, company retail stores
- **Partner:** Partner websites, partner retail stores

**Validation Activities:**
- Test multiple channels in parallel
- Measure cost per acquisition (CPA) by channel
- Test conversion rates by channel
- Verify channel economics work
- Validate customers prefer your chosen channels

**Questions to Test:**
- Can you reach customers at acceptable cost?
- Do customers trust this channel?
- Is the channel scalable?
- What margins does the channel require?

---

### 4. Customer Relationships (CR)
**What relationship does each customer segment expect?**

**Relationship Types:**
- Personal assistance (dedicated rep)
- Dedicated personal assistance (account manager)
- Self-service (no human interaction)
- Automated services (personalized self-service)
- Communities (user forums, social)
- Co-creation (customers create value)

**Relationship Goals:**
- **Acquisition:** Get new customers
- **Retention:** Keep existing customers
- **Growth:** Increase revenue per customer (upsell/cross-sell)

**Validation Activities:**
- Test onboarding process with early customers
- Measure customer satisfaction (NPS, CSAT)
- Track retention and churn rates
- Test support models (high-touch vs. low-touch)
- Validate lifetime value assumptions

**Questions to Test:**
- What level of support do customers expect?
- What's the cost of customer support?
- Does the relationship fit your business model?
- How do you onboard new customers?

---

### 5. Revenue Streams (R$)
**For what value are customers willing to pay?**

**Revenue Model Types:**
- **Asset Sale:** Sell ownership of physical product
- **Usage Fee:** Pay per use (like utilities)
- **Subscription:** Ongoing access fee
- **Lending/Leasing:** Temporary exclusive use
- **Licensing:** Permission to use IP
- **Brokerage:** Commission on transactions
- **Advertising:** Fee for advertising space
- **Freemium:** Free basic, paid premium

**Pricing Mechanisms:**
- Fixed pricing (list price, feature-dependent, volume-dependent)
- Dynamic pricing (negotiated, yield management, real-time market)

**Validation Activities:**
- Test willingness to pay with real offers
- Experiment with different price points
- Validate payment terms (monthly/annual)
- Test different revenue models
- Calculate customer lifetime value (LTV)

**Questions to Test:**
- What are customers currently paying?
- What would they be willing to pay?
- How do they prefer to pay?
- What's the impact of different pricing on demand?

**Key Metrics:**
- Average Revenue Per User (ARPU)
- Customer Lifetime Value (LTV)
- Payment conversion rate
- Average contract value

---

### 6. Key Resources (KR)
**What key resources does your value proposition require?**

**Resource Types:**
- **Physical:** Buildings, vehicles, machines, systems, inventory
- **Intellectual:** Brands, proprietary knowledge, patents, copyrights, data
- **Human:** Talent, especially in creative/knowledge industries
- **Financial:** Cash, credit lines, stock option pools

**Validation Activities:**
- Identify minimum resources needed for MVP
- Test if you can access required resources
- Validate cost of acquiring/maintaining resources
- Confirm resources can scale with business

**Questions to Test:**
- What assets are essential to deliver your value prop?
- Which resources are owned vs. leased vs. partner-provided?
- What's the cost structure for these resources?
- Can you acquire them at acceptable cost?

---

### 7. Key Activities (KA)
**What key activities does your value proposition require?**

**Activity Types:**
- **Production:** Designing, making, delivering product (manufacturing)
- **Problem-Solving:** Consulting, new solutions (service firms)
- **Platform/Network:** Maintaining platform, ecosystem (software platforms)

**Critical Activities:**
- Product development and improvement
- Customer acquisition and marketing
- Sales and business development
- Customer support and success
- Operations and fulfillment

**Validation Activities:**
- Map all activities required to deliver value
- Test which activities are core vs. outsourced
- Validate you can perform activities at required quality
- Measure time/cost for each key activity

**Questions to Test:**
- What activities are most critical to delivering your value prop?
- Which activities differentiate you from competitors?
- Can you perform these activities at scale?
- What's the cost of these activities?

---

### 8. Key Partnerships (KP)
**Who are your key partners and suppliers?**

**Partnership Types:**
- Strategic alliances between non-competitors
- Coopetition: Strategic partnerships between competitors
- Joint ventures to develop new businesses
- Buyer-supplier relationships

**Reasons for Partnerships:**
- **Optimization and economy of scale:** Reduce costs
- **Reduction of risk and uncertainty:** Share risks
- **Acquisition of resources and activities:** Access capabilities you don't have

**Validation Activities:**
- Identify critical partners needed
- Test partnership feasibility
- Validate partner economics work for both sides
- Confirm partners can deliver at scale

**Questions to Test:**
- Which key resources are acquired from partners?
- Which key activities do partners perform?
- What do partners get in return?
- Are partnerships strategic or commodity?

---

### 9. Cost Structure (C$)
**What are the most important costs in your business model?**

**Cost Structure Types:**
- **Cost-Driven:** Focus on minimizing costs (low price value prop)
- **Value-Driven:** Focus on value creation (premium value prop)

**Cost Characteristics:**
- **Fixed Costs:** Don't vary with volume (salaries, rent, manufacturing plant)
- **Variable Costs:** Vary with volume (raw materials, commission)
- **Economies of Scale:** Costs decrease as volume increases
- **Economies of Scope:** Costs decrease due to operational synergies

**Key Costs:**
- Cost of Goods Sold (COGS)
- Customer Acquisition Cost (CAC)
- Research & Development (R&D)
- Sales & Marketing
- General & Administrative (G&A)
- Infrastructure and hosting costs

**Validation Activities:**
- Estimate all cost categories
- Validate assumptions with real data
- Calculate unit economics
- Test if model is profitable at scale
- Measure burn rate and runway

**Questions to Test:**
- What are your most expensive resources?
- What are your most expensive activities?
- Can you reduce costs while maintaining value?
- At what scale does the business become profitable?

---

## How to Use the Business Model Canvas

### Step 1: Write Your Initial Hypotheses
Fill out the canvas with your assumptions. These are guesses, not facts.

### Step 2: Prioritize What to Test First
Identify your riskiest assumptions (usually Customer Segments and Value Proposition).

### Step 3: Get Out of the Building
Test your hypotheses through customer conversations, experiments, and MVPs.

### Step 4: Track Results
Document what you learn. Mark hypotheses as:
- ✓ Validated (proven with data)
- ✗ Invalidated (disproven with data)
- ? Uncertain (need more testing)

### Step 5: Iterate the Canvas
Update your canvas as you learn. Pivot when necessary.

### Step 6: Repeat Until Product/Market Fit
Keep iterating until you have a validated, repeatable, scalable business model.

---

## Business Model Canvas Template

```
+------------------------+------------------+------------------------+------------------+------------------------+
| KEY PARTNERS           | KEY ACTIVITIES   | VALUE PROPOSITIONS     | CUSTOMER         | CUSTOMER SEGMENTS      |
|                        |                  |                        | RELATIONSHIPS    |                        |
| Who are our key        | What key         | What value do we       | What type of     | For whom are we        |
| partners?              | activities do    | deliver?               | relationship     | creating value?        |
|                        | our Value Props  |                        | does each        |                        |
| Who are our key        | require?         | What problems do       | Customer Segment | Who are our most       |
| suppliers?             |                  | we solve?              | expect?          | important customers?   |
|                        | Our Distribution |                        |                  |                        |
|                        | Channels?        | What needs do we       |                  |                        |
|                        |                  | satisfy?               |                  |                        |
|                        | Customer         |                        |                  |                        |
|                        | Relationships?   |                        |                  |                        |
|                        |                  |                        |                  |                        |
|                        | Revenue          |                        |                  |                        |
|                        | Streams?         |                        |                  |                        |
|                        |                  |                        |                  |                        |
|                        +------------------+                        +------------------+                        |
|                        | KEY RESOURCES    |                        | CHANNELS         |                        |
|                        |                  |                        |                  |                        |
|                        | What key         |                        | Through which    |                        |
|                        | resources do     |                        | Channels do our  |                        |
|                        | our Value Props  |                        | Customer Segments|                        |
|                        | require?         |                        | want to be       |                        |
|                        |                  |                        | reached?         |                        |
|                        |                  |                        |                  |                        |
+------------------------+------------------+------------------------+------------------+------------------------+
| COST STRUCTURE                            | REVENUE STREAMS                                                     |
|                                           |                                                                     |
| What are the most important costs?        | For what value are customers willing to pay?                        |
|                                           |                                                                     |
| Which Key Resources are most expensive?   | What do they currently pay?                                         |
|                                           |                                                                     |
| Which Key Activities are most expensive?  | How would they prefer to pay?                                       |
|                                           |                                                                     |
+-------------------------------------------+---------------------------------------------------------------------+
```

---

## Business Model Patterns

### Pattern 1: SaaS (Software as a Service)
- **CS:** Small-to-medium businesses
- **VP:** Solve specific workflow problem
- **CH:** Web (self-service), inside sales for enterprise
- **CR:** Self-service + email support, account management for enterprise
- **R$:** Monthly/annual subscriptions
- **KR:** Software platform, technical talent
- **KA:** Product development, customer acquisition
- **KP:** Cloud infrastructure (AWS/Azure/GCP)
- **C$:** R&D, sales & marketing, infrastructure

### Pattern 2: Marketplace
- **CS:** Buyers + Sellers (two-sided)
- **VP:** Aggregate supply, facilitate transactions, reduce friction
- **CH:** Web, mobile apps
- **CR:** Self-service with community features
- **R$:** Transaction fees, subscriptions, advertising
- **KR:** Platform technology, network effects
- **KA:** Platform development, supply/demand growth
- **KP:** Payment processors, trust/safety services
- **C$:** Marketing (both sides), platform development, customer support

### Pattern 3: Freemium
- **CS:** Mass market users
- **VP:** Free basic version, premium features for pay
- **CH:** Web, app stores, viral growth
- **CR:** Self-service, community
- **R$:** Subscriptions (premium users), optional: advertising
- **KR:** Software platform, brand
- **KA:** Product development, user acquisition, conversion optimization
- **KP:** Cloud infrastructure, payment processors
- **C$:** R&D, infrastructure, marketing

### Pattern 4: Consulting/Services
- **CS:** Businesses needing expertise
- **VP:** Solve complex, unique problems
- **CH:** Direct sales, referrals, thought leadership
- **CR:** Personal assistance, dedicated account teams
- **R$:** Project fees, hourly rates, retainers
- **KR:** Expert talent, methodologies, reputation
- **KA:** Problem-solving, client relationships
- **KP:** Subcontractors, technology vendors
- **C$:** Personnel costs (largest), sales & marketing

---

## Common Business Model Mistakes

1. **Too many customer segments:** Start with one, nail it, then expand
2. **Value prop doesn't match customer pain:** Validate the problem first
3. **Channels are too expensive:** CAC must be < 1/3 LTV
4. **Revenue model doesn't match customer behavior:** Test willingness to pay early
5. **Cost structure doesn't support revenue model:** Unit economics must work
6. **Key resources/activities undefined:** Know what's actually required
7. **Dependencies on unvalidated partnerships:** Test partner feasibility early

---

## Unit Economics Sanity Check

**Minimum Viability Requirements:**
- LTV (Lifetime Value) > 3x CAC (Customer Acquisition Cost)
- Gross margin > 70% for software, >40% for services
- Payback period < 12 months
- Monthly churn < 5% for B2B SaaS, <7% for B2C
- Magic Number >0.75 (new revenue / sales & marketing spend)

**If economics don't work:**
- Increase prices (test willingness to pay)
- Reduce CAC (improve conversion, better channels)
- Increase LTV (reduce churn, upsell/cross-sell)
- Reduce COGS (optimize operations, economies of scale)
- Pivot business model if fundamentally broken

---

## Next Steps

1. Download blank canvas: strategyzer.com/canvas
2. Fill out initial hypotheses
3. Prioritize riskiest assumptions
4. Design experiments to test assumptions
5. Get out of the building
6. Update canvas with learnings
7. Iterate until product/market fit

**Remember:** The canvas is not your business plan. It's a hypothesis-testing tool. Update it constantly as you learn.