# Customer Discovery Question Bank

A comprehensive list of questions to ask during customer discovery interviews, organized by category.

## Opening Questions

**Build Rapport:**
- Tell me about your role and what you do day-to-day
- How long have you been doing this?
- What does a typical day look like for you?

**Context Setting:**
- Walk me through your workflow for [relevant activity]
- Tell me about the last time you [did relevant task]
- How do you currently handle [problem domain]?

## Problem Discovery

**Identify Pain Points:**
- What's the hardest part about [activity]?
- What frustrates you most about [current solution]?
- If you had a magic wand, what would you change about [process]?
- What keeps you up at night about [problem domain]?
- What's broken in your current approach?

**Severity Assessment:**
- On a scale of 1-10, how painful is this problem?
- How much time do you spend dealing with this issue?
- What does this problem cost you? (time, money, stress)
- How often does this problem occur?
- What happens if you don't solve this?

**Current Solutions:**
- What are you using today to solve this?
- What do you like about your current solution?
- What don't you like about your current solution?
- Why haven't you switched to something else?
- Have you tried other solutions? Why didn't they work?

## Solution Validation

**Need vs. Want:**
- Would this actually solve your problem?
- What would need to be true for you to switch?
- What features are must-haves vs. nice-to-haves?
- What would make you stop using this?
- Is this a vitamin (nice to have) or a painkiller (must have)?

**Willingness to Pay:**
- What do you currently pay for [similar solution]?
- What would a solution be worth to you?
- Would you pay for this? How much?
- What's your budget for solving this problem?
- Who controls the budget for this type of purchase?

**Buying Process:**
- How do you typically buy software/services like this?
- Who else needs to be involved in this decision?
- What's your typical procurement process?
- How long does it take to get budget approval?
- What would prevent you from buying this?

## Early Commitment

**Gauge Interest:**
- Would you be willing to try an early version?
- Would you pay for early access?
- Can I come back and show you a prototype?
- Would you sign a letter of intent?
- Would you be willing to be a reference customer?

**Next Steps:**
- When can we talk again?
- Can I observe you doing [task] in person?
- Who else on your team should I talk to?
- Who else has this problem that I should speak with?
- Would you introduce me to [relevant person]?

## Competitive Landscape

**Alternatives:**
- What else did you consider before choosing your current solution?
- What do you think of [competitor]?
- Why did you choose [current solution] over [competitor]?
- What would make you switch?
- If we didn't exist, what would you use?

## Segmentation Questions

**Company Size:**
- How many employees do you have?
- What's your annual revenue?
- How many people in your department/team?

**Use Case:**
- How would you use this?
- How often would you use this?
- Would this be for your whole team or just you?
- What outcome are you trying to achieve?

**Technical Environment:**
- What tools/platforms are you currently using?
- What's your tech stack?
- Do you have technical resources in-house?
- What integrations would you need?

## Red Flags to Watch For

**False Positives:**
- "That's interesting" (vs. "I need this now")
- "I would use that" (hypothetical vs. commitment)
- "My friend would love this" (not their problem)
- "You should add [feature]" (feature request instead of problem validation)
- "This is cool" (nice-to-have vs. must-have)

**Good Signals:**
- "How soon can I get this?"
- "Where do I sign up?"
- "Can I pay you now for early access?"
- "This solves exactly the problem I had yesterday"
- "Who else is using this?"

## Interview Best Practices

### Do:
- Listen more than you talk (80/20 rule)
- Ask open-ended questions
- Dig deeper with "why" questions
- Take detailed notes
- Ask for specific examples, not hypotheticals
- Get permission to record (for note-taking only)
- Ask who else you should talk to
- Thank them for their time

### Don't:
- Pitch your solution too early
- Lead the witness ("Wouldn't it be great if...")
- Accept compliments as validation
- Talk about features before understanding problems
- Ignore negative feedback
- Ask hypothetical questions ("Would you use...")
- Overstay your welcome (30-45 min max)
- Forget to follow up

## Sample Interview Structure

**Minutes 0-5:** Introduction and rapport building
**Minutes 5-15:** Current state and problem discovery
**Minutes 15-25:** Solution validation (if problem confirmed)
**Minutes 25-30:** Next steps and referrals

**Total time:** 30-45 minutes maximum

## Post-Interview Actions

1. **Document immediately:** Write up notes while fresh
2. **Categorize findings:** Problem severity, willingness to pay, segment
3. **Update hypotheses:** What was validated? What was invalidated?
4. **Tag patterns:** Look for repeated pain points across interviews
5. **Follow up:** Send thank you email within 24 hours
6. **Track metrics:** Number of interviews, validation rate, pipeline
7. **Synthesize insights:** Weekly review of all interviews

## Interview Tracking Template

For each interview, track:
- Name, title, company, contact info
- Date and duration of interview
- Problem severity score (1-10)
- Willingness to pay (yes/no/maybe)
- Current solution and cost
- Key pain points mentioned
- Quotes (exact words)
- Next steps agreed upon
- Hypotheses validated/invalidated
- Referrals provided

## Target: 50-100 Interviews

Don't stop at 5-10 interviews. Steve Blank recommends 50-100+ customer conversations during discovery phase to find true patterns and validate your business model.

Quality conversations at scale = validated learning.