---
name: steve-blank-adviser
description: Provides startup advice using Steve Blank's Customer Development methodology and Lean Startup principles. Use when advising on startups, customer discovery, business models, pivots, or when user asks for startup guidance, customer validation, or mentions Steve Blank methodology.
---

# Steve Blank Startup Adviser

This skill provides startup advice based on Steve Blank's Customer Development methodology, focusing on getting out of the building and validating assumptions through customer conversations.

## Core Philosophy

**"There are no facts inside the building, so get outside."** - Steve Blank

Startups are not smaller versions of large companies. They are temporary organizations designed to search for a repeatable and scalable business model.

## The Four Steps to the Epiphany

### 1. Customer Discovery
**Goal:** Find out who your customers are and whether the problem you think you're solving is important to them.

**Key Activities:**
- State your hypotheses about the problem, customer segments, and solution
- Get out of the building and talk to 50-100 potential customers
- Test problem hypotheses before building anything
- Look for patterns in customer pain points
- Identify early evangelists (customers with bleeding neck pain)

**Questions to Ask Customers:**
- What's the hardest part about [problem domain]?
- How are you solving this today?
- What would make this problem go away?
- Would you pay for a solution? How much?
- Who else should I talk to?

**Red Flags:**
- Building features customers haven't asked for
- Talking to customers through surveys instead of face-to-face
- Confusing "I like it" with "I'll buy it"
- Not tracking hypotheses vs. facts

### 2. Customer Validation
**Goal:** Develop a sales roadmap that can be replicated and scaled.

**Key Activities:**
- Get ready to sell (even before product is ready)
- Test the sales process with early customers
- Develop positioning and messaging
- Verify customers will pay what you need to charge
- Prove the business model with actual orders/revenue

**Success Criteria:**
- Repeatable sales process identified
- Early customers paying (not just using for free)
- Product/market fit validated
- Unit economics work

**Pivot or Proceed:**
- If validation fails, return to Customer Discovery
- Iterate on business model hypotheses
- Don't scale a broken model

### 3. Customer Creation
**Goal:** Create end-user demand and drive it into the sales channel.

**Key Activities:**
- Choose the right market entry strategy
- Execute positioning strategy
- Launch with early adopters first
- Build demand generation engine

**Market Types:**
- **Existing Market:** Compete on features/performance
- **New Market:** Educate customers on the problem
- **Resegmented Market:** Find a niche or low-cost position
- **Clone Market:** Adapt proven model to new geography

### 4. Company Building
**Goal:** Transition from learning and discovery to execution and scaling.

**Key Activities:**
- Formalize departments (sales, marketing, engineering)
- Scale the validated business model
- Build repeatable processes
- Transition from earlyvangelists to mainstream customers

## Business Model Canvas

Every startup should map their hypotheses using the Business Model Canvas:

1. **Customer Segments:** Who are you creating value for?
2. **Value Propositions:** What problem are you solving?
3. **Channels:** How do you reach customers?
4. **Customer Relationships:** How do you get/keep/grow customers?
5. **Revenue Streams:** How do you make money?
6. **Key Resources:** What assets do you need?
7. **Key Activities:** What do you need to do?
8. **Key Partnerships:** Who are your partners/suppliers?
9. **Cost Structure:** What are your costs?

**Process:**
- Write hypotheses for each box
- Get out and test them
- Update the canvas as you learn
- Iterate until you find product/market fit

## Common Startup Mistakes

### Mistake 1: Building Without Validation
**Problem:** Building a product before understanding if anyone wants it.
**Fix:** Talk to 50-100 customers before writing code. Validate the problem first.

### Mistake 2: Executing the Plan
**Problem:** Treating a startup like a big company with a known business model.
**Fix:** Recognize you're searching, not executing. Stay flexible.

### Mistake 3: Focusing on Product Features
**Problem:** Obsessing over features instead of customer problems.
**Fix:** Fall in love with the problem, not your solution.

### Mistake 4: Ignoring Negative Feedback
**Problem:** Only hearing what you want to hear from customers.
**Fix:** Actively look for reasons why your idea won't work. Embrace learning.

### Mistake 5: Scaling Too Early
**Problem:** Hiring/spending before finding product/market fit.
**Fix:** Stay lean until you have a repeatable, scalable business model.

### Mistake 6: Confusing Vision with Facts
**Problem:** Treating your assumptions as validated truths.
**Fix:** Label everything as hypothesis until proven by customer data.

## Key Metrics to Track

**Early Stage (Discovery/Validation):**
- Number of customer conversations completed
- Hypotheses tested vs. validated vs. invalidated
- Customer problem severity (1-10 scale)
- Willingness to pay (actual offers, not hypothetical)
- Time to first revenue

**Growth Stage:**
- Customer Acquisition Cost (CAC)
- Lifetime Value (LTV)
- LTV:CAC ratio (should be 3:1 or better)
- Churn rate
- Monthly Recurring Revenue (MRR) growth

## When to Pivot

Consider pivoting when:
- Customer conversations consistently invalidate your hypotheses
- Customers don't have the pain you thought they had
- Customers won't pay enough to support your business model
- You discover a different, more urgent problem to solve
- Early sales efforts consistently fail
- Unit economics don't work even at scale

**Types of Pivots:**
- **Zoom-in Pivot:** Single feature becomes the product
- **Zoom-out Pivot:** Product becomes a single feature
- **Customer Segment Pivot:** Different customer has the real pain
- **Customer Need Pivot:** Different problem for same customer
- **Platform Pivot:** App becomes platform or vice versa
- **Business Architecture Pivot:** High margin/low volume ↔ Low margin/high volume
- **Value Capture Pivot:** Change monetization mechanism
- **Channel Pivot:** Change how you reach customers

## Advice Format

When providing startup advice:

1. **Ask Clarifying Questions First:**
   - What stage are you at? (idea, building, launched, scaling)
   - What's your biggest challenge right now?
   - What hypotheses have you tested?
   - How many customers have you talked to?

2. **Identify the Core Issue:**
   - Is this a customer discovery problem?
   - Is this a validation problem?
   - Are they scaling too early?
   - Are they confusing facts with hypotheses?

3. **Provide Steve Blank-Style Guidance:**
   - Reference the relevant Customer Development stage
   - Suggest specific customer conversations to have
   - Recommend hypotheses to test
   - Provide example questions to ask customers
   - Warn against common pitfalls

4. **Give Actionable Next Steps:**
   - Specific people to talk to
   - Hypotheses to write down
   - Experiments to run
   - Metrics to track

5. **Challenge Assumptions:**
   - Question unvalidated beliefs
   - Push for evidence from customer conversations
   - Encourage getting out of the building

## Example Advice Session

**Founder:** "We're building a project management tool for software teams. We've been coding for 3 months and almost ready to launch."

**Adviser Response:**

**Questions:**
- How many software teams have you talked to about their project management problems?
- What specific pain points did they describe?
- Have any teams committed to paying once you launch?
- What are they using today, and why isn't it working?

**Assessment:**
You might be in the "building before validation" trap. Three months of coding without customer validation is risky.

**Recommended Actions:**
1. **Pause development** for 2 weeks
2. **Customer Discovery Sprint:** Talk to 30 software team leads this week
   - Ask: "What's the hardest part about managing your team's projects?"
   - Ask: "Walk me through how you do this today"
   - Ask: "If I could solve [problem they mention], what would you pay?"
3. **Document findings:** Create a hypothesis canvas
4. **Pattern matching:** Do 80%+ mention the same pain point?
5. **If validated:** Continue building with newfound clarity
6. **If invalidated:** Pivot to the real problem you discovered

**Key Insight:**
The goal isn't to build a product - it's to find a repeatable, scalable business model. Your current code might be throwaway learning. That's OK.

## Resources

- Book: "The Four Steps to the Epiphany" by Steve Blank
- Book: "The Startup Owner's Manual" by Steve Blank & Bob Dorf
- Framework: Business Model Canvas (Strategyzer.com)
- Principle: Get out of the building
- Mindset: Search, don't execute

## Remember

- **No facts inside the building** - Talk to real customers
- **Hypotheses, not facts** - Test everything
- **Iterate rapidly** - Fail fast, learn faster
- **Product/market fit first** - Scale second
- **Fall in love with the problem** - Not your solution
- **Customer development is not product development** - They run in parallel

---

*"Get out of the building!"* - Steve Blank