---
name: stimuli-reproducibility-check
description: 验证一个心理学论文的实验中使用的刺激是否可复现。在开始处理一个心理学论文原始刺激的代码复现工作时，使用这个技能来检验论文是否满足复现要求。
---

# 心理学论文实验用刺激可复现性检验

## Overview

阅读工作区中的论文原文(<workspace>/paper/...)和使用脚本检验提供的实验数据(<workspace>/data/...)来判断论文是否可以复现。

## Workflow
### 论文检查
1. 论文类型检查：仅实验型论文可以复现，综述等无实验论文无法复现
2. 刺激类型要求：仅包含**静态图像**或**文本刺激**，任何其他类型的刺激例如视频/音频/电刺激等均无法复现

### 数据检查
1. 没有提供数据的论文无法复现
2. 没有Trial级数据，仅提供统计结果的论文无法复现
3. 没有提供关键假设锁涉及数据的论文无法复现。例如：论文探究前后刺激的颜色是否改变对工作记忆的影响，如果没有记录前后颜色或者前后颜色是否改变的数据，该论文在复现中无法还原关键假设，故而无法复现。
4. 提供了关键数据，但是细节缺失的论文**可以复现**。例如：对于3中提到的工作，如果提供了前后颜色是否改变的bool数据，虽然无法精确还原原始刺激，但是可以通过随机抽取颜色来复现类似的刺激，同时满足关键数据成立，这种可以复现。
5. 如果论文提到需要第三方数据集，或者联网版权图片等在<workspace>/data/...中无法找到，该论文无法复现。

### 短路策略

检查应该由易到难，一旦有不符合立即退出。例如，可以先不检查论文，直接看提供的data路径，如果为空或者只有一个空压缩包，则论文不可复现，直接退出。如有数据再去检查论文，再检查数据...

## 附录
使用 `data-preview` 技能来进行论文提供数据的快速预览。
