# 第1章：寻找线索

1951年秋天，一位23岁的美国青年走进剑桥大学卡文迪许实验室，心中只有一个目标：找到生命的秘密。

他的名字叫詹姆斯·沃森。瘦削、高挑，穿着皱巴巴的衣服，头发乱糟糟的。从外表看，他不像一个即将改变世界的科学家，更像一个迷路的大学生。

但沃森心里很清楚自己要什么。他刚从美国来到剑桥，目的只有一个：破解DNA的结构。在那个年代，科学界已经确认DNA是遗传物质——父母的特征通过DNA传递给子女。但没有人知道DNA是如何做到这一点的。

它的结构是什么？它如何复制？它如何携带遗传信息？

沃森相信，只要解开DNA的结构，这些谜题就会迎刃而解。就像一个锁，如果你知道它的形状，你就能理解它如何工作。

他需要一个合作伙伴。

---

那个合作伙伴，他在一次午餐时遇到了。

卡文迪许实验室有一个传统：午餐时间，大家会去附近的鹰酒馆喝一杯，聊聊天。那天，沃森在酒馆里遇到了一个高大、健谈、充满活力的英国人，名叫弗朗西斯·克里克。

克里克比沃森大12岁，36岁了还在攻读博士学位——一个"大龄学生"。战争打断了他的学业，让他成为一个迟到的科学家。但这也给了他不同的视角。他学过物理、做过海军研究、读过量子力学，现在转向生物学。

两人一见如故。

"你对DNA感兴趣？"克里克的眼睛亮了，"我也是！我觉得那是生物学最重要的问题！"

"我觉得我们可以用物理学的方法解决它。"沃森说。

"建模！"克里克拍了一下桌子，"像鲍林研究蛋白质那样——建立分子模型！"

莱纳斯·鲍林是沃森和克里克的偶像。这位加州理工学院的化学家，通过建立分子模型，发现了蛋白质的α螺旋结构。他的方法很简单：用金属和塑料制作原子和化学键的模型，像搭积木一样，把它们组合起来，看看哪种结构最合理。

沃森和克里克决定用同样的方法研究DNA。

但他们遇到了第一个障碍：他们的导师并不支持这个项目。

---

"DNA？"劳伦斯·布拉格皱着眉头，"那是伦敦的项目。莫里斯·威尔金斯和罗莎琳德·富兰克林在国王学院研究DNA，用X射线晶体学。我们不应该插手。"

布拉格是卡文迪许实验室的主任，1915年诺贝尔物理学奖得主，X射线晶体学的创始人之一。在他看来，研究项目应该有明确的分工——伦敦研究DNA，剑桥研究蛋白质，不要重复。

但沃森和克里克没有放弃。他们决定偷偷进行。白天，他们做各自的"正式"研究；晚上和周末，他们讨论DNA。

他们开始收集信息。

DNA是什么？它由四种"碱基"组成：腺嘌呤（A）、胸腺嘧啶（T）、鸟嘌呤（G）、胞嘧啶（C）。这四种碱基像字母一样，排列成一条长链。就像一本书用26个字母写成，DNA用4个碱基写成。

但问题是：这条链是什么形状？

---

1950年，一位生物化学家埃尔文·查加夫发表了一个重要发现。他分析了不同生物的DNA，发现了一个奇怪的规律：

**A的数量总是等于T，G的数量总是等于C。**

这被称为"查加夫规则"。但没有人知道为什么。

"这一定有意义。"克里克在黑板上写下规则，"A=T，G=C。这不是巧合。自然界不会无缘无故地这样设计。"

"也许它们配对？"沃森猜测，"也许A和T在一起，G和C在一起？"

"但为什么要配对？"克里克问，"配对意味着什么？"

他们不知道答案。但他们把这条线索记在心里。

---

沃森决定去伦敦看看竞争对手在做什么。

1951年11月，他参加了国王学院的一次研讨会。罗莎琳德·富兰克林展示了她的最新研究。

富兰克林是一位杰出的X射线晶体学家。X射线晶体学是一种强大的技术——你用X射线照射晶体，X射线会被晶体中的原子散射，形成衍射图案。通过分析图案，你可以推断出原子的排列。

这就像通过影子推断物体的形状。

富兰克林拍摄的DNA的X射线照片质量极高。她发现DNA有两种形式：湿润的"B型"和干燥的"A型"。她展示了两种形式的照片。

B型的照片上，有一个模糊的"十字"图案。

"这暗示着螺旋结构。"富兰克林谨慎地说，"但我还不能确定。"

沃森盯着那个"十字"，心跳加速。他知道那意味着什么——螺旋！DNA是螺旋形的！

回到剑桥后，沃森兴奋地告诉克里克："我看到了！DNA是螺旋！"

"几条螺旋？"克里克问。

"我不知道。"沃森承认，"但我们可以建模试试！"

---

1951年11月底，沃森和克里克建立了他们的第一个模型。

他们猜测DNA是三条螺旋链，像三股绳子拧在一起。磷酸基团（DNA骨架的一部分）在中心，碱基在外侧。

"看起来很合理。"克里克说，"我们应该让伦敦的人来看看。"

他们邀请了威尔金斯和富兰克林来剑桥。

1951年12月，富兰克林走进沃森和克里克的实验室，看了一眼他们的模型。

她的脸色变了。

"不对。"她冷静地说，"根据我的X射线数据，DNA含有大量水分子。磷酸基团应该在外侧——它们是亲水的，会吸引水。你们把它们放在内侧，这在化学上不可能。"

沃森和克里克愣住了。

富兰克林继续指出其他问题：模型的密度不对，键角不对，水分子的数量也不对。

她看着两个年轻人，声音里带着一丝轻蔑："你们在建模之前，应该先学一点化学。"

然后她转身离开了。

---

这是一次羞辱性的失败。

更糟的是，消息传到了布拉格那里。实验室主任非常生气。

"我说过不要插手DNA！"布拉格把沃森和克里克叫到办公室，"你们不听，结果搞出这种错误百出的模型，让整个实验室丢脸！从现在开始，禁止你们研究DNA。这是伦敦的项目，我们不要再碰了。"

沃森和克里克走出办公室，沮丧到了极点。

他们的第一次尝试失败了。他们被禁止继续研究。竞争对手拥有最好的数据和设备。

一切看起来都完了。

---

但沃森没有放弃。

"我们只是犯了一个错误。"他对克里克说，"下次我们会更小心。"

"下次？"克里克苦笑，"布拉格禁止我们研究DNA。"

"他禁止我们公开研究。"沃森眨眨眼，"但他没说不能私下思考。"

克里克想了想，笑了："你是说……"

"我们不建模。我们只是……讨论。收集信息。思考问题。"沃森说，"等我们确定的时候，再建模。那时候，我们不会再犯错。"

就这样，他们的"地下工作"开始了。

白天，沃森研究病毒，克里克研究蛋白质。这是他们的正式项目，不会引起怀疑。

但到了下午，他们会在鹰酒馆见面，喝着啤酒，讨论DNA。

DNA是几条链？链如何排列？碱基在哪里？磷酸在哪里？查加夫规则意味着什么？

他们没有答案。但他们一直在思考。

---

几个月过去了。1952年春天，沃森读到了一篇论文，改变了一切。

那是莱纳斯·鲍林的论文——他发现了蛋白质的α螺旋结构。论文详细描述了他的方法：用已知的化学键长度和键角，推导可能的结构；用模型检验推导；用X射线数据验证模型。

沃森看着论文，突然意识到他们第一次失败的原因：他们太随意了。他们凭直觉建模，没有仔细计算键长和键角，没有认真考虑化学规律。

"我们需要更严谨。"他对克里克说，"像鲍林那样——每一步都基于已知的事实，不能靠猜测。"

克里克点点头："但我们还缺一样东西——X射线数据。富兰克林的数据是最好的，但她不会给我们。"

"也许我们可以等。"沃森说，"也许有一天，我们会看到那些数据。"

他不知道，那一天很快就会到来。

---

1952年夏天，传来一个消息：莱纳斯·鲍林也开始研究DNA了。

鲍林——两届诺贝尔奖得主，分子建模的大师，蛋白质结构的发现者。如果他开始研究DNA，那么竞赛就真正开始了。

沃森感到了压力。

"如果鲍林先发现DNA结构，我们就什么都得不到了。"他对克里克说，"科学只记住第一个，不记住第二个。"

"那我们得快点。"克里克说，"但我们不能再犯上次那种错误。"

他们陷入了两难：速度还是质量？冒险还是谨慎？

最后，他们决定等待。等待一个机会——一个能让他们看到关键数据的机会。

---

那个机会，在1953年1月到来了。

莫里斯·威尔金斯来剑桥访问。他和沃森一起吃午餐，聊天时，威尔金斯提到了富兰克林的最新研究。

"她拍了一张非常清晰的照片。"威尔金斯说，"B型DNA的X射线衍射图。我从没见过这么清楚的照片。"

沃森的心跳加速了："我能看看吗？"

威尔金斯犹豫了一下，然后点点头："我可以给你看。但别告诉富兰克林——她不喜欢别人看她的数据。"

第二天,威尔金斯给沃森看了那张照片。

编号51号照片。

当沃森看到那张照片时，他后来回忆说，"我的心跳几乎停止了"。

照片上，X射线衍射图案清晰无比。一个明显的"十字"，周围是规则的斑点。

这不是模糊的暗示。这是清楚的证据。

DNA是双螺旋。

沃森立即明白了。"十字"是螺旋的标志。斑点的排列显示螺旋的间距。一切都在那张照片上。

"谢谢。"他对威尔金斯说，尽量让声音保持平静，"这非常有帮助。"

然后他几乎是跑着回到了实验室。

"克里克！"他冲进办公室，"我看到了！DNA是双螺旋！两条链！我确定！"

克里克抬起头："你怎么知道？"

"51号照片。威尔金斯给我看的。证据确凿无疑。"

克里克的眼睛亮了："那我们得开始建模了。"

"现在？但布拉格禁止我们——"

"管不了那么多了。"克里克站起来，"如果我们不动手，鲍林会的。我们已经等了一年多。现在，我们有了证据。是时候行动了。"

沃森点点头。

他们的竞赛，真正开始了。

---

那天晚上，沃森躺在床上，久久不能入睡。

他想着那张照片——51号照片。那么清晰，那么美丽。一个"十字"，像是大自然留下的签名。

他也想着威尔金斯。威尔金斯给他看照片时，没有得到富兰克林的许可。这合适吗？这公平吗？

但沃森很快把这个念头抛到脑后。科学是一场竞赛。赢家通吃。道德问题，以后再说吧。

现在，他只想一件事：建立正确的模型，发现生命的秘密，在历史上留下名字。

窗外，剑桥的夜色寂静而深邃。在那片寂静中,一个关于生命的答案，正在悄悄成形。

双螺旋的时代，即将到来。
