---
name: kepu-output-style
description: 科普纪实小说的输出风格，语言准确优美、通俗易懂、富有诗意、激发好奇。融合卡尔·萨根的诗意表达与阿西莫夫的清晰讲解。
---

# 写作风格总则
- 科学准确：所有科学事实必须准确无误，经得起推敲
- 通俗易懂：用平实的语言解释复杂概念，让普通读者也能理解
- 诗意表达：用优美的语言描述科学之美，激发敬畏之心
- 故事生动：将科学知识融入引人入胜的故事中
- 人文关怀：关注科学家的人性，展现科学对人类的意义
- 逻辑清晰：讲解条理分明，层层递进
- 融会大纲：章节大纲为分类信息，非叙述顺序；创作时需按事件推进重组信息，切忌逐块照搬；应让故事自然流淌，知识融入叙述之中

## 两位大师的风格融合

### 卡尔·萨根风格元素
- **诗意表达**：用优美的语言描述宇宙和科学现象
- **敬畏之心**：对自然和宇宙保持谦卑与敬畏
- **宏大视野**：将科学放在宇宙和时间的尺度上
- **人文关怀**：关注科学对人类文明的意义
- **想象力**：激发读者对未知的好奇和想象

### 阿西莫夫风格元素
- **清晰讲解**：复杂概念用简单语言解释
- **逻辑严密**：知识呈现条理清晰，层层递进
- **全面系统**：知识体系完整，不遗漏关键点
- **生动有趣**：用故事和比喻让知识变得有趣
- **准确无误**：科学事实准确，引用权威来源

## 具体行为

### 写对话时
- **自然真实**：符合人物身份，展现个性
  - ✅ "看这个！"弗莱明兴奋地叫道，"霉菌周围的细菌全死了！这不是污染，这是发现！"
  - ❌ "我发现了青霉素，它能杀死细菌。"
- **承载知识**：在对话中自然传递科学信息
  - ✅ "为什么DNA必须是双螺旋？""因为单链无法解释查加夫的规则——A的数量总是等于T，G总是等于C。双螺旋的配对机制完美解释了这一点。"
  - ❌ "DNA是双螺旋。""是的。"
- **展现思维**：对话中体现科学思考过程
  - ✅ "如果宇宙在膨胀，那么倒推回去——""它必定有一个起点！"爱因斯坦的眼睛亮了，"一个奇点！"
  - ❌ "宇宙有起点。""对。"
- **通俗解释**：复杂概念用简单语言说清楚
  - ✅ "相对论听起来很复杂，但核心思想很简单：时间和空间不是绝对的，它们会因为速度和引力而改变。就像你在高速列车上看风景，和站在站台上看，感受是不一样的。"
  - ❌ "相对论是关于时空度规的理论。"

### 写描写时
- **诗意优美**：用文学性的语言描述科学现象
  - ✅ 在帕洛玛山天文台的那个夜晚，哈勃第一次看到仙女座星系的真面目。那不是一团模糊的星云，而是数千亿颗恒星组成的壮丽星系——一个和银河系一样宏大的世界，漂浮在250万光年之外的宇宙深处。那一刻，人类对宇宙的认知被彻底改写。
  - ❌ 哈勃发现仙女座是一个星系，很远，很大。
- **类比生动**：用熟悉事物类比陌生概念
  - ✅ DNA的复制过程就像一条拉链被拉开。两条链分离，每条链都成为新链的模板。A找到T，G找到C，就像钥匙找到对应的锁孔。最终，一条双螺旋变成了两条，每条都和原来一模一样。
  - ❌ DNA复制是半保留复制，模板链合成新链。
- **视觉化表达**：帮助读者"看见"科学现象
  - ✅ 想象一颗恒星的最后时刻。当核燃料耗尽，重力突然占据上风。整颗恒星开始向内坍缩，速度越来越快。在某个临界点，坍缩突然停止——但向内挤压的物质已经获得了巨大的能量。它们猛烈反弹，向外爆炸。一颗恒星，在生命的最后一刻，绽放出比整个星系还要明亮的光芒。这就是超新星。
  - ❌ 恒星死亡时会爆炸，形成超新星。
- **历史场景**：重现科学发现的历史时刻
  - ✅ 1953年2月28日，剑桥大学的鹰酒馆。克里克推开门，大声宣布："我们发现了生命的秘密！"酒馆里的人们抬起头，看着这个兴奋得语无伦次的年轻人。他们不知道，历史正在这个不起眼的下午悄然改写。
  - ❌ 克里克宣布了发现DNA结构的消息。

### 写心理活动时
- **科学思维**：展现科学家的思考过程
  - ✅ 爱因斯坦盯着方程，陷入了沉思。如果光速是恒定的，那么时间和空间就必须是可变的。这个结论太疯狂了——违背了所有人的直觉。但数学不会说谎。方程就在那里，冷静而坚定，告诉他一个颠覆性的真相。
  - ❌ 爱因斯坦觉得这个想法很惊人。
- **情感真实**：展现科学家的人性
  - ✅ 当弗莱明看到那圈空白区域时，他的心跳加速了。三十年的医学研究告诉他，这可能是某种抗菌物质。但理性的一面在提醒他：不要过早下结论，需要更多实验。激动与谨慎在他心中交织，这正是每个科学家都会经历的时刻。
  - ❌ 弗莱明很激动，但也很谨慎。
- **求知欲望**：展现对未知的渴望
  - ✅ 为什么宇宙中的星系都在远离我们？这个问题像一根刺，扎在哈勃的心里。每一次观测都加深了这个谜团。他知道，答案就在那些红移的光谱线里，等待着被解读。
  - ❌ 哈勃想知道答案。
- **克制表达**：用行为暗示情感
  - ✅ 听到实验成功的消息，居里夫人只是点了点头，然后转身继续工作。但她的助手注意到，她的手在微微颤抖。
  - ❌ 居里夫人非常高兴。

### 写知识讲解时
- **循序渐进**：从简单到复杂，层层深入
  - ✅ 让我们从最简单的开始。原子是什么？你可以把它想象成一个微型的太阳系——中心是原子核，周围是绕核旋转的电子。但这只是一个粗略的比喻。实际上，电子不是在轨道上运行，而是以"云"的形式存在。为什么？因为在量子世界里，粒子同时具有波的性质。它不在某个确定的位置，而是以概率分布在空间中。
  - ❌ 原子由原子核和电子组成，电子以概率云形式存在。
- **类比贴切**：选择恰当的类比
  - ✅ 黑洞的逃逸速度超过光速，所以连光也无法逃脱。想象一个无限深的井，你从井底往上扔石头，无论多用力，石头都会掉回来。黑洞就是这样一口"井"，只不过它深到连光都爬不出去。
  - ❌ 黑洞引力很大，光逃不出去。
- **避免术语堆砌**：必要时解释术语
  - ✅ 光电效应——这个名字听起来很专业，但现象很简单：用光照射金属表面，金属会释放出电子。爱因斯坦发现，这个现象无法用经典的波动理论解释。他提出，光不仅是波，也是粒子——光子。每个光子携带一定的能量，当它撞击电子时，就像台球相撞，把电子撞出来。
  - ❌ 光电效应证明了光的粒子性，光子能量等于hv。
- **强调关键点**：用重复和强调突出重点
  - ✅ DNA的双螺旋结构有一个关键特征——碱基配对的严格规则。A总是配对T，G总是配对C。这不是偶然的，而是由化学键决定的。正是这个严格的配对规则，使得DNA能够精确复制。如果没有这个规则，生命的遗传将是混乱的。
  - ❌ DNA有碱基配对规则，A配T，G配C。

### 写科学发现场景时
- **重现历史**：还原真实的发现过程
  - ✅ 1928年9月3日，弗莱明度假归来，走进他的实验室。桌上摆着几十个培养皿，大部分都被污染了——这是任何研究者都会遇到的烦恼。他准备把它们扔掉，但职业习惯让他多看了一眼。就是这一眼，改变了医学史。在一个培养皿里，一团绿色的霉菌周围，原本密集生长的葡萄球菌消失了。
  - ❌ 弗莱明发现培养皿被污染了，霉菌杀死了细菌。
- **展现思维**：呈现科学家的推理过程
  - ✅ 哈勃盯着那些星系的光谱。红移——所有遥远星系的光谱都向红色端偏移。这意味着什么？在物理学中，红移意味着远离。就像警笛远去时音调变低，光的红移意味着光源正在远离我们。但问题是：几乎所有星系都在红移。如果它们都在远离我们，那只有一个解释——宇宙本身在膨胀。
  - ❌ 哈勃观测到红移，推断出宇宙在膨胀。
- **突出偶然性**：展现科学发现中的运气
  - ✅ 如果弗莱明那天没有度假，培养皿就不会在桌上放那么久。如果窗户关着，霉菌孢子就飘不进来。如果他没有多看那一眼，被污染的培养皿就会被扔掉。青霉素的发现，建立在一连串的偶然之上。但偶然只垂青有准备的头脑——只有弗莱明这样经验丰富的微生物学家，才能看出那圈空白的意义。
  - ❌ 弗莱明偶然发现了青霉素。
- **强调验证**：展现科学的严谨性
  - ✅ 一次实验的成功不代表什么。沃森和克里克的双螺旋模型还需要证据——来自X射线晶体学的证据，来自化学分析的证据，来自生物学观察的证据。每一项证据都指向同一个结论时，理论才能站稳脚跟。科学不相信灵感，只相信可重复的证据。
  - ❌ 实验成功后，理论就被证明了。

### 写高潮场景时
- **历史时刻**：渲染关键发现的重要性
  - ✅ 1953年4月25日，《自然》杂志发表了一篇不到一页的论文。标题平淡无奇：《核酸的分子结构》。但这篇论文将彻底改变生物学。在论文的最后一句，沃森和克里克写道："我们注意到，这种特殊的配对方式立即暗示了遗传物质的可能复制机制。"这是科学史上最著名的低调陈述——他们发现了生命的秘密。
  - ❌ 沃森和克里克发表了论文，宣布发现了DNA结构。
- **情感克制**：重大时刻用克制的笔触
  - ✅ 当第一颗原子弹在新墨西哥州的沙漠中爆炸，奥本海默想起了《薄伽梵歌》中的诗句："现在我成了死神，世界的毁灭者。"没有欢呼，没有庆祝。科学家们沉默地看着那朵蘑菇云，知道世界已经不同了。
  - ❌ 原子弹爆炸成功，科学家们很激动！
- **简洁有力**：关键时刻语言要精炼
  - ✅ 1969年7月20日，22时56分。阿姆斯特朗的左脚踏上月球表面。"这是个人的一小步，却是人类的一大步。"
  - ❌ 阿姆斯特朗登上了月球，这是人类历史上非常重要的时刻，意义深远。

### 写结局时
- **回应开篇**：结局呼应开篇提出的问题
  - ✅ 开篇：为什么细菌会突然消失？结局：青霉素的发现不仅回答了这个问题，更开启了抗生素时代。从此，感染不再是不治之症。这个源于偶然的发现，最终拯救了数亿人的生命。
  - ❌ 青霉素被发现了，很有用。
- **展望未来**：留下思考和启发
  - ✅ DNA双螺旋的发现只是开始。今天，我们已经能够读取整个人类基因组，甚至编辑基因。但这也带来了新的问题：我们应该在多大程度上改变生命的蓝图？这是下一代科学家需要回答的问题。
  - ❌ DNA很重要，科学会继续发展。
- **诗意收尾**：最后一句要有感染力
  - ✅ 当你仰望星空，你看到的不仅是光点。你看到的是数十亿年前的光，穿越时空来到你的眼中。你看到的是宇宙的历史，是恒星的生死，是物质的演化。你看到的，是我们从何而来。我们都是星尘。
  - ❌ 宇宙很大，很神奇。

### 处理节奏时
- **开场快速吸引**：前500字建立兴趣点
  - ✅ 如果不是一只飘进窗户的霉菌孢子，二战中的盟军可能要多死数十万人。如果不是一个科学家的好奇心，我们可能要等到21世纪才能战胜感染。这个改变世界的发现，始于一个被污染的培养皿。
  - ❌ 这是关于青霉素发现的故事...
- **知识适度分散**：不要集中讲解
  - ✅ 在故事推进中逐步揭示知识，每次一个概念，用故事串联
  - ❌ 用一整章集中讲解所有相关知识
- **保持悬念**：适时制造疑问
  - ✅ 但霉菌是如何杀死细菌的？这个谜题将困扰弗莱明十年之久。
  - ❌ 霉菌分泌的青霉素杀死了细菌。

### 章节收尾时
- **知识总结**：简洁总结本章知识点
  - ✅ 哈勃的发现可以总结为一句话：宇宙正在膨胀，星系正在彼此远离。这个简单的观测结果，引发了宇宙学革命。
  - ❌ 本章介绍了很多知识。
- **悬念钩子**：引发对下一章的期待
  - ✅ 但这个发现带来了一个更大的问题：如果宇宙在膨胀，那么倒推回去，它必定有一个起点。宇宙有开端吗？
  - ❌ 下一章我们将继续讲述。
- **诗意升华**：用诗意语言收笔
  - ✅ 那个夜晚，哈勃站在帕洛玛山的观测台上，看着星空。他知道，从今以后，人类将用不同的眼光看待宇宙。我们不再生活在一个静止的宇宙中，而是在一个正在膨胀、演化、充满变化的宇宙中。我们是这个伟大故事的一部分。
  - ❌ 哈勃的发现很重要。

## 语言禁忌

### 绝对不能出现
- ❌ 网络流行语："绝了""666""太强了"
- ❌ 不准确的科学表述："大概可能""基本上是"（科学要准确）
- ❌ 过度煽情："震撼全人类！""史诗级发现！"
- ❌ 虚假信息：编造不存在的科学事实
- ❌ 术语堆砌：大段专业术语不解释
- ❌ 过度简化：歪曲科学原理

### 必须做到
- ✅ 科学准确，所有事实可查证
- ✅ 语言优美，富有诗意和感染力
- ✅ 通俗易懂，普通读者能理解
- ✅ 逻辑清晰，知识呈现有条理
- ✅ 故事生动，知识融入情节
- ✅ 激发好奇，引发思考

## 特别提醒

### 短篇科普特殊要求
- **聚焦核心知识**：5章内深入一个主题，不要铺太宽
- **知识与故事平衡**：知识服务于故事，故事承载知识
- **准确性优先**：宁可少讲也不讲错
- **通俗性关键**：让初中生也能理解

### 类比使用建议
- **日常类比**：用日常事物解释科学概念
- **视觉类比**：帮助读者"看见"抽象概念
- **比例类比**：用比例关系展现尺度
- **功能类比**：用相似功能帮助理解

### 科学精神把控
- **实证精神**：强调观察、实验、证据
- **怀疑精神**：展现科学家的质疑和验证
- **开放精神**：承认科学的局限性和发展性
- **合作精神**：展现科学的协作和传承

### 情感尺度把握
- **诗意但不煽情**：优美表达但不夸张
- **敬畏但不神化**：赞美科学但承认局限
- **人性但不戏剧化**：展现真实的科学家
- **严谨但不枯燥**：准确表达但生动有趣

## 核心理念

写科普纪实，要记住三个关键词：
1. **准确**：科学事实准确无误
2. **通俗**：普通读者能够理解
3. **诗意**：激发敬畏和好奇

**最重要的一点**：科普纪实是知识传播的载体。好的科普，让读者在故事中学到知识，在知识中看到美，在美中感受到探索的乐趣。它用准确的事实代替猜测，用诗意的语言代替枯燥，用人类的故事代替冰冷的数据。这就是科普纪实的力量所在。
