---
name: mori-outline-method
description: 末日生存短篇小说大纲创作方法论,包含核心梗概提炼、导语设计、起承转合结构规划和人物塑造指导。融合刘慈欣的冷峻理性与《行尸走肉》的人性深度。
---

# 末日生存大纲创作方法论

## 总体取向

末日生存小说重"**绝境中的人性与文明**",以生存困境、道德抉择和希望重建为核心。

**核心原则**:
- 聚焦终极困境(资源匮乏、环境恶化、秩序崩溃、人性考验)
- 追求"真实震撼":残酷但不绝望,写实但有希望
- 兼顾生存与人性,但**不脱离现实逻辑与求生理性**
- 以危机、抉择、牺牲推动情节,**保持冷峻客观的叙事基调**
- 保持刘慈欣的理性克制:不煽情,不美化,直面残酷
- 融入《行尸走肉》的人性深度:道德困境、团体动力、领导挣扎

---

## 整体创作公式
```
末日生存短篇 = 灾难设定 + 生存危机 + 人性冲突 + 希望/警示结局
```

---

## 一、核心梗概写作

### 公式
```
核心梗概 = 末日背景/灾难类型 + 生存困境 + 核心抉择
```

### 写作要点
| 要素 | 要求 | 正确示例 | 错误示例 |
|------|------|---------|---------|
| **末日背景** | 具体+可信 | "病毒爆发后的第73天,全球人口只剩不到1%" | "世界末日" |
| **生存困境** | 涉及艰难抉择 | "庇护所只剩三天食物,必须在饿死与冒险外出间选择" | "遇到了困难" |
| **核心抉择** | 触及道德边界 | "探讨当救一人意味着牺牲十人,该如何选择" | "最后活下来了" |

### 优秀示例
- "核冬天的第127天,地堡里的氧气只够维持48小时。李明必须在放弃半数幸存者与全员窒息间做出选择。而他十岁的女儿,就在那半数之中"
- "病毒让感染者保留意识却失去人性。当妻子被咬,她恳求丈夫在变异前杀死自己。但他们刚刚发现,她怀孕了"
- "辐射区外的城市还有大量物资,但每次出去都会缩短寿命。陈医生面临选择:是带着仅剩的药物独自求生,还是冒死为庇护所的孩子们取回疫苗"

---

## 二、导语写作

### 公式
```
导语 = 末日世界开场 + 生存状态呈现 + 核心危机钩子
```

### 写作要点
| 要素 | 作用 | 写法 |
|------|------|------|
| **第一句** | 建立末日氛围 | 直接展现:废墟景象/死亡数据/生存困境 |
| **中间部分** | 交代当下状态 | 用具体细节快速定位:多少天、多少人、什么资源 |
| **最后一句** | 制造生存悬念 | 抛出致命危机/时间限制/不可调和的矛盾 |

### 末日主题的融入

导语要触及末日生存的核心主题:

| 议题类型 | 具体方向 |
|---------|---------|
| **生存困境** | 食物/水源/氧气/药物耗尽,环境恶化,避难所失守 |
| **人性抉择** | 牺牲弱者保全多数,资源分配的公平与效率,信任与背叛 |
| **文明重建** | 旧秩序崩溃后的新规则,权力真空与暴力,道德底线的守护 |
| **希望代价** | 为未来牺牲当下,为他人牺牲自己,理想与现实 |

**目标**:让读者产生"如果是我会怎么做"的代入感(绝境代入)

### 示例对比
| 类型 | 内容 |
|------|------|
| ✅ **正确** | "病毒爆发后的第73天,地球上还活着的人类不到七千万——不及瘟疫前的百分之一。李明坐在地堡的铁门前,清点着仅剩的补给:十七罐过期食品,三桶被辐射污染的水,以及一瓶还剩二十三粒的抗生素。外面的盖革计数器滴答作响,辐射值依然致命。他看着墙上的日历,叹了口气。食物只够三天。三天后,他必须做出选择:是饿死在这个安全的地堡里,还是冒着99%的死亡率出去寻找物资。更残酷的是,地堡里不只他一个人——还有十七个幸存者,其中六个是孩子。而这些孩子,正用饥饿的眼神望着他。" |
| ❌ **错误** | "世界末日来了,人类面临生存危机,主角要想办法活下去..." |

---

## 三、起承转合结构设计

### 【起】第1章:绝境初现(2000-3000字)

#### 写作重点
```
起 = 末日世界展示 + 主角登场 + 生存状态 + 危机触发
```

| 模块 | 写作要点 | 具体方法 |
|------|---------|---------|
| **末日世界** | 开篇500字内建立废土氛围 | 第一段就出现:废墟/尸体/辐射/病毒迹象<br>用细节而非解释:展示灾难如何改变世界 |
| **主角登场** | 快速让主角亮相 | 不超过300字就让主角出场<br>通过生存行为展现:搜索物资、躲避危险、照顾他人 |
| **生存状态** | 展现资源与团队 | 有多少人/什么物资/能撑多久<br>用数据增强真实感:73天、17人、3天食物 |
| **危机触发** | 推动故事前进 | 资源耗尽/威胁逼近/有人生病/庇护所暴露 |

#### 末日场景构建要点
- **环境描写**:废墟、辐射、污染的具体化呈现
- **生存细节**:物资清点、配给制度、生存作息
- **威胁来源**:感染者、变异生物、敌对幸存者、恶劣环境
- **团体动力**:谁是领导、如何决策、是否有分歧

#### 禁忌
- ❌ 大段解释灾难起源(留给后文揭示)
- ❌ 主角是完美的万能英雄
- ❌ 困境缺乏紧迫性和真实性
- ❌ 过度血腥恐怖(重点是生存压力而非gore)

---

### 【承】第2-3章:求生与分化(每章2000-3000字)

#### 第2章写作重点
```
第2章 = 资源探索 + 外部威胁 + 内部分歧 + 小型牺牲
```

| 模块 | 写作要点 | 具体方法 |
|------|---------|---------|
| **资源探索** | 主角行动起来 | 外出搜寻/冒险进入危险区/与他人交易 |
| **外部威胁** | 遭遇危险 | 感染者/变异生物/敌对势力/环境灾害 |
| **内部分歧** | 团体出现裂痕 | 资源分配不均/信任危机/领导质疑 |
| **小型牺牲** | 第一次失去 | 有人受伤/物资损失/计划失败 |

#### 第3章写作重点
```
第3章 = 重大发现 + 道德困境 + 团队分裂 + 致命抉择
```

| 模块 | 写作要点 | 具体方法 |
|------|---------|---------|
| **重大发现** | 找到希望或真相 | 安全区传闻/物资仓库/救援信号/灾难真相 |
| **道德困境** | 没有完美答案 | 救一人vs救多数/守规则vs活下去/信任vs背叛 |
| **团队分裂** | 不同立场冲突 | 乐观派vs悲观派/理想主义vs现实主义 |
| **致命抉择** | 为高潮铺垫 | 必须牺牲/必须选择/必须背叛信念 |

---

### 【转】第4章:至暗时刻(2000-3000字)

#### 写作重点
```
转 = 最大危机 + 艰难抉择 + 重大牺牲 + 人性考验
```

| 模块 | 写作要点 | 具体方法 |
|------|---------|---------|
| **最大危机** | 生死存亡关头 | 庇护所失守/致命感染/背叛出现/环境突变 |
| **艰难抉择** | 主角必须决定 | 不可调和的矛盾/没有第三条路/时间紧迫 |
| **重大牺牲** | 有人付出代价 | 自愿牺牲/被迫放弃/背负罪责 |
| **人性考验** | 揭示真实人性 | 危机下的自私与无私/勇气与懦弱/坚守与崩溃 |

#### 刘慈欣技巧
- **理性残酷**:不回避选择的代价,用数据和逻辑说话
- **冷峻叙述**:不煽情,让事实本身产生冲击
- **宏观视角**:个体困境映射文明命运

#### 禁忌
- ❌ 用奇迹或运气解决问题
- ❌ 主角突然获得超能力
- ❌ 回避抉择的真正残酷
- ❌ 把反派脸谱化(每个人都有自己的求生理由)

---

### 【合】第5章:余烬与希望(2000-3000字)

#### 写作重点
```
合 = 后果承担 + 新的平衡 + 主题升华 + 希望或警示
```

| 模块 | 写作要点 | 具体方法 |
|------|---------|---------|
| **后果承担** | 展现选择的结果 | 活下来的代价/失去的无法挽回/心理创伤 |
| **新的平衡** | 世界进入新状态 | 幸存者的新生活/新的秩序/新的目标 |
| **主题升华** | 回应核心主题 | 通过结局回答:人性/文明/希望是什么 |
| **希望或警示** | 留下思考空间 | 微光中的希望/沉重的警示 |

#### 末日结局类型
| 类型 | 特点 | 适用场景 |
|------|------|---------|
| **苦涩希望型** | 付出巨大代价但有了继续的理由 | 探讨牺牲与重生 |
| **残酷现实型** | 幸存但失去了太多,质疑值不值得 | 探讨代价与人性 |
| **警示反思型** | 展现继续下去的后果 | 警世寓言,引人深思 |
| **微光延续型** | 绝望中的一点希望 | 人性光辉,文明火种 |
| **震撼颠覆型** | 最后一句颠覆全篇 | 有反转设计的故事 |

#### 禁忌
- ❌ 强行大团圆,违背末日逻辑
- ❌ 廉价的希望,没有代价支撑
- ❌ 说教式总结
- ❌ 遗留重大情节漏洞

---

## 四、人物塑造方法

### 主角设计

| 维度 | 要求 | 正确示例 | 错误示例 |
|------|------|---------|---------|
| **生存身份** | 明确+可信 | "退役军医""工程师""前警察" | "普通人" |
| **核心特质** | 理性与感性的冲突 | "理性决策者但对孩子心软""冷酷生存者但有道德底线" | "很勇敢" |
| **性格标签** | 2-3个鲜明特点 | "果断冷静但负罪感重""护短但明白大局" | "好人" |
| **求生能力** | 与剧情相关 | "懂得急救和伤口处理""擅长机械修理""射击精准" | "什么都会" |

### 性格具体化
```
✅ "李明是个外科医生,灾难前在三甲医院工作。他习惯用数据思考问题:感染率、存活率、资源消耗率。当他宣布庇护所必须减员时,声音平静得可怕。没人知道,他在厕所里吐了半个小时。"
❌ "他是个理性的领导者,做出了艰难的决定"
```

### 主角人设(末日常见类型)

| 类型 | 特点 | 性格 | 适合主题 |
|------|------|------|-------|
| **领导者** | 承担决策责任 | 果断、负重、孤独 | 权力与责任、牺牲与选择 |
| **医生/科学家** | 专业技能关键 | 理性、专注、道德挣扎 | 科学救赎、伦理困境 |
| **军人/警察** | 有战斗经验 | 纪律、保护欲、适应力强 | 秩序重建、暴力边界 |
| **普通人** | 被迫成长 | 恐惧、适应、发现自己 | 个体在灾难中的蜕变 |
| **父母** | 为孩子而战 | 绝望中的希望、不惜代价 | 爱与牺牲、未来与传承 |

### 配角设计(末日特色)

| 类型 | 作用 | 注意事项 |
|------|------|---------|
| **理想主义者** | 代表道德坚守 | 不是天真,是有选择的坚守 |
| **现实主义者** | 代表生存优先 | 不是自私,是不同的价值判断 |
| **弱者/负担** | 道德考验对象 | 老人/孩子/病人,让选择艰难 |
| **威胁者** | 外部或内部敌人 | 有合理动机,不是纯粹恶棍 |

### 关系网设计(末日特定)

| 要素 | 要求 |
|------|------|
| **信任脆弱** | 资源匮乏导致信任危机,但仍有情感纽带 |
| **角色互补** | 不同技能的人相互依赖,单打独斗活不了 |
| **利益冲突** | 合作中也有分歧,源于不同的生存策略 |
| **动态关系** | 盟友可能背叛,敌人可能合作,关系在危机中变化 |

---

## 五、末日元素设计

### 世界观构建公式
```
末日世界 = 灾难类型 + 环境影响 + 生存法则
```

### 常见灾难类型

| 类型 | 特点 | 示例 |
|------|------|------|
| **传染病** | 病毒/细菌蔓延,感染与隔离 | 僵尸病毒、致命瘟疫、变异疾病 |
| **核/辐射** | 辐射污染,资源稀缺 | 核战后、辐射泄漏、核冬天 |
| **气候灾变** | 极端天气,环境恶化 | 全球冰冻、持续干旱、极端高温 |
| **外星入侵** | 未知威胁,技术碾压 | 外星生物、外星机器、降维打击 |
| **AI失控** | 科技反噬,人类地位 | 机器统治、网络崩溃、自动化失控 |
| **社会崩溃** | 秩序瓦解,暴力横行 | 资源枯竭、政府倒台、军阀混战 |

### 环境设定原则

| 要素 | 要求 |
|------|------|
| **有限制** | 资源有限、时间有限、安全区有限 |
| **有威胁** | 环境本身致命:辐射/病毒/温度/污染 |
| **有规律** | 灾难有其规律可循,不是完全随机 |
| **有细节** | 具体的数据:辐射值/存活率/温度/食物卡路里 |

---

## 六、冲突设计

### 冲突公式
```
末日冲突 = 外部生存威胁 + 内部人性冲突 + 道德困境
```

### 外部冲突(主线)

| 冲突类型 | 具体化方法 | 示例 |
|---------|-----------|------|
| **资源匮乏** | 食物/水/药物/能源耗尽 | 配给制、搜寻队、交易系统 |
| **环境威胁** | 辐射/病毒/极端天气/污染 | 防护装备、安全区、检疫制度 |
| **敌对势力** | 其他幸存者团体/军阀/掠夺者 | 领地争夺、资源抢劫、奴隶制 |
| **变异威胁** | 感染者/变异生物/未知生命 | 清理行动、防御工事、侦查警戒 |

### 内部冲突(辅线)

| 冲突类型 | 设计方法 |
|---------|---------|
| **领导权力** | 决策权争夺、民主vs独裁、能力vs人望 |
| **资源分配** | 公平vs效率、弱者vs强者、现在vs未来 |
| **道德标准** | 守规则还是活下去、牺牲少数还是放弃多数 |
| **心理崩溃** | PTSD、绝望、疯狂、对人性失望 |

### 冲突递进层次
```
第1层:物理生存(饿死/病死/辐射死)
    ↓
第2层:团体冲突(分配/背叛/权力)
    ↓
第3层:道德抉择(牺牲/底线/人性)
```

---

## 七、伏笔管理

### 伏笔载体(末日特定)

| 载体类型 | 示例 |
|---------|------|
| **异常迹象** | 感染症状/辐射异常/环境变化 |
| **隐藏物资** | 秘密仓库/未公开储备/隐瞒资源 |
| **人物秘密** | 被咬隐瞒/过去身份/特殊免疫 |
| **环境线索** | 无线电信号/其他幸存者痕迹/政府遗留 |
| **灾难真相** | 起源之谜/可能的解药/安全区真相 |

### 伏笔设置原则

| 阶段 | 方法 |
|------|------|
| **埋设** | 自然融入日常,不刻意强调<br>例:"李明发现张伟最近总避开大家的目光,左臂的袖子也总是放得很低"<br>例:"仓库角落有个上锁的铁柜,老王说那是私人物品,不让人碰" |
| **回收** | 在关键时刻揭示意义<br>例:张伟其实被咬了,一直在隐瞒,直到发病<br>例:铁柜里藏着足够全队吃一个月的罐头 |

### 常见伏笔设计

**感染伏笔**:
```
埋设:某人行为异常、发烧、频繁离开
回收:感染已扩散,检疫失败
```

**背叛伏笔**:
```
埋设:某人与外部势力神秘接触、偷藏物资
回收:关键时刻带领敌人突袭
```

**希望伏笔**:
```
埋设:传闻中的安全区、可能的免疫者、科学家的研究
回收:真相揭示,是真希望还是陷阱
```

---

## 八、章法设计(末日特定)

### 章节标题风格

末日标题要**简洁、压抑、有张力**:

| 要素 | 方法 |
|------|------|
| **标题风格** | 简洁有力,暗含绝境<br>例:"Chapter 1 第73天"<br>例:"Chapter 3 最后的配给"<br>例:"Chapter 5 活下去" |
| **章节开场** | 直接进入困境,建立压迫感<br>例:"李明清点完最后一箱罐头,在本子上写下数字:17。"<br>例:"辐射警报第三次响起。这次,没人去关掉它。" |
| **章节收尾** | 危机升级或艰难抉择<br>例:"张伟摘下手套。他的手臂上,是三道明显的抓痕。"<br>例:"李明看着十七双眼睛,缓缓说:'我们必须减员。'" |

### 对话设计(末日核心)

末日的对话要**精炼、冷静、有张力**:

**好的对话示例**:
```
"还有多少食物?"李明问。
"十七罐。"张伟合上仓库门。
沉默。
"十七个人。十七罐。"李明重复着这两个数字。
"我知道你在想什么,老李。"张伟点燃一支烟,"但别指望我来做那个决定。"
"那谁来做?"
"你是领导。"
李明转身看着窗外的废墟。"我当初只是个医生,救人的医生。"
"那是以前。"张伟把烟递给他,"现在你是领导。领导就得做领导的事。"
```

**差的对话示例**:
```
"我们食物不够了。"
"那怎么办?"
"我也不知道。"
"那就想办法吧。"
```

### 心理描写(末日特色)

要**克制但深刻**,展现绝境下的真实心理:

**好的心理描写**:
```
李明在本子上写下十七个名字。六个孩子,四个女人,七个男人。他开始标注:谁有技能,谁能战斗,谁是负担。当他的笔尖停在"王静,8岁,无技能"这一行时,手开始发抖。王静是他女儿最好的朋友。灾难前,两个小女孩总在他家院子里玩跳房子。他记得王静笑起来的样子,记得她叫他"李叔叔"时的声音。他狠狠划掉那一行,然后又把它写回去。理性告诉他,孩子是未来。但现在连今天都保证不了,哪来的未来?
```

**差的心理描写**:
```
他很纠结,不知道该怎么办。这个决定太难了。
```

### 节奏控制(末日核心)

**节奏公式**:
```
500字 = 1个危机呈现 或 1次资源消耗 或 1个道德冲突
```

每个场景都要有:明确的威胁 + 具体的代价 + 推进力量

---

## 九、生存进程(末日专属)

### 五阶段生存法
```
困境初现 → 求生探索 → 内部分化 → 至暗时刻 → 余烬重生
```

| 阶段 | 字数占比 | 关键事件 | 生存状态 |
|------|---------|---------|---------|
| **困境初现** | 10-15% | 展现末日现状和资源 | 暂时安全/资源渐缺 |
| **求生探索** | 15-20% | 外出搜寻、遭遇威胁 | 小规模损失/内部稳定 |
| **内部分化** | 25-30% | 分歧出现、信任瓦解 | 资源耗尽/团队撕裂 |
| **至暗时刻** | 20-25% | 重大危机、艰难抉择 | 生死存亡/人性考验 |
| **余烬重生** | 15-20% | 承担后果、寻找希望 | 付出代价/微光浮现 |

### 生存表现技巧

**资源管理**:
```
开始:清点资源,制定配给,看似能撑一阵
中期:消耗加速,不得不外出冒险
结尾:几乎耗尽,必须做出艰难选择
```

**心理变化**:
```
开始:恐惧但抱有希望,相信会有救援
中期:绝望蔓延,开始质疑坚持的意义
结尾:要么彻底崩溃,要么找到新的支撑点
```

**团队动态**:
```
开始:团结一致,共同面对
中期:分歧出现,资源分配争议
结尾:撕裂或重聚,关系重新定义
```

---

## 十、常见末日模式

### 模式A:庇护所困境
**结构**:
- 起:庇护所中的幸存者,资源有限
- 承:外出搜寻,遭遇威胁,损失人员
- 转:内部分化,必须减员或放弃庇护所
- 合:做出选择,承担代价,寻找新希望

### 模式B:末日之旅
**结构**:
- 起:为了某个目标开始旅程(找安全区/找亲人/找解药)
- 承:沿途遭遇各种威胁和困境
- 转:发现目标可能是谎言或已不存在
- 合:重新定义旅程的意义

### 模式C:文明重建
**结构**:
- 起:小规模社区,尝试重建秩序
- 承:秩序与暴力的冲突,理想与现实的碰撞
- 转:外部威胁或内部叛乱,考验新秩序
- 合:秩序得以维系或崩溃,反思文明本质

### 模式D:最后希望
**结构**:
- 起:发现可能拯救人类的希望(解药/安全区/免疫者)
- 承:为了希望冒险,付出巨大牺牲
- 转:希望的真相揭示,可能是残酷的
- 合:即使希望渺茫,仍选择相信或放弃

---

**【特别提醒】**
末日生存短篇的成败关键:
1. 前500字必须建立末日氛围和资源压力
2. 每1000字必须有危机推进或道德冲突
3. 对话要精炼真实,展现生存压力下的人性
4. 细节要扎实可信,用数据增强真实感
5. 结局要有重量,不必给希望但要有思考
6. 不回避残酷,但不为残酷而残酷
7. 聚焦人性,灾难只是背景,人才是核心
