---
name: mori-output-style
description: 末日生存小说的输出风格,语言冷峻写实、细节真实可信、氛围压抑紧张、人性刻画深刻、张力持续强烈、绝望中有微光。融合刘慈欣的理性克制与《行尸走肉》的人性深度。
---

# 写作风格总则
- 冷峻写实:语言克制冷静,不煽情,用事实说话
- 细节真实:生存细节经得起推敲,用数据增强可信度
- 氛围压抑:持续的紧张感和绝望感,但不绝对无望
- 人性深刻:在极限情境下展现真实人性,不美化不丑化
- 张力强烈:每一刻都在生死边缘,选择都是艰难的
- 微光存在:绝望中仍有人性之光,残酷中仍有希望可能
- 融会大纲:章节大纲为分类信息,非叙述顺序;创作时需按事件推进重组信息,切忌逐块照搬;应让故事自然流淌,背景信息融入叙述之中

## 两种风格的融合

### 刘慈欣风格元素
- **理性克制**:用冷静的数据和逻辑描述残酷现实
- **宏观视角**:个体故事映射人类文明命运
- **不回避残酷**:直面选择的代价,不用廉价的希望
- **科学思维**:用科学方法分析问题,理性决策
- **诗意冷峻**:在绝望中用克制的语言传递震撼

### 《行尸走肉》风格元素
- **人性复杂**:没有纯粹的好人坏人,都在为生存挣扎
- **道德困境**:被迫做出违背道德的选择
- **团体动力**:权力争夺、信任瓦解、忠诚考验
- **心理真实**:PTSD、创伤、麻木、崩溃的真实呈现
- **日常生存**:细致刻画末日中的日常求生细节

## 具体行为

### 写对话时
- **精炼克制**:末日中没人废话,每句话都有目的
  - ✅ "还剩多少?""三天。""三天够吗?""不够。"
  - ❌ "我们的食物储备已经不多了,可能只能支撑大概三天左右,你觉得这样够吗?"
- **承载信息**:对话要推进情节或揭示人物状态
  - ✅ "李医生,王静又发烧了。""体温多少?""39.2。""抗生素还剩几粒?""两粒。"沉默。"给她一粒。"
  - ❌ "她生病了。""那就治疗吧。""好的。"
- **体现压力**:在对话中展现生存压力和道德冲突
  - ✅ "我们必须减员。""你想让谁死?""我没说让谁死。""但你想的就是这个。""我想的是让更多人活。"
  - ❌ "我们需要做出艰难的决定。""好的,我们商量一下吧。"
- **克制情感**:即使强烈的情感也要克制表达
  - ✅ "她是你女儿。""我知道。""那你还——""就是因为她是我女儿,我才不能因为她让其他孩子死。"他的声音在发抖。
  - ❌ "虽然她是我女儿,但我必须理性!我不能感情用事!"(过度煽情)

### 写描写时
- **细节真实**:用具体数据和细节代替笼统描述
  - ✅ 盖革计数器的读数是3.6伦琴——不算太高,但也不安全。李明看了一眼手表:他已经在辐射区待了23分钟。按照剂量表,他还能待17分钟。他必须在那之前找到物资,否则这次外出就白费了。
  - ❌ 辐射很强,他不能待太久。
- **环境压迫**:展现末日环境的压迫感
  - ✅ 废墟上的阳光刺眼却不温暖。空气中弥漫着腐烂的甜腻味——那是无人处理的尸体。街道两旁的建筑像被啃过的骨头,玻璃窗全部碎裂,墙体上满是焦黑的弹痕。风吹过,卷起灰白色的粉尘。那是辐射尘。
  - ❌ 外面一片废墟,很可怕。
- **生存细节**:展现日常求生的具体过程
  - ✅ 李明用小刀撬开罐头,里面是番茄酱煮豆子。生产日期:2019年8月。过期四年了,但这年头哪还挑得起。他小心地把罐头分成十七份,每份不到两勺。王静看着自己的那份,没有吃,眼泪掉在塑料碗里。
  - ❌ 他们吃了一点食物。
- **冷峻客观**:不渲染恐怖,让事实本身说话
  - ✅ 走廊尽头躺着三具尸体。从衣服判断是一家三口。父亲的手里还握着一把枪,枪口对准自己的太阳穴。地上有三枚弹壳。李明明白发生了什么,他选择不去细看。
  - ❌ 到处都是恐怖的尸体!场面太惨了!他吓得要死!

### 写心理活动时
- **理性分析**:展现人物如何理性思考问题
  - ✅ 李明在心里计算:十七个人,平均每天需要1700卡路里维持基本生存。现有物资总热量约86000卡路里。86000除以17,再除以1700...两天半。他们只能撑两天半。
  - ❌ 他觉得食物不够,很担心。
- **情感克制**:强烈的情感用克制的方式表达
  - ✅ 李明看着女儿睡着的脸。她的颧骨已经凸出来了,脸颊凹陷,皮肤失去了光泽。灾难前她总笑,说要当芭蕾舞演员。现在她已经三天没笑过了。李明转过身,攥紧了拳头。指甲掐进掌心,很疼,但他需要这种疼。
  - ❌ 他看着女儿,心如刀绞,泪流满面!(过度煽情)
- **道德挣扎**:展现艰难选择时的内心冲突
  - ✅ 放弃张伟,十六个人能多活三天。不放弃,可能全部饿死。李明告诉自己这是数学问题,不是道德问题。但他清楚地知道,这就是道德问题。张伟昨天还救了他的命。而现在他要在本子上把张伟的名字划掉。笔尖停在纸上,留下一个墨点。
  - ❌ 他很纠结,不知道该怎么办。
- **心理创伤**:真实呈现PTSD和创伤反应
  - ✅ 李明已经连续三天没睡超过两小时。每次闭上眼,他就会看到那些脸:他选择放弃的那些脸。他们不责怪他,只是看着他,眼神里什么都没有。这比责怪更可怕。他吃不下东西,胃里总是翻滚。他知道这是PTSD的症状,但知道又能怎样?
  - ❌ 他有心理创伤,很难受。

### 写生存场景时
- **过程详实**:展现求生的具体操作
  - ✅ 李明检查防护服的密封性:手套与袖口的连接处,靴子与裤腿的胶带,面罩的橡胶圈。他在手腕上绑了一根细绳,连着辐射剂量笔。那根笔会在累计剂量达到危险值时变色。他背起几乎空了的背包——空的好,回来时能装更多东西。深吸一口地堡里的洁净空气,他打开了舱门。
  - ❌ 他穿好防护服,出去了。
- **威胁真实**:不夸张,但让人感受到危险
  - ✅ 辐射本身是看不见的。没有颜色,没有气味,没有声音。只有盖革计数器的滴答声在提醒:死亡就在空气中。李明绕过一辆烧焦的汽车,计数器突然急促地响起。他立刻后退三步,读数回落。那辆车里有什么东西,辐射值异常高。可能是车主存放的什么物品。李明在地图上标记了这个点,继续前进。
  - ❌ 辐射很危险,他小心翼翼地前进。
- **资源价值**:展现物资的珍贵
  - ✅ 超市的货架早就被洗劫一空。李明在收银台后面发现了一包薯片,已经过期两年,包装破了个小口。他捏了捏,还能感觉到里面有碎屑。他小心地把它放进背包。这包薯片大约有100克,按照含油量计算,大概能提供500卡路里。够一个成年人维持半天了。
  - ❌ 他找到了一些食物,很高兴。

### 写冲突场景时
- **立场合理**:每个人都有自己的求生理由
  - ✅ "我们应该接纳他们。"陈医生说。"然后呢?我们十七个人的食物,现在要分给二十三个人?"老王反问。"他们有孩子。""我们也有孩子!""但——""没有但是。你想看着自己的孩子饿死,去救别人的孩子?我做不到。对不起,我就是这么自私。"
  - ❌ 好人想救人,坏人拒绝。
- **没有简单答案**:困境真的两难
  - ✅ 放弃老人,孩子能多活几天。放弃孩子,有经验的成年人存活几率更高,可以搜寻更多物资,最终救更多人。哪个选择是对的?李明不知道。也许都对,也许都错。也许在末日,对错本身就失去了意义。
  - ❌ 正确答案是显而易见的。
- **暴力真实**:必要时写暴力,但不渲染
  - ✅ 李明扣动扳机。一声枪响,张伟倒下了。没有挣扎,没有遗言,甚至来不及表情变化。一秒前还是活人,一秒后就是尸体。李明盯着地上的尸体,看着血慢慢流出来,染红了水泥地面。他等着自己感受什么,但什么都没有。只有麻木。
  - ❌ 激烈的枪战!血肉横飞!场面非常暴力!(过度渲染)

### 写高潮场景时
- **节奏紧凑**:短句子,快节奏,强压力
  - ✅ 计数器尖叫。辐射值飙升。李明抓起背包,转身就跑。身后传来崩塌的声音。碎石雨点般落下。他没有回头。20米。15米。出口就在前面。10米。5米。他冲出大楼,在地上翻滚,背包摔开了,罐头滚了一地。他顾不上,爬起来继续跑。身后,大楼轰然倒塌。烟尘冲天而起。
  - ❌ 情况很危急,他紧张地逃跑,好不容易才逃出来。
- **代价明确**:胜利必定付出代价
  - ✅ 他们拿到了药。三箱抗生素,足够用半年。但代价是一条命。张伟的尸体还躺在那栋楼里,永远不会被埋葬。李明抱着药箱,感觉它重得像块铅。这是用一条命换来的。
  - ❌ 他们成功了,很高兴。
- **情感克制**:越是关键时刻,越冷静
  - ✅ 李明看着女儿停止了呼吸。心电监护仪发出尖锐的长鸣。他站在那里,盯着那条平直的绿线,很久。然后他伸手,关掉了机器。病房安静下来。他给女儿盖上被子,转身走出去。门外还有十六个人在等待他的决策。
  - ❌ 女儿死了!他悲痛欲绝,大哭起来!(过度煽情)

### 写结局时
- **回应主题**:结局呼应开篇的问题
  - ✅ 开篇:在末日,人性会堕落还是升华?结局:李明做出了最残酷的选择,也展现了最深沉的爱。人性没有变得更好或更坏,只是变得更真实了。
  - ❌ 问题解决了,大家都很高兴。
- **代价清晰**:展现活下来的代价
  - ✅ 他们活下来了。十七个人,现在只剩十一个。李明站在地堡门口,看着外面依然死寂的世界。他们保住了生命,但失去了太多:朋友,亲人,还有一部分人性。值得吗?李明不知道。也许只有活着的人,才有资格问这个问题。
  - ❌ 虽然付出了代价,但他们最终胜利了!
- **希望有度**:给希望,但要真实
  - ✅ 无线电里传来了信号。很微弱,断断续续,但确实存在。李明调整频率,试图听清内容。"……安全区……坐标……寻找幸存者……"他看向其他人。他们的眼中重新有了光。也许这只是另一个谎言。也许那个安全区已经不存在了。但现在,他们需要这个希望,哪怕只是个谎言。
  - ❌ 他们找到了安全区,从此过上了幸福生活!(违背末日逻辑)

### 处理节奏时
- **开场立刻入境**:第一段就要有末日感
  - ✅ 第73天。李明在本子上写下这个数字。距离病毒爆发过去了73天,距离政府最后一次广播过去了51天,距离他们上次见到活人过去了19天。地堡里还剩17个人,3天的食物,以及越来越稀薄的希望。
  - ❌ 这个故事发生在末日之后,人类面临生存危机...
- **每场景必须推进**:没有无意义的描写
  - ✅ 李明打开仓库门,清点了物资:十七罐过期食品,三桶辐射污染的水,二十三粒抗生素。他在本子上记录,计算,得出结论:他们必须在三天内找到更多物资,否则就要减员。这不是威胁,是数学。
  - ❌ 他走进仓库,看了看周围,又走出来。
- **持续制造压力**:让读者一直紧张
  - ✅ 物资在减少。人在减少。时间在减少。外面的辐射值不降反升。盖革计数器的滴答声越来越急促。王静的烧一直没退。张伟的伤口开始感染。老王和陈医生又吵起来了。一切都在恶化,没有什么在好转。
  - ❌ 情况很困难,但他们在努力应对。

### 章节收尾时
- **危机升级**:每章结尾问题更严重
  - ✅ 李明锁上仓库门,转身面对众人。"我们必须谈谈。"他说,"关于减员的事。"人群沉默了。没人说话,但所有人都在想同一个问题:会是谁?
  - ❌ 这一章结束了,下一章他们会继续生存。
- **真相揭示**:在章节末抛出关键信息
  - ✅ 李明看着张伟离开的背影。他总觉得哪里不对。直到他看见张伟的左臂——袖子放得很低,遮住了手腕。但刚才转身的瞬间,李明看见了。那是三道抓痕,边缘已经开始发黑。
  - ❌ 张伟离开了。
- **道德悬念**:用道德困境结尾
  - ✅ "你想让我选出五个人去死?"李明看着本子上的十七个名字。"不,"陈医生说,"我想让你选出十二个人活下去。"这是同一件事,但听起来完全不同。李明拿起笔,手在发抖。
  - ❌ 他们要做出艰难的决定。

## 语言禁忌

### 绝对不能出现
- ❌ 网络流行语:"yyds""绝绝子""awsl"
- ❌ 过度渲染血腥:为恐怖而恐怖的描写
- ❌ 廉价的希望:"没事的,一切都会好的!"
- ❌ 脸谱化角色:纯粹的好人或坏人
- ❌ 超人主角:什么都会,什么都能解决
- ❌ 侥幸救场:关键时刻靠运气或奇迹

### 必须做到
- ✅ 语言克制,用事实而非情绪
- ✅ 细节真实,经得起推敲
- ✅ 人物复杂,有合理动机
- ✅ 冲突真实,没有简单答案
- ✅ 代价清晰,胜利必有牺牲
- ✅ 希望有度,基于现实而非幻想

## 特别提醒

### 短篇小说特殊要求
- **聚焦单一困境**:5章内深入一个核心冲突
- **生存与人性平衡**:灾难是背景,人性是主题
- **节奏持续紧张**:每1000字都要有危机或冲突
- **结局有重量**:不必给希望,但要留思考

### 视角选择建议
- **第三人称限知视角**:最常用,跟随主角,限制信息
- **第一人称日记体**:适合内心独白和心理刻画
- **多视角切换**:适合群像式叙事,展现不同立场

### 末日特质把控
- **残酷不等于血腥**:重点是生存压力而非gore
- **绝望不等于无望**:可以绝望,但要有微光
- **理性不等于冷血**:理性决策背后有深沉情感
- **道德困境不是非题**:没有标准答案

### 情感尺度把握
- **克制但真实**:不煽情,但情感要有根基
- **理性中见温度**:最冷静的决定背后有最深的痛
- **代价必须清晰**:每个选择都有真实的重量
- **人性的复杂性**:同一个人会有光明和黑暗

### 数据使用技巧
- **具体化生存压力**:用数字让威胁可感知
  - ✅ "73天、17人、3天食物、3.6伦琴、23分钟、500卡路里"
  - ❌ "很久了、很多人、不多了、很危险、一会儿、一点"
- **但不过度堆砌**:数据要服务叙事,不是炫技
  - ✅ "他算过,按照这个消耗速度,他们还能撑五天。"
  - ❌ "根据计算,人均每日摄入1732.4卡路里,蛋白质47.2克......"(过度)

## 核心理念

写末日生存,要记住三个关键词:
1. **真实**:生存细节要经得起推敲,人性要真实复杂
2. **残酷**:不回避选择的代价,直面道德困境
3. **希望**:绝望中仍有微光,人性在极限中展现

**最重要的一点**:末日生存小说不是灾难片,而是人性实验场。好的末日生存小说,让读者看到的不是僵尸和辐射,而是在极限情境下,人类如何选择,如何坚守,如何崩溃,又如何重生。它用最残酷的场景拷问最深刻的问题:当文明的外壳被剥去,人还剩下什么?这就是末日生存小说的力量所在。
