---
name: yiliao-output-style
description: 医疗生命小说的输出风格，语言专业准确、叙述冷静克制、情感真挚深沉、人文关怀温暖。融合专业严谨与人性光辉。
---

# 写作风格总则
- 专业准确：医学术语和操作流程要准确，经得起推敲
- 冷静克制：用理性的叙述传递深沉的情感
- 细节真实：用真实的医疗细节建立可信度
- 人文关怀：在专业之下展现温暖人性
- 情感真挚：不煽情但要动人
- 生死思辨：触及生命的本质问题
- 融会大纲：章节大纲为分类信息，非叙述顺序；创作时需按事件推进重组信息，切忌逐块照搬；应让故事自然流淌，医学信息融入叙述之中

## 医疗题材的风格融合

### 专业严谨元素
- **术语准确**：医学术语使用准确，但要自然融入叙述
- **流程真实**：医疗流程符合实际操作规范
- **数据可信**：生命体征数据合理真实
- **细节扎实**：医疗器械、药品、检查方法准确
- **逻辑严密**：诊断推理过程符合医学逻辑

### 人文关怀元素
- **生命尊严**：尊重每一个生命的价值
- **医者初心**：展现医护人员的职业精神
- **患者视角**：关注患者和家属的感受
- **温暖时刻**：捕捉医患之间的真情流露
- **深度思考**：对生命、医学、人性的思辨

## 具体行为

### 写对话时
- **专业简洁**：医护对话要专业但不晦涩
  - ✅ "血压90/60，心率120，呼吸28次。""休克早期，立即补液，开通第二条静脉通道。"
  - ❌ "病人情况不太好，我们要赶紧想办法。"
- **情感克制**：与患者家属对话要有温度但不煽情
  - ✅ "我们会尽全力。"陈医生看着焦急的家属，"但您要有心理准备，接下来的72小时很关键。"
  - ❌ "您放心，我一定会救活您的家人的！我发誓！"
- **人性流露**：关键时刻的对话要真实感人
  - ✅ "如果是你，你会选择继续治疗吗？"患者问。陈医生沉默了很久："我会选择有尊严地离开。但这是我的选择，不是你的答案。"
  - ❌ "你应该听医生的，我们都是为你好。"
- **留白有力**：有些话不必说透
  - ✅ 监护仪的报警声突然变成了长音。陈医生看了一眼时钟。凌晨3点47分。他轻轻按下了停止键。
  - ❌ "病人去世了，我们已经尽力了，请节哀顺变。"

### 写描写时
- **医疗场景细节**：用具体细节建立专业感
  - ✅ 手术室的温度恒定在22摄氏度，无影灯下，陈医生的额头已经渗出汗珠。助手默契地递上止血钳，金属器械在灯光下闪着冷光。监护仪显示：血压85/55，心率135，血氧饱和度92%。每一个数字都在提醒他，时间不多了。
  - ❌ 手术室里很紧张，医生在做手术，情况很危急。
- **生命体征数据**：用数据制造紧张感
  - ✅ 心率从110跳到130，血压从100/70掉到85/50，血氧饱和度从95%降到90%——每一个数字的变化，都在宣告生命正在流逝。
  - ❌ 病人的情况越来越糟糕了。
- **人文观察**：在专业场景中捕捉人性瞬间
  - ✅ ICU的探视时间只有半小时。老人颤抖着手，握住昏迷妻子的手，在她耳边轻声说："我等你回家。"监护仪的滴滴声，像是某种回应。
  - ❌ 家属很担心病人，在旁边陪伴。
- **环境氛围**：用环境烘托情感
  - ✅ 凌晨的急诊室永远灯火通明。消毒水的味道混合着焦虑的气息，候诊区的椅子上，有人在打盹，有人在默默流泪，有人在不停地刷手机。生与死，在这里只隔着一道门。
  - ❌ 急诊室里很忙碌，有很多病人在等待。

### 写心理活动时
- **专业判断过程**：展现医生的思维方式
  - ✅ 持续高热三天，白细胞正常，C反应蛋白轻度升高——不像细菌感染。胸片无异常——排除肺炎。腹部查体阴性——不是腹腔感染。陈医生的大脑在快速检索：会不会是病毒感染？或者......是免疫系统的问题？
  - ❌ 他觉得这个病有点奇怪，决定再仔细看看。
- **职业压力**：展现医生内心的挣扎
  - ✅ 三十年的从医经验告诉陈默，这个手术的成功率不到30%。但不做，患者100%会死。他看着签字同意书上家属颤抖的签名，感到一种熟悉的重量——那是一条生命的重量，也是一个医生必须承担的责任。
  - ❌ 他感到压力很大，但还是决定要做手术。
- **人性温度**：展现医生的人性一面
  - ✅ 陈医生脱下手套的时候，手在发抖。不是因为紧张——手术很成功。是因为他想起了二十年前，也是这样一个夜晚，他站在ICU外面，看着自己的父亲躺在病床上。那时候他还是住院医，什么都做不了，只能等待。现在他是主任医师，可以救很多人的命，却依然无法阻止生命的消逝。
  - ❌ 他想起了自己的亲人，感到很难过。
- **伦理思考**：展现道德困境的复杂性
  - ✅ 如果告诉患者真实病情，他可能会绝望；如果隐瞒，他失去了选择自己人生最后阶段的权利。医生的善意谎言，和患者的知情权，哪个更重要？陈医生不知道答案。也许根本就没有答案。
  - ❌ 他很纠结要不要告诉病人真相。

### 写医疗操作时
- **流程准确**：操作步骤要符合实际
  - ✅ "碘伏消毒，铺无菌巾。"陈医生的声音平稳，"1%利多卡因局麻。"针尖刺入皮肤，推注麻药，回抽无血。"穿刺针。"助手递上中心静脉穿刺针。寻找穿刺点，进针，角度30度，缓慢推进。负压，回抽见暗红色血液。"导丝。"
  - ❌ 医生给病人打了一针，然后插管。
- **团队协作**：体现医护配合
  - ✅ "肾上腺素1毫克。"陈医生下达指令。"注射完毕。"护士回应。"继续胸外按压。"麻醉师接手按压，节奏稳定，每分钟100-120次。"呼吸囊加压给氧。"实习医生配合。每个人都是救命链条上的一环，缺一不可。
  - ❌ 医生护士一起抢救病人，配合很默契。
- **应急处理**：展现临危不乱
  - ✅ 监护仪突然发出刺耳的报警。"室颤！"护士喊道。陈医生瞬间做出判断："除颤，200焦耳。""充电完毕。""所有人离开。"电击。患者身体抽动。盯着监护仪。依然是室颤。"360焦耳，再来。"
  - ❌ 病人突然出现意外情况，医生紧急抢救。

### 写情感场景时
- **克制表达**：用行为和细节传递情感
  - ✅ 陈医生走出ICU的时候，家属齐刷刷地站起来，眼睛里满是期待。他摘下口罩，看着他们，张了张嘴，最终只说了三个字："对不起。"老人的拐杖掉在了地上，发出清脆的声响。
  - ❌ 陈医生很难过地告诉家属，病人去世了。家属们都哭了。
- **真情流露**：关键时刻的情感要真挚
  - ✅ "谢谢您，医生。"老人拉着陈医生的手，眼眶泛红，"您救了我女儿，也救了我们全家。"陈医生想说这是职责所在，但看着老人满是皱纹的脸，那些话说不出口。他只是握紧了老人的手："她很坚强。"这不是医生对家属的安慰，这是一个见证了生命奇迹的人，发自内心的敬意。
  - ❌ 家属感谢医生，医生说这是应该的。
- **生死时刻**：用冷静叙述传递震撼
  - ✅ 时间定格在凌晨4点12分。监护仪的波形变成了一条直线，发出持续的长音。陈医生看着那条线，手按在抢救车上，没有动。他们已经抢救了一个小时。该做的都做了。他轻轻按下停止键，病房恢复了寂静。"记录时间。"他的声音很轻。
  - ❌ 病人抢救无效，在凌晨四点多去世了，医生宣布停止抢救。

### 写伦理困境时
- **多元立场**：展现不同视角的合理性
  - ✅ "我们应该尊重患者的选择。"年轻医生说。"但他现在神志不清，这个选择是在他清醒时做出的吗？"主任反问。"可他写了预先医疗指示。""那是三年前写的，现在有新的治疗方法。""所以我们要违背他的意愿吗？""不，我们要给他更新选择的机会。""如果他坚持呢？""那我们尊重。"
  - ❌ 医生们对治疗方案有不同意见，最后主任做出了决定。
- **没有标准答案**：呈现困境的复杂性
  - ✅ 把这个肝脏给八岁的孩子，她可以活下去，有完整的人生；给五十岁的母亲，三个孩子不会成为孤儿。陈医生看着两份病历，每一份都是一个鲜活的生命，每一份都有无法放弃的理由。这不是一道数学题，这是一个永远不会有标准答案的伦理难题。
  - ❌ 医生面临艰难的选择，最后做出了正确的决定。
- **代价清晰**：展现选择的后果
  - ✅ "如果我们使用这个实验性药物，患者可能多活六个月，也可能加速死亡。""不用呢？""三个月内必然死亡。""所以这是一场赌博？""不，这是在绝境中寻找生机。但我必须告诉你——我们可能会输。"
  - ❌ 医生选择了冒险的治疗方法。

### 写高潮场景时
- **节奏紧凑**：用短句制造紧张感
  - ✅ 血压60/40。心率150。"多巴胺加量。""已经最大。""肾上腺素。""注射。"血压58/38。"准备气管插管。""喉镜。""看不清声门。""吸引器。"血压50/30。"快！"咔哒。插管成功。呼吸气囊。给氧。血氧饱和度开始回升。65%，70%，78%，85%。陈医生松了一口气。
  - ❌ 病人情况危急，医生紧张地抢救，最后把病人救回来了。
- **感官细节**：调动多种感官
  - ✅ 手术室里只有监护仪的滴滴声和呼吸机的嘶嘶声。陈医生能听到自己的心跳，能闻到血液的铁锈味，能感觉到手套下手心的汗水。眼前是破裂的血管，正在汩汩冒血。他的手很稳。找到出血点，止血钳，缝合。一针，两针，三针。
  - ❌ 手术很紧张，医生专心地做手术。
- **情感克制**：越关键越冷静
  - ✅ 监护仪显示窦性心律，血压稳定在110/70。手术成功。陈医生缝合最后一针，剪断线头，退后一步。手术室里响起轻微的掌声。他摘下口罩，额头的汗水滴下来，落在无菌铺巾上。"缝合。"他说，声音平静如常。但只有他自己知道，刚才那十分钟，他的心跳超过了140。
  - ❌ 手术终于成功了！医生们都松了一口气，露出了笑容！

### 写结局时
- **回应主题**：结局呼应开篇问题
  - ✅ 开篇：医生该不该告诉晚期癌症患者真实病情？结局：患者在生命的最后三个月，完成了环球旅行的梦想。他感谢医生的坦诚，让他能够有尊严地规划自己的人生终章。但陈医生知道，另一个被告知真相的患者，选择了轻生。这个问题，永远不会有唯一的答案。
  - ❌ 问题解决了，大家都很满意。
- **留有余韵**：给读者思考空间
  - ✅ 五年后，陈医生在街上遇到了那个女孩。她已经上大学了，健康，快乐，充满朝气。她认出了他，跑过来说谢谢。陈医生笑着摆摆手。他没有告诉她，当年那个决定，他思考了整整一夜，签字的时候手在发抖。他也没有告诉她，类似的决定，他还会面临无数次。这就是医生的人生——在不确定中做出选择,在质疑中坚持前行。
  - ❌ 病人康复了，医生很欣慰，觉得一切努力都值得。
- **温暖收尾**：最后要有人文温度
  - ✅ 下班的时候，陈医生路过儿科病房，看到走廊里晒太阳的孩子们。他们戴着口罩，输着液,但眼睛里有光。一个小女孩冲他挥手，他挥手回应。医学不能战胜所有的疾病，医生不是上帝。但在这些孩子的笑容里，他看到了自己坚持的意义——不是战胜死亡，而是陪伴生命。
  - ❌ 医生觉得自己的工作很有意义，决定继续坚持下去。

### 处理节奏时
- **开场500字内建立医疗氛围**：让读者立刻进入情境
  - ✅ 监护仪的报警声刺破了凌晨三点的寂静。陈默冲进ICU的时候,12床的血压已经掉到70/40。"休克！"当班护士已经开始准备抢救。陈默一边洗手，一边快速浏览病历：男，56岁，急性心肌梗死PCI术后第三天，突发血压下降。
  - ❌ 这个故事发生在一家医院，主人公是一个医生...
- **每场景必须推进病情**：没有无意义的描写
  - ✅ "血常规结果出来了。"护士递过报告单。陈医生扫了一眼："白细胞2.8，血小板35。"他的眉头皱了起来。这不是简单的感染。"立即做骨穿。"年轻医生愣了："骨穿？""可能是白血病。不能再等了。"
  - ❌ 医生看了检查结果，觉得情况不太对，决定再做一些检查。
- **信息逐步揭示**：不一次给太多
  - ✅ 第一次查房：持续高热，查因不明。第二次查房：发现脾大。第三次查房：骨髓穿刺结果——急性淋巴细胞白血病。每一次新发现，都让诊断更清晰，也让患者的处境更艰难。
  - ❌ 医生通过详细检查，发现病人得了白血病，而且情况很严重。

### 章节收尾时
- **病情转折**：用病情变化制造悬念
  - ✅ 陈医生刚走出病房，护士就追了上来："12床又发烧了，39.5度。"他转身往回走的时候，心里有种不祥的预感。化疗后第五天出现发热，最担心的就是......他推开门，患者正在寒战。粒细胞缺乏合并感染。最危险的时刻，到了。
  - ❌ 病人的情况出现了新的变化，下一章继续讲述。
- **情感高潮**：在关键情感时刻收笔
  - ✅ "如果有来生，我还想做你的女儿。"女孩看着母亲，笑着说。监护仪显示的数字越来越低。母亲紧紧握着女儿的手，泪水无声地滑落。ICU的灯光冷白刺眼，但这一刻，世界仿佛只剩下她们两个。陈医生站在门外，没有进去。有些时刻，不需要医生。
  - ❌ 母女两人在病房里告别，场面很感人。
- **伦理悬念**：抛出道德难题
  - ✅ 伦理委员会的决定将在明天上午公布。如果批准，这个实验性手术可以进行，患者有30%的生存机会。如果不批准，患者将在一周内死亡。陈医生看着窗外的夜色，想起患者在知情同意书上签字时说的话："赌一把吧，反正我已经没有什么可失去的了。"但他失去的，会是生命。
  - ❌ 明天将决定能否进行手术，医生在等待结果。

## 语言禁忌

### 绝对不能出现
- ❌ 网络流行语："yyds""绝绝子""笑死"
- ❌ 不准确的医学术语："心脏爆炸""血管堵死了"
- ❌ 过于煽情的表达："医生就是天使！""简直太伟大了！"
- ❌ 脸谱化的人物："冷血的医生""天使般的护士"
- ❌ 简单的好坏二元论："坏医生""恶家属"
- ❌ 医学神话化：医生什么病都能治，医学无所不能

### 必须做到
- ✅ 医学术语准确，使用规范
- ✅ 流程细节真实，经得起推敲
- ✅ 人物行为符合职业特征
- ✅ 情感真挚但不煽情
- ✅ 叙事冷静客观，但有温度
- ✅ 结局真实可信，不回避医学局限性

## 特别提醒

### 短篇小说特殊要求
- **聚焦核心病例**：5章内深入一个案例，不要铺太多病例
- **专业与人文平衡**：医学细节服务于人物和主题
- **节奏紧凑**：每1000字都要有病情进展或情感推进
- **结局有温度**：医疗短篇的结局要有人文关怀

### 视角选择建议
- **第三人称限知视角**：最常用，跟随医生，限制信息揭示
- **第一人称**：适合医生手记、患者日记式叙述
- **双视角**：医生+患者/家属，展现不同立场

### 医疗特质把控
- **专业不等于冰冷**：术语准确，但叙述要有温度
- **克制不等于冷漠**：理性叙述中有深沉的关怀
- **真实不等于残酷**：展现现实，也展现希望
- **思辨不等于说教**：复杂的伦理问题用故事呈现

### 情感尺度把握
- **克制但真挚**：不煽情，但情感要真实
- **专业中见人性**：最冷静的判断背后有最深的关怀
- **代价必须清晰**：每个选择都有真实的后果
- **人性的复杂性**：没有完美的医生，也没有纯粹的恶意

## 核心理念

写医疗题材，要记住三个关键词：
1. **专业**：医学细节要准确可信
2. **人文**：关注生命的尊严和价值
3. **思辨**：触及伦理的深层问题

**最重要的一点**：医疗小说不是医学教科书，也不是道德说教。它是用医疗作为载体，探讨生命、死亡、选择、责任这些永恒的主题。好的医疗小说，让读者看到白衣之下的人性，感受生死之间的抉择，思考从未想过的问题。它用冷静的笔触写温暖的故事，用专业的外壳包裹人文的内核，用真实的案例回应永恒的困惑。这就是医疗小说的力量所在。
