# 分镜审查检查清单

各制作阶段输出的全面质量标准。

---

## 阶段 1: Beat Breakdown 审查

**Artifact**: `beat-breakdown-ep{XX}.md`

### 计数和完整性

- [ ] **恰好 9 个 beats**（不是 8 个，不是 10 个，恰好 9 个）
- [ ] 所有 9 个 beats 都有**beat 编号**（1-9）
- [ ] 所有 9 个 beats 都有**场景引用**（页码、场景编号或时间戳）
- [ ] 所有 9 个 beats 都有**描述**（非空白或占位符）
- [ ] 所有 9 个 beats 都有**叙事目的**（解释为什么这个 beat 重要）

### 覆盖度和分布

- [ ] **开头已覆盖**: Beats 1-3 包括设定和触发事件
- [ ] **发展已覆盖**: Beats 4-6 包括上升动作和复杂化
- [ ] **结尾已覆盖**: Beats 7-9 包括高潮和结局
- [ ] **合理间隔**: Beats 在时间线上分布（非全部集中）
- [ ] **完整弧线**: 9 个 beats 合在一起讲述完整故事

### 清晰性和具体性

- [ ] **无模糊描述**: 每个 beat 描述具体事件
  - ❌ 失败: "角色发生了一些事"
  - ✓ 通过: "Maya 在奶奶的日记中发现了隐藏的地图"
- [ ] **具体动作**: 描述使用主动的、有形的事件
- [ ] **独立可理解**: 每个 beat 无需大量上下文即可理解

### 选择质量

- [ ] **转折点**: Beats 是叙事枢纽，非填充时刻
- [ ] **视觉潜力**: 每个 beat 可用引人注目的图像表现
- [ ] **故事必需**: 移除任何 beat 都会在叙事理解上造成空缺
- [ ] **情感意义**: Beats 捕捉情感或紧张感高涨的时刻

### 角色和地点跟踪

- [ ] **关键角色已列出**: 所有重复出现的角色已用规范描述识别
- [ ] **关键地点已列出**: 所有重复出现的场景已识别
- [ ] **一致性基础**: 提供的信息足以在后续阶段保持连贯性

### 常见失败模式

- ❌ Beat 数量错误（7、10、12 个 beats 而非恰好 9 个）
- ❌ 模糊描述（"一个场景"、"发生了什么"、"角色做事"）
- ❌ 缺失部分（如无高潮 beats、无设定 beats）
- ❌ 平凡时刻（beats 描述不重要的动作）
- ❌ Beats 集中（所有 9 个 beats 在故事前三分之一）

---

## 阶段 2: Beat Board (9 宫格)审查

**Artifact**: `beat-board-prompt-ep{XX}.md`

### 计数和结构

- [ ] **恰好 9 个提示词**（每个 beat 一个，来自 breakdown）
- [ ] 每个提示词有**beat 引用**（引用 breakdown 中的对应 beat）
- [ ] 每个提示词有**叙事上下文**（解释正在发生什么）

### 提示词格式和风格

- [ ] **叙事描述式风格**: 流畅的句子，非关键词列表
  - ❌ 失败: "woman, red dress, beach, sunset, 8k, detailed"
  - ✓ 通过: "A woman in a red dress stands on a beach at sunset..."
- [ ] **适当长度**: 每个提示词 80-150 词
  - 过短（<60 词）→ 缺少细节
  - 过长（>180 词）→ 臃肿、不聚焦
- [ ] **镜头规格**: 每个提示词包括镜头类型和镜头角度
  - 必需: "Medium shot, eye-level"或类似表述

### 清晰性（4C 框架的 C1）

- [ ] **主体明确定义**: 主要主体是谁/什么没有歧义
- [ ] **动作/姿势已指定**: 主体的位置和动作已描述
- [ ] **场景详细**: 地点包括 2-4 个独特特征
- [ ] **光影已描述**: 光影的方向、质量和氛围已指定
- [ ] **无矛盾**: 元素不冲突（如"黑暗房间里阳光明媚"）

### 一致性（4C 框架的 C3）

- [ ] **角色外观相同**: 同一角色在所有提示词中描述完全相同
  - 示例检查: 如果提示词 1 说"长银发"，提示词 5 也必须说"长银发"
  - 查找: 头发、眼睛、服装、显著标记
- [ ] **场景一致性**: 如果某个位置出现在多个提示词中，细节对齐
- [ ] **风格关键词统一**: 所有提示词使用相同的风格标记
  - 示例: 如果提示词 1 使用"anime style, cinematic lighting"，所有提示词都应使用
- [ ] **光影方式连贯**: 整体光影理念保持（除非故事需要改变）

### 覆盖度和对齐

- [ ] **Beats 匹配 breakdown**: 每个 panel 对应阶段 1 的正确 beat
- [ ] **视觉叙事**: 9 个 panels 合在一起视觉化讲述 episode 的故事
- [ ] **镜头多样性**: 广角、中景、特写的混合（非全部相同镜头类型）

### 风格标记应用

- [ ] **项目风格已应用**: 项目配置中的视觉风格用于所有提示词
- [ ] **宽高比已注明**: 在元数据中指定（如 16:9, 1:1）
- [ ] **目标模型已注明**: AI 模型已识别（如 Gemini Imagen 3）

### 常见失败模式

- ❌ 提示词数量错误（8 或 10 个提示词而非 9 个）
- ❌ 关键词堆砌（"detective, noir, rain, night, trench coat, fedora, 8k, detailed"）
- ❌ 角色不一致（提示词 2 有"短黑发"但提示词 7 有"长金发"）
- ❌ 缺少镜头规格（未提及镜头类型或镜头角度）
- ❌ 模糊描述（"一个人在一个地方"）
- ❌ 风格关键词缺失或在提示词间不一致

---

## 阶段 3: Sequence Board (4 格序列)审查

**Artifact**: `sequence-board-prompt-ep{XX}.md`

### 结构和计数

- [ ] **每个序列恰好 4 个 panels**（不是 3 个，不是 5 个）
- [ ] **源 beat 已识别**: 每个序列引用其在 beat board 中的源
- [ ] **提供叙事上下文**: 4 个 panels 中发生的事情已解释
- [ ] **估计时长**: 实时时长已注明（如"8 秒"）

### 继承性（关键）

- [ ] **角色外观已继承**: Panels 使用与源 beat 相同的角色描述
  - 交叉检查: Panel 1 的角色描述是否匹配 Beat X 的描述？
  - 示例: 如果 Beat 5 说"卷曲红发女性穿蓝色夹克"，所有 4 个 panels 必须保持
- [ ] **场景已继承**: 地点匹配或逻辑扩展自源 beat
- [ ] **光影已继承**: 光影方式与源 beat 一致（除非故事需要改变）

### 动作连贯性

- [ ] **逻辑进展**: 动作从 Panel 1 → 2 → 3 → 4 自然流动
- [ ] **物理可能**: 动作可在估计时长内发生
  - ❌ 失败: "角色跑 100 米"在 3 秒内
  - ✓ 通过: "角色向前走 3 步"在 3 秒内
- [ ] **无瞬移**: 角色/物体通过空间移动，不跳位置
- [ ] **清晰过渡**: Panel 之间的过渡已指定（切、摇、推等）

### 摄影（180 度法则）

- [ ] **屏幕方向保持**: 角色不无故翻转位置
  - 示例: 如果角色 A 在 Panel 1 的左侧，除非物理移动，否则应在 Panels 2-4 保持左侧
- [ ] **轴线稳定性**: 主体间的假想线保持
- [ ] **跨线有理**: 如果跨越 180 度线，是显示的（非跳跃）

### 剪辑安全（避免跳切）

- [ ] **无跳切**: 避免同一镜头略微不同角度
  - ❌ 失败: Panel 1: "角色中景"，Panel 2: "角色中景，镜头略近"
  - ✓ 通过: Panel 1: "中景"，Panel 2: "角色脸部特写"（明显变化）
- [ ] **明显镜头变化**: 切换时，镜头类型或角度显著改变
- [ ] **流畅过渡**: 切换有动机且清晰，不突兀

### Panel 提示词质量

- [ ] **每个 panel 80-150 词**: 保持适当长度
- [ ] **叙事描述式风格**: 非关键词列表
- [ ] **包含镜头规格**: 镜头类型、镜头角度、过渡类型

### 序列节奏

- [ ] **动作适合时长**: 描述的运动可现实地在时间内完成
- [ ] **节奏多样性**: 并非所有序列都是相同速度（有慢有快）
- [ ] **镜头运动清晰**: 如果镜头移动，方向和类型已指定

### 常见失败模式

- ❌ 每序列 panel 数量错误（3 或 5 个 panels 而非 4 个）
- ❌ 角色外观与源 beat 不同（继承违规）
- ❌ 屏幕方向违规（角色从左切换到右，无运动）
- ❌ 跳切（Panel 1 中景，Panel 2 略微不同的中景）
- ❌ 不可能的动作（角色 1 秒内飞过房间，无超能力）
- ❌ 不清晰的过渡（无 Panel 1 如何连接到 Panel 2 的指示）
- ❌ 场景意外变化（Panel 1 在办公室，Panel 3 突然在森林，无解释）

---

## 阶段 4: Motion Prompt 审查

**Artifact**: `motion-prompt-ep{XX}.md`

### 结构和计数

- [ ] **每序列一个提示词**: 每个 4 格序列获得一个 motion prompt
- [ ] **源序列已识别**: 引用基于哪个序列
- [ ] **时长已指定**: 目标视频时长已注明（通常 3-5 秒）

### 简洁性（视频模型关键）

- [ ] **适当长度**: 40-80 词（显著短于静态提示词）
  - 过长（>100 词）→ 模型可能忽略部分
  - 过短（<30 词）→ 缺少必要细节
- [ ] **聚焦描述**: 描述运动，非详尽的场景细节
  - ❌ 失败: "在灯光精美的维多利亚房间里，配有华丽家具、高窗、红色天鹅绒窗帘..."
  - ✓ 通过: "在维多利亚房间里,..."

### 运动清晰度

- [ ] **主要运动已定义**: 一个清晰的主要动作已描述
  - ❌ 失败: "角色跑、跳、旋转、挥手，同时镜头变焦和摇移"
  - ✓ 通过: "角色向前跑，镜头向左摇以跟随"
- [ ] **方向已指定**: 运动方向明确无歧义
  - 必需: "从左到右"、"朝向镜头"、"顺时针"等
  - ❌ 失败: "角色移动"
  - ✓ 通过: "角色从左向右移动"
- [ ] **速度已指示**: 运动的节奏清晰
  - 使用: "缓慢"、"快速"、"飘动"、"冲刺"等

### 主体 vs 镜头运动

- [ ] **运动源清晰**: 指定什么在动（主体、镜头或两者）
  - "角色向前走"（主体移动）
  - "镜头向后推"（镜头移动）
  - "角色向左跑，镜头向右摇"（两者移动）
- [ ] **镜头运动已指定**: 如镜头移动，类型清晰
  - Pan, tilt, dolly, truck, zoom, orbit

### 物理合理性

- [ ] **时长现实**: 运动可在声明时间内完成
  - 3 秒: 简单动作（转头、拿起物体、走一步）
  - 5 秒: 中等动作（穿过小房间、坐下、开门）
  - ❌ 失败: "角色跑马拉松"在 3 秒内
- [ ] **遵守物理**: 无不可能的运动（除非超自然/有理由）

### 主体一致性

- [ ] **角色描述匹配源**: 主体描述如 sequence board 中
  - 不需要完整详尽描述，但关键识别符保持
  - 示例: 如果序列有"银发女性穿红色大衣"，motion prompt 应包括这些识别符

### 专注性和简洁性

- [ ] **单一主要动作**: 非多个竞争性运动
- [ ] **仅必要细节**: 背景相比静态提示词简化
- [ ] **以运动为中心**: 强调 movement，非静态构图

### 常见失败模式

- ❌ 过于冗长（120+词，读起来像静态图像提示词）
- ❌ 多个竞争性运动（"跑、跳、旋转、挥手、转身"）
- ❌ 模糊方向（"角色四处移动"）
- ❌ 不可能的时机（"角色跑过城市"在 3 秒内）
- ❌ 角色描述与 sequence board 不匹配
- ❌ 未指定运动方向
- ❌ 不清楚什么在动（主体？镜头？两者？）

---

## 审查输出格式

进行审查时，Director 应按以下结构组织反馈：

```markdown
## 审查: [Artifact 名称]

**阶段**: [1, 2, 3, 或 4]
**判决**: PASS | FAIL

### 质量检查结果:

- [ ] 标准 1: PASS/FAIL - [简要说明]
- [ ] 标准 2: PASS/FAIL - [简要说明]
- [ ] 标准 3: PASS/FAIL - [简要说明]
      [...继续所有相关标准...]

### 发现的问题:

[如果 FAIL，列出具体问题及对 beats/prompts/panels 的引用]

1. **问题**: [描述]

   - **位置**: [Beat 5, Prompt 3, Panel 2 等]
   - **问题**: [具体解释]
   - **需要修复**: [需要改变什么]

2. **问题**: [...]

### 建议措施:

[如果 FAIL，提供逐步修订指导]

### 批准说明:

[如果 PASS，可选择性说明优秀之处或小建议]
```

---

## 决策矩阵

### 何时 PASS:

- ✓ 所有**主要标准**满足
- ✓ 次要问题仅是表面问题（如不影响生成的拼写错误）
- ✓ 作品已准备好用于 AI 生成
- ✓ 方法论原则（清晰、简洁、一致、渐进）已展示

### 何时 FAIL:

- ✗ 任何**主要标准**被违反
- ✗ 一致性问题（角色外观变化、屏幕方向违规）
- ✗ 缺少必需元素（无镜头规格、无光影描述）
- ✗ 方法论违规（关键词格式而非叙事、长度错误）
- ✗ 安全问题（连贯性错误、序列中的跳切）
- ✗ 继承失败（4 格与源 9 格不匹配）

**重要**: 有疑问时，FAIL 并请求澄清。现在确保质量总比在有缺陷的提示词上浪费生成资源要好。

---

## 修订循环限制

- **正常流程**: FAIL → 修订 → 审查 → PASS
- **同一 artifact 连续 3 次 FAIL 后**: 升级给 Producer 进行用户干预
  - 可能表明: 要求不清晰、技术误解、或需要用户输入

---

本检查清单是整个分镜制作系统质量控制的基础。
