# Common Errors in Medical Study Guides

## Purpose

Reference guide for identifying and fixing the most common errors in study guide creation.

---

## Top 10 Most Common Errors

### 1. Unmarked Researched Mnemonics

**Error:** Mnemonic included without asterisk (*) when not from source

**Example:**
```
WRONG: Mnemonic: "PC BRAS" for P450 inducers
RIGHT: Mnemonic: "PC BRAS"* (r/medicalschool, widely used)
```

**Fix:** Add asterisk and source attribution

**Frequency:** Very common (30%+ of study guides with mnemonics)

---

### 2. Silent Gap Filling

**Error:** Adding facts not in source to complete empty sections

**Example:**
```
WRONG: Contraindications: Pregnancy, renal disease [not in source]
RIGHT: Contraindications: [Not covered in source material]
```

**Fix:** Mark missing content explicitly, don't fill with external knowledge

**Frequency:** Common (20% of study guides)

---

### 3. Side Effect Expansion

**Error:** Adding side effects beyond those listed in source

**Example:**
```
Source: "Side effects: nausea, headache"
WRONG: Side effects: nausea, headache, dizziness, drowsiness
RIGHT: Side effects: nausea, headache
```

**Fix:** List ONLY side effects mentioned in source

**Frequency:** Very common (25%+ of drug-related guides)

---

### 4. Mechanism Extrapolation

**Error:** Expanding on mechanism beyond what source states

**Example:**
```
Source: "Drug A blocks enzyme X"
WRONG: Drug A blocks enzyme X, preventing Y production, leading to Z
RIGHT: Drug A blocks enzyme X
```

**Fix:** State only what source explicitly says

**Frequency:** Common (15% of guides)

---

### 5. Drug Class Generalizations

**Error:** Adding drugs from same class not mentioned in source

**Example:**
```
Source: Covers only Zidovudine and Lamivudine
WRONG: Also adding Emtricitabine (same NRTI class)
RIGHT: Only include Zidovudine and Lamivudine
```

**Fix:** Include ONLY drugs explicitly in source

**Frequency:** Moderate (10% of drug guides)

---

### 6. Missing Template Sections

**Error:** Excel/HTML guide missing required tabs

**Example:**
```
WRONG: Excel Drug Chart with only 2 tabs (should have 4)
RIGHT: All 4 tabs present (Drug Details, Key Comparisons, Master Chart, High-Yield)
```

**Fix:** Ensure all required tabs/sections created

**Frequency:** Common (20% of guides, especially Excel)

---

### 7. Incomplete Learning Objective Answers

**Error:** LO answered partially, with gaps filled from external knowledge

**Example:**
```
Source LO answer: "Drug A treats hypertension"
WRONG: Drug A treats hypertension by blocking enzyme X [mechanism not in source]
RIGHT: Drug A treats hypertension
```

**Fix:** Answer LO with source content only, mark if answer incomplete

**Frequency:** Moderate (12% of LO guides)

---

### 8. Incorrect Citations

**Error:** Page numbers or section references wrong

**Example:**
```
WRONG: Drug A mechanism (p. 45) [actually on p. 47]
RIGHT: Drug A mechanism (p. 47)
```

**Fix:** Verify all citations before finalizing

**Frequency:** Moderate (8% when citations used)

---

### 9. Invented Mnemonics

**Error:** Creating mnemonic instead of researching or omitting

**Example:**
```
WRONG: Mnemonic: "ABCD" [made up on the spot]
RIGHT: Either use mnemonic-researcher agent OR omit mnemonic
```

**Fix:** Never invent mnemonics; research or omit

**Frequency:** Rare but critical (5%)

---

### 10. Conflicting Information Not Noted

**Error:** Source has conflict, study guide picks one without noting

**Example:**
```
Source: Says "100mg" on p. 12 and "200mg" on p. 45
WRONG: Dosing: 100mg [ignoring p. 45]
RIGHT: Dosing: 100mg (p. 12) OR 200mg (p. 45) - source contains conflicting information
```

**Fix:** Document both pieces of information and note conflict

**Frequency:** Rare (3%)

---

## Error Prevention Strategies

**For Errors 1-3 (Most Common):**
- Use post-creation checklist
- Scan for asterisks on all mnemonics
- Verify all populated sections have source content
- Re-read source before finalizing

**For Errors 4-6:**
- Stick to source-only discipline
- Use template checklists
- Don't infer or extrapolate

**For Errors 7-10:**
- Careful citation verification
- Use mnemonic-researcher agent
- Note all source conflicts

---

## Quick Error Detection

**Red flags to look for:**
- Mnemonic without asterisk
- Very complete guide from sparse source (likely gap filling)
- More drugs than source covered
- Mechanisms more detailed than source
- Page number citations (verify these)

**If any red flags → Full verification recommended**

---

**See also:**
- [6-Step Protocol Detailed](6-step-protocol-detailed.md)
- [Template Compliance Guide](template-compliance.md)
