# BPM Guide by Usage Context

## Sport & Fitness

| Activity | BPM | Notes |
|----------|-----|-------|
| Yoga / Stretching | 60-90 | Ambient, natural sounds, gentle melodies |
| Meditation | 50-70 | Drones, evolving pads, no percussion |
| Warm-up | 100-120 | Progressive build, moderate rhythm |
| Walking | 115-125 | Steady rhythm to sync footsteps |
| Running (endurance) | 120-140 | Match to stride cadence |
| Running (tempo) | 140-160 | Speed sessions |
| Weightlifting | 130-150 | Sustained energy, not too fast |
| CrossFit | 130-160 | Vary by WOD intensity |
| Tabata | 140-150 | 20s effort / 10s rest structure |
| HIIT | 150-170+ | Alternate intense (150-170) and recovery (115-120) |
| Sprint / Intervals | 160-180 | Maximum intensity bursts |
| Cycling / Spinning | 130-170 | Vary by phase (climb, sprint, recovery) |
| Dance / Zumba | 130-170 | Latin rhythms, energetic pop |
| Boxing / Martial Arts | 130-150 | Steady for combo work |
| Cool-down | 65-90 | Progressive decrease |

## Work & Productivity

| Context | BPM | Notes |
|---------|-----|-------|
| Deep focus | 60-80 | Minimal, ambient, no lyrics |
| Light work | 80-100 | Lo-fi, jazz, gentle electronic |
| Creative brainstorming | 100-120 | Upbeat but not distracting |
| Repetitive tasks | 110-130 | Steady rhythm, can be more energetic |
| Coding / Technical | 70-90 | Ambient, instrumental electronic |

## Events & Venues

| Context | BPM | Notes |
|---------|-----|-------|
| Cocktail reception | 90-110 | Jazz, lounge, sophisticated |
| Dinner ambiance | 70-95 | Soft, elegant, unobtrusive |
| Corporate event | 100-120 | Professional, uplifting |
| Product launch | 110-130 | Energetic, modern, inspiring |
| Fashion show | 115-130 | Trendy, stylish, rhythmic |
| Art gallery | 60-80 | Ambient, atmospheric |
| Retail store | 100-120 | Pleasant, encouraging movement |
| Spa / Wellness | 50-70 | Ultra-relaxing, nature sounds |

## Entertainment & Media

| Context | BPM | Notes |
|---------|-----|-------|
| Podcast intro | 100-120 | Short, memorable, energetic |
| YouTube intro | 110-140 | Catchy, dynamic, genre-appropriate |
| Video game menu | 80-100 | Atmospheric, loopable |
| Video game action | 130-160 | Intense, driving |
| Film tension | 80-110 | Building, suspenseful |
| Film action | 120-150 | Dynamic, powerful |
| Film romance | 60-80 | Tender, emotional |
| Advertisement | 110-130 | Energetic, memorable |

## Emotional Targets

| Emotion | BPM Range | Characteristics |
|---------|-----------|-----------------|
| Peaceful / Calm | 50-70 | Slow, ambient, minimal |
| Melancholic / Sad | 60-80 | Minor key, sparse |
| Romantic / Tender | 60-85 | Soft, emotional |
| Hopeful / Uplifting | 100-120 | Major key, building |
| Happy / Joyful | 110-130 | Bright, bouncy |
| Energetic / Excited | 130-150 | Driving, powerful |
| Aggressive / Intense | 140-180 | Heavy, relentless |
| Epic / Triumphant | 90-120 | Orchestral, building |

## Playlist Energy Curves

### Workout Session (30 min)
```
1. Warm-up (5 min): 110-120 BPM
2. Build (3 min): 130-140 BPM
3. Peak 1 (8 min): 150-160 BPM
4. Active recovery (2 min): 120 BPM
5. Peak 2 (8 min): 155-165 BPM
6. Cool-down (4 min): 90-100 → 70 BPM
```

### Running Session (45 min)
```
1. Warm-up (5 min): 110-120 BPM
2. Cruise (15 min): 130-140 BPM
3. Intervals (15 min): Alternate 150/120 BPM
4. Return (5 min): 130 BPM
5. Cool-down (5 min): 100-80 BPM
```

### Focus Session (2 hours)
```
1-4. Start (30 min): 70-80 BPM lo-fi
5-8. Deep work (30 min): 60-70 BPM ambient
9-12. Flow (30 min): 110-115 BPM minimal techno
13-16. Sustain (30 min): 75-85 BPM jazz lo-fi
```

### Event Progression (3 hours)
```
Hour 1 (Arrival): 90-100 BPM - Welcoming, sophisticated
Hour 2 (Main): 100-115 BPM - Engaging, uplifting
Hour 3 (Peak): 115-125 BPM - Energetic, memorable
```

## BPM Verification

Suno generally respects specified BPM (±5 BPM variance). For critical timing:
- Verify with external tools (songbpm.com, mybpmfinder.com)
- Specify exact BPM in prompt: "145 BPM" not "fast"
- Regenerate if BPM is significantly off
