# Distribution & Rights Guide (2025 Update)

## Suno Rights Overview

### By Plan

| Plan | Commercial Rights | Suno Studio | Credits/Month |
|------|-------------------|-------------|---------------|
| Free | No | No | 50/day |
| Pro (~$10/month) | Yes | No | 2,500 |
| Premier (~$30/month) | Yes | Yes | 10,000 |

### Key Points

- **Ownership**: Suno retains technical ownership, you get exploitation rights
- **Copyright (USCO 2025)**: 100% AI music generally not eligible for US copyright
- **Hybrid approach**: Write your own lyrics = human creative input = stronger copyright claim
- **After cancellation**: Keep rights on content created during subscription
- **Proof**: Keep invoices as license documentation
- **Warner Music deal (Nov 2025)**: Strategic partnership announced, terms evolving

### Copyright Strategy

To strengthen your rights:
1. Write original lyrics (human authorship)
2. Use Sample to Song with your own recordings
3. Edit in Studio (human creative decisions)
4. Document your creative process
5. Keep all invoices and generation records

### Legal Landscape (Late 2025)

Major labels (UMG, Sony, Warner) have filed copyright lawsuits against Suno alleging unauthorized training data use. Suno claims "fair use" defense. Case ongoing - monitor for updates that may affect distribution policies.

## Distribution Platforms

### Distributors Comparison

| Distributor | Price | Commission | AI Policy | Best For |
|-------------|-------|------------|-----------|----------|
| **DistroKid** | ~$25/year | 0% | Accepts | Volume, speed |
| **TuneCore** | ~$23/year | 0% | Restrictive | Publishing admin |
| **CD Baby** | $9.99/single | 9% | Against 100% AI | One-time releases |
| **SoundDrop** | $1/single | 0% | Permissive | Budget, AI content |
| **Amuse** | Free tier | 0% | Permissive | Testing |

### Streaming Platforms Reached

Most distributors cover:
- Spotify
- Apple Music
- Amazon Music
- Deezer
- Tidal
- YouTube Music
- TikTok / Instagram
- Pandora
- iHeartRadio
- 50+ others

## Distribution Process

### File Preparation

**Audio**:
- Format: WAV 16-bit/44.1kHz (preferred) or MP3 320kbps
- Loudness: -14 LUFS for streaming (Suno output usually acceptable)
- No clipping or distortion

**Artwork**:
- Size: 3000x3000 pixels minimum
- Format: JPG or PNG
- Color: RGB
- No text except artist/title
- No logos/trademarks you don't own

**Metadata**:
- Artist name
- Track title
- Album title (even for singles)
- Genre
- Release year
- ISRC code (usually auto-generated)

### Submission Steps

1. Create distributor account
2. Upload audio files
3. Upload artwork
4. Fill metadata (title, artist, genre)
5. Select platforms
6. Set release date (2-4 weeks ahead recommended)
7. Submit for review
8. Wait for approval

### Typical Delays

| Platform | Processing Time |
|----------|-----------------|
| Spotify | 2-7 days |
| Apple Music | 1-7 days |
| Amazon Music | 3-5 days |
| Others | Up to 2 weeks |

## Copyright Protection

### Avoiding Claims

**Do**:
- Write original lyrics
- Generate multiple versions, pick most unique
- Keep Suno invoices
- Document creation process
- Use descriptive prompts (not artist names)

**Don't**:
- Name specific artists in prompts
- Copy existing lyrics
- Use recognizable melodies intentionally
- Claim traditional copyright

### Handling Claims

If you receive a copyright claim:

1. **Don't panic** - False positives common with AI music
2. **Gather evidence**: Suno invoices, generation screenshots
3. **Dispute** through distributor's system
4. **Explain**: AI-generated with commercial license
5. **Contact support** if dispute fails
6. **Consider**: Remove and regenerate if persistent

## Monetization Options

### Streaming Revenue

| Platform | Per-Stream Rate |
|----------|-----------------|
| Spotify | ~$0.003-0.005 |
| Apple Music | ~$0.007-0.01 |
| Amazon Music | ~$0.004 |
| Tidal | ~$0.01-0.013 |

*Rates vary by country and subscription type*

### Alternative Revenue

**Sync Licensing**:
- Music in ads, films, TV, games
- TuneCore, CD Baby offer sync services
- Higher per-placement revenue

**Stock Music Platforms**:
| Platform | Your Cut | Model |
|----------|----------|-------|
| AudioJungle | 55-87.5% | Per-sale |
| Pond5 | 60% | Per-sale + subscription |
| Epidemic Sound | Fixed fee | Subscription (exclusive) |
| Artlist | Fixed fee | Subscription |

**Direct Sales**:
- Bandcamp: 85-90% to artist
- Gumroad: Direct sales of packs/albums
- Patreon: Exclusive content for subscribers

**YouTube Content ID**:
- Monetize when others use your music
- Set up through some distributors
- Passive income potential

## Spotify Optimization

### Spotify for Artists

1. Claim your profile after first release
2. Complete bio and photos
3. Link social accounts
4. Enable Canvas (video loops)
5. Submit for playlist consideration

### Editorial Pitch

Submit 2-4 weeks before release:
- Fill all fields completely
- Describe the track story
- Mention influences (without naming artists)
- Note any marketing planned

### Algorithmic Playlists

Triggered by engagement:
- Save rate
- Playlist adds
- Completion rate
- Repeat listens

Focus on quality over quantity for better algorithmic performance.

## Promotion Basics

### Pre-Release

- [ ] Create artist profiles on all platforms
- [ ] Prepare social media assets
- [ ] Schedule announcement posts
- [ ] Identify playlist curators to contact
- [ ] Set up pre-save campaign

### Release Day

- [ ] Share on all social platforms
- [ ] Send to playlist curators
- [ ] Engage with early listeners
- [ ] Monitor for any issues

### Post-Release

- [ ] Track streaming numbers
- [ ] Respond to feedback
- [ ] Submit to more playlists
- [ ] Plan next release to maintain momentum

## Legal Disclaimer

This guide provides general information. For specific legal or financial advice regarding music rights and distribution, consult qualified professionals. AI-generated music rights are an evolving area of law.
