# Project Types & Templates

## Single Track Projects

### Corporate Anthem / Company Song

**Purpose**: Celebrate company culture, values, team spirit

**Process**:
1. Research company website, values, mission
2. Identify key themes (innovation, teamwork, growth, etc.)
3. Choose tone (professional, fun, inspiring, quirky)
4. Write lyrics incorporating company-specific elements
5. Generate in appropriate style (pop-rock, electronic, etc.)

**Style suggestions**:
- Serious company: `Corporate inspiring, 120 BPM, uplifting, orchestral elements, powerful vocals`
- Tech startup: `Electropop, 125 BPM, modern, energetic, catchy hooks`
- Creative agency: `Indie rock, 115 BPM, quirky, playful, authentic vocals`

**Lyrics template**:
```
[Intro]
[Verse 1] - Company origin/mission
[Pre-Chorus] - Challenge/growth theme
[Chorus] - Core message, company name/slogan
[Verse 2] - Team/values focus
[Chorus]
[Bridge] - Future vision
[Chorus]
[Outro]
```

### Jingle / Advertisement

**Purpose**: Memorable short piece for brand recognition

**Characteristics**:
- Duration: 15-60 seconds
- Catchy hook in first 5 seconds
- Brand name repeated 2-3 times
- Simple, memorable melody

**Process**:
1. Define key message (one main idea)
2. Write ultra-short lyrics (4-8 lines max)
3. Focus on hook/tagline
4. Generate multiple versions
5. Crop to exact length needed

**Style suggestions**:
- Radio ad: `Catchy pop jingle, 120 BPM, bright, memorable hook, cheerful vocals`
- Luxury brand: `Elegant cinematic, 90 BPM, sophisticated, orchestral, no vocals`
- Tech product: `Modern electronic, 128 BPM, sleek, futuristic, minimal vocals`

### Personalized Song (Gift)

**Purpose**: Custom song for birthday, wedding, anniversary, etc.

**Process**:
1. Gather personal details (names, story, inside jokes)
2. Define emotional tone (funny, romantic, nostalgic)
3. Write personalized lyrics
4. Choose genre matching recipient's taste
5. Generate and select most emotionally resonant version

**Key elements**:
- Include names naturally in lyrics
- Reference specific shared memories
- Match recipient's music preferences
- Consider occasion appropriateness

### Event Theme Song

**Purpose**: Original music for conference, festival, launch

**Process**:
1. Understand event theme and audience
2. Define energy level and duration needed
3. Write lyrics around event message
4. Generate in appropriate style
5. Prepare different lengths (full, 60s, 30s)

---

## Playlist Projects

### Workout Playlist

**Structure**: Energy curve matching exercise phases

**Template (30 min)**:
| # | Phase | BPM | Duration |
|---|-------|-----|----------|
| 1 | Warm-up | 110-120 | 5 min |
| 2 | Build | 130-140 | 3 min |
| 3-4 | Peak | 150-160 | 8 min |
| 5 | Active recovery | 120 | 2 min |
| 6-7 | Peak 2 | 155-165 | 8 min |
| 8 | Cool-down | 90→70 | 4 min |

**Consistency tips**:
- Use same voice type throughout (or intentional alternation)
- Maintain genre family (EDM variants, rock variants)
- Apply Remaster (Subtle) to all tracks

### Focus / Study Playlist

**Structure**: Sustained low energy, minimal distraction

**Characteristics**:
- BPM: 60-90
- Mostly instrumental or subtle vocals
- No sudden changes or drops
- Loopable, ambient qualities

**Genre mix**:
- Lo-fi hip-hop
- Ambient electronic
- Minimal piano
- Jazz instrumentals

**Template (2 hours)**:
| Block | Duration | Style | BPM |
|-------|----------|-------|-----|
| 1-4 | 30 min | Lo-fi hip-hop | 70-80 |
| 5-8 | 30 min | Ambient | 60-70 |
| 9-12 | 30 min | Minimal electronic | 100-110 |
| 13-16 | 30 min | Jazz lo-fi | 75-85 |

### Event Ambiance Playlist

**Structure**: Progressive energy matching event timeline

**Template (3-hour event)**:
| Phase | Duration | Mood | BPM |
|-------|----------|------|-----|
| Arrival | 45 min | Welcoming | 90-100 |
| Mingling | 45 min | Upbeat | 100-110 |
| Main event | 60 min | Energetic | 110-120 |
| Peak | 30 min | High energy | 120-130 |

### Children's Music Album

**Characteristics**:
- BPM: 100-120 (active), 70-90 (calm)
- Simple, repetitive lyrics
- Educational or fun themes
- Bright, playful instrumentation
- Age-appropriate content

**Track types**:
- Action songs (movement, dance)
- Learning songs (ABCs, numbers, colors)
- Calming songs (bedtime, relaxation)
- Story songs (narrative, characters)

---

## Client Project Workflow

### Discovery Phase

Gather from client:
- [ ] Brand guidelines (colors, tone, values)
- [ ] Target audience demographics
- [ ] Existing music references (what they like)
- [ ] Anti-references (what to avoid)
- [ ] Usage context (where music will play)
- [ ] Duration requirements
- [ ] Budget for revisions
- [ ] Timeline

### Production Phase

1. **Create brief summary** documenting all requirements
2. **Generate 3-5 concepts** with different approaches
3. **Present options** with rationale for each
4. **Refine selected direction** based on feedback
5. **Produce final versions** (different lengths if needed)
6. **Deliver files** in required formats

### Delivery Checklist

- [ ] WAV master files
- [ ] MP3 preview files
- [ ] Different lengths (full, 60s, 30s, 15s)
- [ ] Stems if requested
- [ ] Usage rights documentation
- [ ] Invoice/proof of Suno license

---

## Session Documentation

For any project, document:

```
## Project: [Name]
**Date**: [Date]
**Client/Purpose**: [Details]
**Type**: [Single/Playlist/Album]

### Requirements
- Style: [Genre, mood]
- Duration: [Length]
- Voice: [Type]
- Special requests: [Notes]

### Generation Log
| Track | Attempts | Final Prompt | Notes |
|-------|----------|--------------|-------|
| 1 | X | [prompt] | [notes] |

### Successful Prompts
[Save prompts that worked well for future reference]

### Lessons Learned
[What to do differently next time]
```
