# E-Learning Prompt Library for Supermachine

Ready-to-use prompts for generating course assets. Customize bracketed text for your needs.

## Course Thumbnails

### Engagement/Excitement
```
enthusiastic young professional looking at laptop screen with
excited expression, pumping fist in celebration, modern bright
office, natural window light, shallow depth of field, 16:9,
photorealistic, stock photo quality
```

### Achievement/Success
```
diverse group of professionals celebrating achievement,
high-fives and smiles, modern office confetti, bright and
energetic mood, 16:9, photorealistic, vibrant
```

### Learning/Discovery
```
curious young adult having "aha moment" while studying,
lightbulb metaphor, warm natural lighting, coffee shop
setting, engaged expression, 16:9, photorealistic
```

### Professional Development
```
young professional in business casual climbing symbolic
ladder or stairs, upward journey, bright sky background,
aspirational mood, 16:9, photorealistic, motivational
```

## Module Headers & Banners

### Resume Building
```
professional resume document on modern desk, silver pen,
cup of coffee, laptop in background, soft morning light
streaming through window, shallow depth of field, clean
aesthetic, 16:9, photorealistic
```

### Interview Preparation
```
professional notepad with interview questions, confident
hand writing notes, business attire visible, conference
room background blur, natural lighting, 3:1 banner,
photorealistic
```

### Job Search Strategy
```
laptop showing job listings, person's hands on keyboard,
modern home office, plants and natural light, focused
work atmosphere, 16:9, photorealistic, contemporary
```

### Networking
```
smartphones showing LinkedIn app, business cards scattered,
modern workspace, networking concept, warm natural light,
16:9, photorealistic, professional
```

### Personal Branding
```
person holding professional portfolio or tablet showing
their work, confident posture, modern creative space,
natural lighting, personal brand concept, 16:9, photorealistic
```

## Instructional Illustrations

### Process/Step Diagrams (Background)
```
abstract minimal gradient background, soft blue to white,
clean professional, ample space for text overlay, subtle
geometric shapes, corporate style, 16:9
```

### Comparison Visuals
```
split screen concept, two paths or choices, clean visual
metaphor, minimal design, blue and orange accent colors,
suitable for text overlay, 16:9, modern illustration style
```

### Checklist/Worksheet Background
```
clean minimal background with subtle paper texture, light
grey or cream color, space for content overlay, professional
and clean, document aesthetic, 8.5x11 aspect ratio
```

## People & Scenarios

### Job Candidate - Confident
```
confident young professional, [age 20s-30s], [ethnicity],
[gender], wearing business professional attire, warm genuine
smile, office setting background with bokeh, natural lighting,
professional headshot style, photorealistic
```

### Hiring Manager - Approachable
```
friendly hiring manager, [age 35-50], [ethnicity], [gender],
welcoming expression, sitting in modern office, warm smile,
professional but approachable, natural lighting, photorealistic
```

### Interview Scene - Positive
```
job interview in progress, candidate and interviewer in
conversation, positive body language, modern conference room,
glass walls, natural daylight, engaged expressions, side angle,
photorealistic
```

### Networking Event
```
professionals at networking event, diverse group, holding
drinks and business cards, animated friendly conversation,
modern venue with warm lighting, social professional setting,
photorealistic
```

### Working at Computer
```
young professional [age 20s] working intently at laptop,
modern workspace, focused but relaxed expression, coffee
nearby, natural window light, contemporary office or cafe,
photorealistic
```

### Receiving Good News
```
young professional reading phone or paper with excited happy
expression, just received job offer, bright natural light,
joyful authentic reaction, modern setting, photorealistic
```

## Concept Illustrations

### Career Path/Growth
```
symbolic winding path leading upward, career journey metaphor,
bright sunny sky, inspirational composition, opportunity ahead,
clean illustration style, motivational imagery
```

### Resume Stack
```
stack of professional resumes on desk, top resume highlighted
or glowing, recruiter's perspective, office setting, natural
lighting, the standout concept, photorealistic
```

### Digital Presence
```
laptop screen showing LinkedIn profile, professional online
presence concept, modern desk setup, smartphone with notifications,
connected professional world, natural lighting, photorealistic
```

### Time Management
```
clean desk with organized planner, clock visible, productivity
concept, morning light, fresh start aesthetic, professional
organization, photorealistic, minimal clutter
```

## Flat Design & Icons

### Resume Icon
```
flat design resume document icon, single page with lines
representing text, small checkmark, clean minimal style,
blue and white color scheme, solid color background, vector style
```

### Interview Icon
```
flat design icon of two people across table, interview concept,
minimal geometric shapes, professional blue color palette,
clean lines, solid background, modern icon style
```

### Target/Goal Icon
```
flat design target with arrow in bullseye, achievement concept,
red and white target, blue arrow, minimal style, clean vector,
solid background
```

### Handshake Icon
```
flat design handshake icon, professional agreement concept,
two hands in business shake, blue color scheme, minimal vector
style, clean lines, solid background
```

### Briefcase/Career Icon
```
flat design briefcase icon, professional work concept, clean
geometric style, navy blue and gold accents, minimal vector,
solid background
```

## Backgrounds & Textures

### Professional Gradient
```
smooth gradient background, deep navy blue transitioning to
lighter blue, professional corporate feel, suitable for text
overlay, clean minimal, 16:9
```

### Abstract Professional
```
abstract flowing shapes, soft blue and white, professional
business aesthetic, minimal and clean, suitable for text
and graphics overlay, subtle movement, 16:9
```

### Workspace Blur
```
blurred modern office background, bokeh lights, desks and
computers out of focus, professional environment, natural
lighting, suitable as background, 16:9
```

### Paper Texture
```
clean white paper texture, subtle grain, professional document
feel, suitable for text overlay, minimal, light and clean,
full frame
```

## Negative Prompt Templates

### Standard for All Images
```
poorly drawn, bad anatomy, wrong proportions, extra limbs,
cloned face, disfigured, gross proportions, malformed limbs,
missing arms, missing legs, extra arms, extra legs, fused
fingers, too many fingers, long neck, blurry, low quality,
watermark, signature, text unless specified
```

### For People/Portraits
```
poorly drawn face, bad face, fused face, ugly face, asymmetrical,
unrealistic skin texture, bad proportions, out of frame, double
face, crossed eyes, distorted features
```

### For Professional Settings
```
messy, cluttered, unprofessional, casual, sloppy, low quality,
amateur, poor lighting, dark, gloomy, dirty, unkempt
```

### For Hands
```
extra digits, extra hands, fused fingers, malformed limbs,
mutated hands, poorly drawn hands, extra fingers, missing
hands, bad hands, three hands, too many fingers, deformed hands
```

## Model Selection Quick Reference

| Image Type | Recommended Model |
|------------|-------------------|
| Professional Photos | Flux, Crystal Clear XL, Epic Realism |
| Portraits/Headshots | Super Portrait |
| Images with Text | Flux (required) |
| Flat Design | Vector/Illustration models |
| Abstract Backgrounds | Any SDXL model |
| Anime/Stylized | Supermachine Anime |
| Icons/Logos | Logos & Icons model |

## Customization Variables

Replace these in prompts as needed:

- `[age 20s-30s]` → specific age range for your audience
- `[ethnicity]` → ensure diversity in your assets
- `[gender]` → vary across your course
- `[setting]` → office, cafe, home office, conference room
- `[attire]` → business professional, business casual, smart casual
- `[emotion]` → confident, focused, excited, thoughtful, friendly
