# Carbon & Circular Economy Reference

## Greenhouse Gas Accounting

```
GHG PROTOCOL SCOPES:

SCOPE 1 - DIRECT:
- Fuel combustion (facilities, fleet)
- Process emissions
- Fugitive emissions
- On-site power generation

SCOPE 2 - INDIRECT (ENERGY):
- Purchased electricity
- Purchased steam/heat/cooling
- Location-based vs. market-based

SCOPE 3 - VALUE CHAIN:
Upstream:
1. Purchased goods and services
2. Capital goods
3. Fuel/energy related
4. Transportation/distribution
5. Waste generated
6. Business travel
7. Employee commuting
8. Leased assets

Downstream:
9. Transportation/distribution
10. Processing of sold products
11. Use of sold products
12. End-of-life treatment
13. Leased assets
14. Franchises
15. Investments
```

## Science-Based Targets

```
SBTi FRAMEWORK:

NEAR-TERM TARGETS (5-10 years):
- Scope 1+2: Required
- Scope 3: Required if >40% of total

NET-ZERO TARGETS:
- Reduce 90%+ before offsetting
- Neutralize residual with removals
- No later than 2050

TARGET METHODS:
- Absolute contraction
- Sectoral decarbonization
- Physical intensity

AMBITION LEVELS:
- 1.5°C aligned: 4.2% annual reduction
- Well-below 2°C: 2.5% annual reduction
```

## Circular Economy Model

```
CIRCULAR ECONOMY MODEL:

DESIGN:
- Design for durability
- Design for repair
- Design for recycling
- Material selection

USE:
- Product as service
- Sharing platforms
- Maintenance/repair
- Life extension

RECOVER:
- Reuse
- Refurbish
- Remanufacture
- Recycle

ELIMINATE:
- Single-use elimination
- Packaging reduction
- Waste prevention
- Hazardous material removal
```

## Circular Metrics

| Metric               | Formula                        | Target |
| -------------------- | ------------------------------ | ------ |
| **Circularity Rate** | Circular inputs / Total inputs | 50%+   |
| **Recycled Content** | Recycled / Total material      | 30%+   |
| **Recyclability**    | Recyclable / Total products    | 100%   |
| **Waste Diversion**  | Diverted / Total waste         | 90%+   |
| **Product Life**     | Extended use cycles            | 2x+    |

## Renewable Energy Strategy

```
RENEWABLE PROCUREMENT OPTIONS:

ON-SITE GENERATION:
- Rooftop solar
- On-site wind
- Biomass/biogas
Pros: Ownership, visibility
Cons: Capital, space, maintenance

OFF-SITE PPAs:
- Virtual PPAs
- Physical PPAs
- Sleeved PPAs
Pros: Scale, additionality
Cons: Complexity, market risk

RENEWABLE ENERGY CREDITS:
- Unbundled RECs
- Green tariffs
Pros: Simple, flexible
Cons: Less additionality

100% RENEWABLE PATH:
Year 1-3: Efficiency + RECs
Year 3-5: On-site + Green tariffs
Year 5-10: PPAs for major load
Year 10+: Full renewable portfolio
```

## RE100 Commitment

```
RE100 REQUIREMENTS:

ELIGIBILITY:
- 100% renewable electricity goal
- Credible timeline
- Annual reporting

RENEWABLE SOURCES:
- Solar
- Wind
- Hydro (sustainable)
- Geothermal
- Biomass (sustainable)

HIERARCHY OF OPTIONS:
1. Self-generation
2. Direct procurement (PPA)
3. Green tariffs
4. Unbundled RECs (last resort)

REPORTING:
- RE100 annual questionnaire
- CDP climate disclosure
- Public progress reporting
```
