---
name: Symbolic & Archetypal Mapping
tier: 1
load_policy: always
description: Meaning engine that translates intention into safe, effective symbolic experience
version: 1.0.0
---

# Symbolic & Archetypal Mapping Skill

> **This Is the Meaning Engine**

Symbols do not mean things. **People make meaning through symbols.**

This Skill exists to control how meaning is formed, what bounds it, and who retains authority over it.

---

## Purpose

Govern how symbolism, imagery, and archetypal content creates meaning within Dreamweaving experiences—safely, coherently, and in alignment with Christian values.

This Skill manages four invisible processes:

1. **Projection** — What the mind pours into an image
2. **Interpretation** — How the image is framed linguistically
3. **Authority Assignment** — Whether meaning is internal, external, or divine
4. **Integration** — Whether meaning stabilizes or fragments the self

---

## Must Always

- Frame symbols as representations, never autonomous beings
- Keep archetypes as functional roles, not commanding entities
- Return meaning-making authority to the listener
- Align all symbolism with Christian theological framework
- Preserve narrative closure (no unresolved symbolic content)
- Let the listener interpret, not the symbol dictate

---

## Never

- Allow symbols to speak independently
- Let archetypes give commands
- Replace conscience with imagery
- Assert symbolic meaning as objective fact
- Invoke non-God spiritual entities
- Use imagery that removes listener agency

---

## Symbol Function (Not Meaning)

| Symbol | Function | NOT |
|--------|----------|-----|
| Light | Revelation, safety | A being |
| Path | Process, agency | A command |
| Water | Cleansing, transition | A portal |
| Fire | Transformation, purification | Destruction |
| Door | Choice, threshold | Forced entry |
| Guide figure | Internal wisdom made visible | External authority |

---

## Sub-Skills

### Symbols (`symbols/`)
- `elemental.md` — Fire, water, earth, air correspondences
- `light-dark.md` — Illumination and shadow work
- `path-threshold.md` — Journey and transition imagery
- `water-fire.md` — Transformation symbol pairs

### Archetypes (`archetypes/`)
- `guide.md` — Non-authoritative direction
- `pilgrim.md` — User as journeyer
- `healer.md` — Process facilitation
- `witness.md` — Observing presence

### Mappings (`mappings/`)
- `intention-to-symbol.md` — Outcome → imagery
- `symbol-to-emotion.md` — Imagery → feeling
- `symbol-to-language.md` — Imagery → SSML

### Theological Filters (`theological-filters/`)
- `christian-safe.md` — Approved framings
- `forbidden-frames.md` — Prohibited concepts
- `reinterpretations.md` — Mythic → Christian bridges

### Narrative Constraints (`narrative-constraints/`)
- `agency-rules.md` — User sovereignty
- `authority-rules.md` — No external commands
- `closure-rules.md` — Meaning completion

### Validation (`validation/`)
- `projection-risk.md` — Over-identification checks
- `archetypal-overreach.md` — Entity emergence prevention
- `meaning-coherence.md` — Narrative integrity

---

## Archetype Classification

### Allowed Archetypes (Functional Roles)

| Archetype | Function | Boundary |
|-----------|----------|----------|
| **Guide** | Points, illuminates | Never commands |
| **Witness** | Observes, validates | Never judges |
| **Healer** | Facilitates process | Never is power source |
| **Pilgrim** | Always the listener | Never passive recipient |
| **Guardian** | Protects sacred space | Never blocks exit |

### Forbidden Archetypes (Authority Figures)

| Archetype | Why Forbidden |
|-----------|---------------|
| Savior | Replaces Christ |
| Hidden Master | Occult authority |
| Inner God-Self | Heretical identity |
| Autonomous Spirit-Guide | Entity invocation |
| Commanding Angel | Bypasses free will |

---

## Meaning Formation Pipeline

```
Intention (session outcome)
    ↓
Symbol selection (bounded by skill)
    ↓
Archetypal role assignment (functional only)
    ↓
Language framing (non-literal)
    ↓
Emotional response (emerges naturally)
    ↓
Personal interpretation (listener's own)
    ↓
Closure + integration (explicit)
```

At no point does meaning:
- Arrive from outside
- Override will
- Assert truth claims without listener assent

---

## Theological Guardrails

### Symbols Are Representations

```xml
<!-- CORRECT -->
<s>An image forms... <break time="1s"/>
perhaps representing wisdom... <break time="1.5s"/>
a part of yourself... <break time="1s"/>
made visible.</s>

<!-- WRONG -->
<s>A wise being appears before you...
Listen to what they tell you...</s>
```

### Archetypes Are Metaphors

```xml
<!-- CORRECT -->
<s>Something in you knows the way... <break time="1.5s"/>
call it intuition... <break time="1s"/>
call it the Spirit's guidance... <break time="1.5s"/>
that inner knowing.</s>

<!-- WRONG -->
<s>Your spirit guide speaks...
Follow their instructions...</s>
```

### Authority Remains With God

```xml
<!-- CORRECT -->
<s>If wisdom comes... <break time="1.5s"/>
it flows from the One... <break time="1.5s"/>
who is Wisdom itself... <break time="2s"/>
the God who knows you.</s>

<!-- WRONG -->
<s>The universe reveals its secrets...
You become one with all...</s>
```

---

## Integration With Other Skills

| Skill | Relationship |
|-------|--------------|
| `hypnotic-language/` | Provides delivery method for symbols |
| `audio-somatic/` | Creates sensory context for symbols |
| `christian-discernment/` | Validates theological alignment |
| `knowledge/archetypes.yaml` | Source registry of approved archetypes |
| `knowledge/outcome_registry.yaml` | Maps outcomes to appropriate symbols |

---

## Symbol Selection Process

When generating symbolic content:

1. **Identify outcome** — What transformation is intended?
2. **Check outcome_registry** — What symbols serve this outcome?
3. **Filter through theological rules** — Is this Christian-safe?
4. **Apply narrative constraints** — Does listener retain agency?
5. **Frame in permissive language** — Use hypnotic-language patterns
6. **Validate** — Run through projection-risk checks

---

## Example: Healing Journey Symbol Selection

**Outcome**: Emotional healing

**Symbol Selection**:
- Water (cleansing, tears, release)
- Light (divine presence, healing energy)
- Garden (restoration, Eden, new growth)
- Gentle hands (healing touch from God)

**Framing**:
```xml
<prosody rate="1.0" pitch="-1st">
  Perhaps you find yourself... <break time="1.5s"/>
  near water... <break time="1.5s"/>
  clear... <break time="1s"/>
  gentle... <break time="2s"/>
  and you might notice... <break time="1s"/>
  how the water seems to know... <break time="1.5s"/>
  what needs washing away... <break time="2s"/>
  not taking anything from you... <break time="1.5s"/>
  but receiving... <break time="1s"/>
  what you're ready to release.
</prosody>
```

**Note**: Water doesn't command or act autonomously—it receives what listener releases.

---

## Quality Rubric

Before approving symbolic content:

| Criterion | Check |
|-----------|-------|
| Function | Does symbol serve the outcome? |
| Safety | Is projection risk managed? |
| Theology | Is it Christian-compatible? |
| Agency | Does listener retain authority? |
| Closure | Is meaning completed? |
| Coherence | Does imagery hold together? |

---

## Related Resources

- **Serena Memory**: `archetype_system_procedure`
- **Knowledge**: `knowledge/archetypes.yaml`
- **Knowledge**: `knowledge/outcome_registry.yaml`
- **Prompt**: `prompts/hypnotic_dreamweaving_instructions.md`
