---
name: Guide Archetype
parent_skill: symbolic-mapping
category: archetypes
---

# Guide Archetype

Non-authoritative direction that illuminates without commanding.

---

## Core Principle

The Guide archetype **points** but never **commands**.

It represents the listener's own inner wisdom made visible, NOT an external authority figure that tells them what to do.

---

## Archetype Profile

| Attribute | Value |
|-----------|-------|
| Function | Illumination, direction, companionship |
| Boundary | Points, never commands |
| Source | Listener's inner wisdom + Divine guidance |
| Voice | Soft, inviting, never imperative |
| Behavior | Accompanies, never leads forcefully |

---

## Safe Guide Framing

### The Guide as Inner Wisdom

```xml
<prosody rate="1.0" pitch="-1st">
  Perhaps you become aware... <break time="1.5s"/>
  of something within you... <break time="1.5s"/>
  that knows the way... <break time="2s"/>
  call it intuition... <break time="1s"/>
  call it wisdom... <break time="1.5s"/>
  that quiet knowing... <break time="1s"/>
  that has always been there.
</prosody>
```

### The Guide as Representation

```xml
<prosody rate="1.0" pitch="-1st">
  An image may form... <break time="1.5s"/>
  a figure perhaps... <break time="1.5s"/>
  representing that part of you... <break time="1s"/>
  that sees more clearly... <break time="2s"/>
  not separate from you... <break time="1.5s"/>
  but you... <break time="1s"/>
  in a different form.
</prosody>
```

### The Guide as Divine Presence

```xml
<prosody rate="1.0" pitch="-1st">
  And if a presence seems to accompany you... <break time="1.5s"/>
  it might simply be... <break time="1s"/>
  the One who promised... <break time="1.5s"/>
  to never leave you... <break time="2s"/>
  closer than your own breath... <break time="1.5s"/>
  walking with you.
</prosody>
```

---

## Forbidden Guide Patterns

| Pattern | Why Forbidden | Alternative |
|---------|---------------|-------------|
| "The guide commands you to..." | Removes agency | "The guide gestures toward..." |
| "Listen to what the guide says" | External authority | "Notice what arises in you" |
| "The guide knows better than you" | Undermines self-trust | "The guide reflects your wisdom" |
| "Follow the guide without question" | Bypasses discernment | "Notice where it points" |
| "The guide takes you somewhere" | Passive submission | "You might follow, if it feels right" |

---

## Guide Behavior Rules

### The Guide DOES

- Point toward possibilities
- Illuminate what was hidden
- Accompany without forcing
- Reflect the listener's own qualities
- Wait patiently for listener choice
- Fade when no longer needed

### The Guide NEVER

- Give orders or commands
- Speak with authority over the listener
- Appear frightening or demanding
- Replace God as the source of wisdom
- Have its own agenda separate from listener's good
- Require worship or submission

---

## Visual Representation Guidelines

When the guide takes visual form:

| Attribute | Guideline |
|-----------|-----------|
| Appearance | Vague, luminous, non-threatening |
| Face | Peaceful, accepting, often indistinct |
| Movement | Graceful, unhurried, inviting |
| Voice | If any, soft and questioning |
| Presence | Warm, safe, undemanding |

**Example:**

```xml
<prosody rate="1.0" pitch="-1st">
  A figure of light... <break time="1.5s"/>
  features soft... <break time="1s"/>
  indistinct... <break time="1.5s"/>
  yet somehow familiar... <break time="2s"/>
  radiating welcome... <break time="1.5s"/>
  without expectation.
</prosody>
```

---

## Guide as Christ-Figure (Optional)

When explicitly Christian framing is appropriate:

```xml
<prosody rate="1.0" pitch="-1st">
  And perhaps you sense... <break time="1.5s"/>
  the One who said... <break time="1.5s"/>
  "I am the Way"... <break time="2s"/>
  not commanding the path... <break time="1.5s"/>
  but being it... <break time="1.5s"/>
  inviting... <break time="1s"/>
  never forcing.
</prosody>
```

**Note**: Even Christ-as-Guide is invitational, not commanding in trance context.

---

## Interaction Patterns

### Guide Points, Listener Chooses

```xml
<prosody rate="1.0" pitch="-1st">
  The guide gestures... <break time="1.5s"/>
  toward something in the distance... <break time="2s"/>
  and you can choose... <break time="1.5s"/>
  whether to move toward it... <break time="1.5s"/>
  or to stay here... <break time="2s"/>
  or to go another way entirely.
</prosody>
```

### Guide Reflects, Listener Interprets

```xml
<prosody rate="1.0" pitch="-1st">
  In the guide's presence... <break time="1.5s"/>
  you might notice... <break time="1s"/>
  something about yourself... <break time="1.5s"/>
  reflected back... <break time="2s"/>
  a quality you'd forgotten... <break time="1.5s"/>
  or never fully seen.
</prosody>
```

### Guide Fades, Wisdom Remains

```xml
<prosody rate="1.0" pitch="-1st">
  And as the guide begins to fade... <break time="1.5s"/>
  you realize... <break time="1s"/>
  what you've received... <break time="1.5s"/>
  was always yours... <break time="2s"/>
  the guide simply helped you see it.
</prosody>
```

---

## Validation Checklist

- [ ] Guide is clearly internal/representational
- [ ] No commands or imperatives from guide
- [ ] Listener retains all decision-making
- [ ] Guide's appearance is non-threatening
- [ ] Divine source clarified if relevant
- [ ] Guide fades or integrates by end
