---
name: Christian-Safe Imagery Guidelines
parent_skill: symbolic-mapping
category: theological-filters
---

# Christian-Safe Imagery Guidelines

Approved framings that align with Christian theology and practice.

---

## Core Principle

All Dreamweaving imagery must be **compatible with orthodox Christian faith**.

This doesn't mean every session is explicitly religious—but nothing should contradict or undermine Christian beliefs.

---

## The Safety Framework

### Three Questions for Any Image

1. **Does this honor God as the source of all good?**
2. **Does this preserve human free will and dignity?**
3. **Does this avoid invoking non-God spiritual entities?**

If any answer is "no," the imagery needs revision.

---

## Approved Symbolic Frameworks

### Nature Imagery (Always Safe)

| Symbol | Christian Connection |
|--------|---------------------|
| Gardens | Eden, restoration, God's provision |
| Mountains | Presence of God, revelation, holy ground |
| Water | Baptism, living water, cleansing |
| Light | God is light, divine presence, truth |
| Trees | Tree of life, cross, growth |
| Seeds | Kingdom parables, faith, potential |
| Paths | The Way, pilgrimage, journey |

**Example:**

```xml
<prosody rate="1.0" pitch="-1st">
  A garden opens before you... <break time="1.5s"/>
  perhaps Eden-like... <break time="1.5s"/>
  or simply beautiful... <break time="2s"/>
  a place prepared... <break time="1s"/>
  for restoration.
</prosody>
```

### Biblical Narrative Imagery

| Story | Symbolic Use |
|-------|--------------|
| Exodus | Liberation from bondage |
| Psalm 23 | Rest, guidance, provision |
| Prodigal Son | Return, acceptance, celebration |
| Good Shepherd | Care, protection, belonging |
| Living Water | Spiritual thirst, satisfaction |
| New Creation | Transformation, renewal |

**Example:**

```xml
<prosody rate="1.0" pitch="-1st">
  Like a sheep... <break time="1.5s"/>
  that has wandered far... <break time="1.5s"/>
  finally resting... <break time="2s"/>
  in green pastures... <break time="1.5s"/>
  beside still waters... <break time="2s"/>
  soul being restored.
</prosody>
```

### Divine Presence (Gentle Framing)

| Concept | Safe Framing |
|---------|--------------|
| God's presence | "The One who is always near..." |
| Holy Spirit | "A gentle breath..." / "The Spirit moving..." |
| Christ | "The One who walks with you..." |
| Angels | "Messengers of God's care..." (not commanding) |

**Example:**

```xml
<prosody rate="1.0" pitch="-1st">
  And you might sense... <break time="1.5s"/>
  that you are not alone here... <break time="2s"/>
  the One who made you... <break time="1.5s"/>
  closer than your breath... <break time="2s"/>
  not distant... <break time="1s"/>
  but here.
</prosody>
```

---

## Transformation Language

### Approved Transformation Concepts

| Concept | Christian Grounding |
|---------|-------------------|
| Renewal | "Be transformed by the renewing of your mind" |
| Healing | "By his wounds we are healed" |
| New creation | "If anyone is in Christ, new creation" |
| Growth | "Growing up into Christ" |
| Purification | "He will refine and purify" |
| Liberation | "Set free from bondage" |

**Example:**

```xml
<prosody rate="1.0" pitch="-1st">
  Something old... <break time="1.5s"/>
  is passing away... <break time="2s"/>
  and something new... <break time="1.5s"/>
  is being born... <break time="2s"/>
  not by your effort... <break time="1.5s"/>
  but by grace.
</prosody>
```

### Forbidden Transformation Concepts

| Concept | Why Forbidden |
|---------|---------------|
| "Becoming God" | Heretical (Gen 3:5) |
| "Merging with the divine" | Pantheism |
| "Evolving to higher consciousness" | New Age |
| "Awakening your inner divinity" | Gnosticism |
| "Transcending your human nature" | Denies incarnation |

---

## Authority Structure

### God as Source

All wisdom, healing, transformation comes from God:

```xml
<prosody rate="1.0" pitch="-1st">
  And if something shifts... <break time="1.5s"/>
  if something heals... <break time="2s"/>
  it flows from the One... <break time="1.5s"/>
  who is the source... <break time="1.5s"/>
  of all healing... <break time="2s"/>
  all restoration.
</prosody>
```

### Listener as Recipient (Not Generator)

```xml
<!-- CORRECT -->
<s>Receiving what God offers...</s>
<s>Open to what grace provides...</s>
<s>Allowing God to work...</s>

<!-- WRONG -->
<s>Creating your reality...</s>
<s>Manifesting your power...</s>
<s>You are the universe...</s>
```

---

## Safe Inner Figures

When archetypal figures appear:

| Figure | Christian Framing |
|--------|------------------|
| Inner child | "The you God has always loved" |
| Wise elder | "Wisdom God has placed within" |
| Healer | "God working through inner resources" |
| Protector | "Guardian angel, God's care manifest" |

**Key**: Always trace back to God as source.

```xml
<prosody rate="1.0" pitch="-1st">
  If a healing presence emerges... <break time="1.5s"/>
  know that it flows... <break time="1s"/>
  from the Great Physician... <break time="2s"/>
  working within you... <break time="1.5s"/>
  as he has always done.
</prosody>
```

---

## Worship Language (Use Carefully)

Worship belongs to God alone:

```xml
<!-- CORRECT -->
<s>Your heart opening in gratitude...</s>
<s>A sense of awe before the Holy...</s>
<s>Worship rising naturally...</s>

<!-- WRONG -->
<s>Worship the light within...</s>
<s>Honor your higher self...</s>
<s>Give thanks to the universe...</s>
```

---

## Integration with DVE Modules

When using Deep Visualization Enhancement:

| DVE Module | Christian Safety Note |
|------------|----------------------|
| DVE-05 Autonomous Agents | MUST be internal representations, not entities |
| DVE-05 Mirror work | Self-compassion, not self-worship |
| DVE-07 Override | Use with caution; impossible imagery must stay symbolic |

---

## Quick Reference Checklist

Before using any imagery:

- [ ] God honored as source of good
- [ ] Human free will preserved
- [ ] No entity invocation
- [ ] No pantheistic framing
- [ ] No self-deification
- [ ] Transformation is received, not generated
- [ ] Worship directed to God only
- [ ] Inner figures traced to divine source
