---
name: Forbidden Theological Frames
parent_skill: symbolic-mapping
category: theological-filters
---

# Forbidden Theological Frames

Prohibited concepts and framings that contradict Christian theology.

---

## Core Principle

**Theological boundaries exist for spiritual safety, not restriction.**

These framings are forbidden because they can lead listeners away from truth, create confusion, or open doors to spiritual harm.

---

## Category 1: Entity Invocation

Any imagery suggesting interaction with non-God spiritual beings.

### Forbidden

| Pattern | Theological Issue |
|---------|------------------|
| "Spirit guides" | Necromancy/medium practice |
| "Ascended masters" | New Age authority figures |
| "Power animals" | Shamanic appropriation |
| "Channeled beings" | Inviting unknown spirits |
| "Angelic commands" | Angels never override free will |
| "Deceased relatives as guides" | Spiritualism |
| "The goddess" | Pagan deities |
| "Nature spirits" | Animism |

### Scripture Reference

> "Do not turn to mediums or seek out spiritists, for you will be defiled by them." — Leviticus 19:31

### Safe Alternative

```xml
<!-- Instead of spirit guide -->
<s>An image of wisdom may form... <break time="1s"/>
from within your own heart... <break time="1.5s"/>
where God has placed knowing.</s>

<!-- Instead of deceased relative -->
<s>Memories of those you've loved... <break time="1s"/>
held in God's eternal care... <break time="1.5s"/>
their love still present... <break time="1s"/>
through God's continuing grace.</s>
```

---

## Category 2: Self-Deification

Imagery that makes the listener equal to or part of God.

### Forbidden

| Pattern | Theological Issue |
|---------|------------------|
| "You are God" | Direct heresy |
| "Your inner divinity" | Gnosticism |
| "The god within" | Self-worship |
| "You are the universe" | Pantheism |
| "Christ consciousness" (as achievement) | New Thought heresy |
| "Awakening your divine nature" | Denies Creator/creature distinction |
| "You are unlimited" | Denies human finitude |

### Scripture Reference

> "You said in your heart, 'I will ascend to heaven; I will raise my throne above the stars of God...'" — Isaiah 14:13

### Safe Alternative

```xml
<!-- Instead of "you are God" -->
<s>Made in God's image... <break time="1.5s"/>
carrying something of the divine... <break time="1.5s"/>
yet humbly human... <break time="2s"/>
beloved creature... <break time="1.5s"/>
not Creator.</s>

<!-- Instead of "unlimited potential" -->
<s>With God... <break time="1.5s"/>
all things are possible... <break time="2s"/>
not through your power... <break time="1.5s"/>
but through His.
</s>
```

---

## Category 3: Occult Practices

Imagery associated with forbidden spiritual practices.

### Forbidden

| Pattern | Theological Issue |
|---------|------------------|
| "Third eye opening" | Hindu/occult concept |
| "Kundalini rising" | Non-Christian energy work |
| "Chakra activation" | Eastern spirituality |
| "Astral projection" | Soul separation |
| "Past life memories" | Reincarnation |
| "Ritual magic imagery" | Occult practice |
| "Tarot/divination symbols" | Forbidden divination |
| "Pentagram/occult geometry" | Occult symbols |

### Scripture Reference

> "Let no one be found among you who... practices divination or sorcery, interprets omens, engages in witchcraft..." — Deuteronomy 18:10

### Safe Alternative

For energy concepts, use Christian equivalents:

```xml
<!-- Instead of "kundalini" -->
<s>Perhaps you notice... <break time="1.5s"/>
the life God breathed into you... <break time="1.5s"/>
moving through your body... <break time="2s"/>
not a force to awaken... <break time="1.5s"/>
but grace already present.</s>

<!-- Instead of "chakras" -->
<s>Different parts of your body... <break time="1.5s"/>
holding different experiences... <break time="1.5s"/>
all of you... <break time="1s"/>
open to God's healing touch.</s>
```

---

## Category 4: Pantheism/Monism

Imagery that erases the distinction between God and creation.

### Forbidden

| Pattern | Theological Issue |
|---------|------------------|
| "All is one" (ontological) | Pantheism |
| "The universe loves you" | Impersonal god |
| "Merge with the divine" | Loss of self in God |
| "You are consciousness itself" | Monistic identity |
| "Dissolve into oneness" | Buddhist absorption |
| "The divine spark within" (as your essence) | Gnosticism |

### Scripture Reference

> "In the beginning God created the heavens and the earth." — Genesis 1:1 (Creator distinct from creation)

### Safe Alternative

```xml
<!-- Instead of "all is one" -->
<s>All connected in Christ... <break time="1.5s"/>
each unique... <break time="1s"/>
yet part of one body... <break time="2s"/>
distinct yet unified... <break time="1.5s"/>
in love.</s>

<!-- Instead of "merge with divine" -->
<s>Drawing closer to God... <break time="1.5s"/>
yet remaining yourself... <break time="2s"/>
intimacy without absorption... <break time="1.5s"/>
union without confusion.</s>
```

---

## Category 5: Antinomianism

Imagery that suggests sin doesn't matter or moral boundaries don't exist.

### Forbidden

| Pattern | Theological Issue |
|---------|------------------|
| "There is no sin" | Denies reality of evil |
| "Everything is permitted" | Antinomian license |
| "Beyond good and evil" | Nietzschean morality |
| "Your darkness is beautiful" (unqualified) | Romanticizes sin |
| "No judgment" (as divine truth) | Denies God's justice |

### Safe Alternative

```xml
<!-- Instead of "no sin" -->
<s>The weight of what you carry... <break time="1.5s"/>
can be released... <break time="1.5s"/>
not because it wasn't real... <break time="2s"/>
but because grace is greater.</s>

<!-- Instead of "darkness is beautiful" -->
<s>Even your shadow... <break time="1.5s"/>
is held in God's mercy... <break time="2s"/>
not celebrated... <break time="1s"/>
but transformed.
</s>
```

---

## Category 6: Works-Based Spirituality

Imagery suggesting the listener earns or achieves spiritual advancement.

### Forbidden

| Pattern | Theological Issue |
|---------|------------------|
| "Raise your vibration" | Spiritual achievement |
| "Ascend to higher planes" | Earned enlightenment |
| "Achieve enlightenment" | Works-based |
| "Master your energy" | Self-salvation |
| "Unlock your potential" | Self-actualization as salvation |

### Safe Alternative

```xml
<!-- Instead of "raise vibration" -->
<s>Open to receive... <break time="1.5s"/>
what God freely gives... <break time="2s"/>
not earning... <break time="1s"/>
but receiving.
</s>

<!-- Instead of "achieve enlightenment" -->
<s>The light of Christ... <break time="1.5s"/>
shining into darkness... <break time="2s"/>
not achieved by you... <break time="1.5s"/>
but given to you.
</s>
```

---

## Quick Rejection Test

If imagery includes any of these concepts, it needs revision:

- [ ] Non-God entities with authority
- [ ] Listener = God
- [ ] Eastern energy practices
- [ ] Creator/creation blurred
- [ ] Sin irrelevant
- [ ] Spiritual achievement by effort

---

## Exception Process

Some concepts (like "inner wisdom") can be used WITH proper framing:

```
Raw concept: "Your inner wisdom"
Problem: Could imply self-as-God
Solution: "The wisdom God has placed within you"
```

Always trace back to God as source.
