---
name: synthesis-frameworks
description: Master research synthesis including qualitative analysis, affinity diagramming, theme identification, pattern recognition, and insight extraction. Use when synthesizing research, analyzing interviews, identifying patterns, extracting insights, organizing findings, or translating research into action. Covers synthesis methods, affinity mapping, thematic analysis, and insight generation techniques.
---

# Synthesis Frameworks

Frameworks for synthesizing qualitative research data to identify patterns, extract insights, and drive product decisions.

## Overview

Research synthesis transforms raw observations into actionable insights. Good synthesis reveals hidden patterns, validates assumptions, and informs strategic product decisions through structured analysis and collaborative sense-making.

## When to Use This Skill

**Auto-loaded by agents**:
- `research-ops` - For thematic analysis, insight generation, and research reports

**Use when you need**:
- Analyzing interview transcripts
- Synthesizing usability test findings
- Identifying user needs and pain points
- Creating research deliverables
- Documenting and communicating insights
- Running team synthesis workshops
- Pattern recognition across research data
- Translating research into actionable recommendations

## Core Synthesis Methods

### The Synthesis Process

Research synthesis follows a structured five-step process from raw data to actionable insights:

**The five steps:**
1. Immersion: Consume all raw data without judgment
2. Extraction: Identify individual observations atomically
3. Grouping: Find patterns through affinity mapping
4. Insight Generation: Ask "so what?" and connect to implications
5. Communication: Share findings in actionable formats

**Detailed template:** See `assets/synthesis-process-template.md` for step-by-step instructions, time allocation, and specific techniques for each phase.

**Time allocation:** Expect 8-16 hours total for a typical research project, with most time in grouping (30-40%) and insight generation phases.

### Affinity Mapping

Collaborative technique for organizing observations into themes through physical or digital clustering.

**When to use:**
- Team synthesis workshops
- Large amounts of qualitative data
- Need for shared understanding
- Pattern discovery (not testing hypothesis)

**Basic process:**
1. Silent note writing: Individual observation capture
2. Wall posting: Share all observations
3. Silent grouping: Cluster related notes
4. Name clusters: Identify themes
5. Generate insights: Discuss implications

**Complete guide:** See `assets/affinity-mapping-guide.md` for:
- Setup instructions (physical and digital)
- Step-by-step process with timings
- Color-coding strategies
- Tips for effective clustering
- Remote and solo variations

### Pattern Identification

Systematic approach to recognizing recurring themes across qualitative data.

**Five types of patterns to look for:**

1. **Frequency patterns:** How often something occurred (e.g., "8/10 users mentioned pricing")
2. **Behavioral patterns:** What users actually did vs. said (e.g., "All users skipped tutorial")
3. **Sentiment patterns:** Emotional responses (e.g., frustration, delight, confusion)
4. **Segment patterns:** Differences by user type (e.g., new users vs. power users)
5. **Journey patterns:** When issues occur (e.g., "70% dropped off at onboarding step 3")

**Deep dive:** See `references/pattern-identification-guide.md` for:
- Detailed examples of each pattern type
- How to interpret patterns
- Pattern validation techniques
- Common pitfalls to avoid
- Advanced pattern recognition methods

### Thematic Analysis

Formal method for coding qualitative data and identifying themes.

**Three coding levels:**
- **Level 1 - Descriptive codes:** What was said/done (e.g., "Mentioned pricing")
- **Level 2 - Interpretive codes:** What it means (e.g., "Price sensitivity")
- **Level 3 - Pattern codes:** Big picture themes (e.g., "Value perception issue")

**Four-phase process:**
1. Open coding: Generate initial codes liberally (30-100+)
2. Axial coding: Group related codes into categories (10-30)
3. Selective coding: Refine into core themes (5-10)
4. Validation: Ensure themes are supported and distinct

**Complete methodology:** See `references/thematic-analysis-guide.md` for:
- Detailed coding process with examples
- Tools and techniques (manual and digital)
- Quality checks and validation
- Common coding patterns
- Worked examples from transcripts

### Jobs-to-be-Done (JTBD) Synthesis

Framework for understanding customer motivations and the "jobs" users hire products to do.

**Job statement format:**
```
When [situation],
I want to [motivation],
So I can [expected outcome]
```

**The Forces Framework:**
Analyze four forces that drive or prevent adoption:
- **Push:** Why change from current solution? (pain, frustration)
- **Pull:** Why choose new solution? (benefits, aspirations)
- **Anxieties:** What holds users back? (fear, risk, learning curve)
- **Habits:** Why stay put? (familiarity, switching costs)

**Switching equation:** Push + Pull > Anxieties + Habits = Switch

**Full framework:** See `references/jtbd-synthesis-guide.md` for:
- How to identify jobs in research data
- Finding jobs through struggle and workarounds
- Complete forces analysis with examples
- Strategy recommendations for each force
- JTBD vs traditional research approaches

## Insight Quality

Not all findings are insights. Good insights are specific, surprising, actionable, evidence-based, and prioritized.

### The Five Characteristics

**1. Specific (not vague):**
- Bad: "Users don't like the UI"
- Good: "6/8 users couldn't find Settings in hamburger menu - move to top nav"

**2. Surprising (not obvious):**
- Bad: "Users want fast loading"
- Good: "Users prefer slow load with progress over fast load with no feedback"

**3. Actionable (clear implications):**
- Bad: "Users are frustrated"
- Good: "8-field signup causes 60% abandonment - reduce to 3 fields to match competitors"

**4. Evidence-based (not speculation):**
- Bad: "I think users would like dark mode"
- Good: "5/10 users requested dark mode unprompted, citing eye strain from all-day use"

**5. Prioritized (impact + feasibility):**
- Bad: List of 50 equal findings
- Good: Top 5 insights ranked by impact/effort with quick wins called out

### Insight Formula

**Template:** "[X%/number] of users [did/said specific thing] because [reason], suggesting we should [action] to [expected outcome]"

**Example:** "8/10 users abandoned onboarding at 'Invite Team' step because they didn't have emails ready, suggesting we should make this optional to reduce abandonment from 60% to 30%"

**Quality guide:** See `references/insight-quality-guide.md` for:
- Detailed breakdown of each characteristic
- Bad vs. good insight examples
- How to strengthen weak insights
- Insight quality checklist
- Teaching teams to recognize quality

## Synthesis Deliverables

### Executive Summary

One-page research summary for the team who need highlights without detail.

**Standard sections:**
- Research goals and methodology (brief)
- Top 3-5 key findings with evidence
- Prioritized recommendations (quick wins vs. strategic)
- Next steps and owners

**Template:** See `assets/executive-summary-template.md`

### Full Research Report

Comprehensive documentation (5-10 pages) for complete findings and recommendations.

**Structure:**
1. Executive summary
2. Background and research questions
3. Methodology and participants
4. Findings by theme (with quotes and data)
5. Recommendations (prioritized)
6. Appendix (full participant list, materials, extra quotes)

**Template:** See `assets/research-report-template.md`

### Insight Cards

One-page format for individual insights that can be shared independently.

**Includes:**
- Insight statement and evidence (quotes + data)
- Impact and why it matters
- Specific recommendation with expected outcome
- Priority, effort, and owner
- Visual (screenshot, diagram, or clip)

**Template:** See `assets/insight-card-template.md`

### Data-Driven Personas

User archetypes based on behavioral patterns discovered in research.

**Creation process:**
1. Identify behavioral patterns in research
2. Cluster users with similar behaviors
3. Define 3-5 distinct archetypes
4. Validate against real users

**Persona template includes:**
- Goals and motivations
- Behaviors and workflows
- Pain points and needs
- Representative quote
- When to use: Prioritization, design decisions, communication

**Template:** See `assets/persona-template.md`

## Collaborative Synthesis

### Team Synthesis Workshop

2-hour structured workshop for collaborative insight generation with shared understanding.

**Workshop structure:**
- 0:00-0:15: Context setting (research goals, questions, methodology)
- 0:15-0:45: Affinity mapping (silent note writing + clustering)
- 0:45-1:15: Grouping and naming themes
- 1:15-1:45: Insight generation and prioritization
- 1:45-2:00: Action planning with owners

**Benefits:**
- Shared understanding across team
- Multiple perspectives improve pattern recognition
- Buy-in through participation
- Faster insight to action

**Complete guide:** See `references/synthesis-workshop-guide.md` for:
- Pre-workshop preparation checklist
- Detailed agenda with timings
- Facilitation tips and techniques
- Workshop variations (remote, async, executive)
- Post-workshop documentation

## Impact vs. Effort Prioritization

Use 2x2 matrix to prioritize insights:

```
        Low Effort    High Effort
High    Quick Wins    Major Projects
Impact  (Do First)    (Do Next)

Low     Fill-ins      Money Pits
Impact  (Do Later)    (Avoid)
```

**Scoring insights:**
- **Impact (1-5):** Frequency × Severity × Business impact
- **Effort (1-5):** Technical complexity + Time + Dependencies
- **Priority score:** Impact / Effort

**Quick wins** (high impact, low effort) should be shipped within 1-2 sprints to build momentum and demonstrate research value.

## Synthesis Best Practices

**DO:**
- Involve team in synthesis (shared understanding, multiple perspectives)
- Use participant quotes liberally (evidence, authenticity)
  - **Evidence Standards:** Use only actual quotes from transcripts - never invent or fabricate
  - When paraphrasing: mark as "[Paraphrased from participant]" not as direct quote
  - Each quote must be verbatim from transcript and attributed to specific participant
- Quantify when possible ("8/10 users", "60% abandoned")
- Look for surprising patterns (not just confirmation bias)
- Prioritize insights ruthlessly (top 3-5 most important)
- Connect to business goals explicitly (why it matters)
- Make recommendations actionable (clear next steps)
- Document process (photos of affinity map, save artifacts)

**DON'T:**
- Cherry-pick data to support existing beliefs
- Present all findings equally (overwhelming, no guidance)
- Use research jargon (be clear and accessible)
- Bury insights in long reports (lead with key findings)
- Synthesize alone when team synthesis is possible
- Ignore contradictions (explore them, they're interesting)
- Stop at observations (push through to insights and implications)
- Skip validation (check themes across multiple participants)

## Common Synthesis Pitfalls

**Confirmation bias:** Only seeing patterns that confirm beliefs
- Solution: Actively look for disconfirming evidence

**Overgeneralization:** "One user did X, therefore all users..."
- Solution: Require multiple examples to claim pattern

**Too many themes:** More than 10 themes = probably too granular
- Solution: Look for meta-themes, consolidate

**Generic insights:** "Users want better UX" (too vague)
- Solution: Apply the five characteristics of quality insights

**No prioritization:** Treating all findings equally
- Solution: Use impact/effort matrix, call out quick wins

**Insight fatigue:** So many insights team doesn't act
- Solution: Limit to top 3-5, focus on actionable quick wins

## Related Skills

- `interview-frameworks` - Conducting interviews that produce quality data
- `usability-frameworks` - Usability testing methods and analysis
- `validation-frameworks` - Solution validation and experiment design
- `user-research-techniques` - Methods for gathering research data
