# Affinity Mapping Guide

Step-by-step process for building an affinity diagram to synthesize research data.

## Setup

### Physical Setup

**Materials:**
- Sticky notes (different colors)
- Sharpies (thick markers, readable from distance)
- Large wall or whiteboard

**Team:**
- Research lead
- Product team members
- Designers, engineers (optional but valuable)

**Space:** Quiet room with wall space

**Time:** 2-4 hours

### Digital Setup (Alternative)

**Tools:**
- Miro, Mural, FigJam, or similar
- Sticky note templates
- Collaborative board

## 5-Step Process

### 1. Silent Note Writing (30 min)

- Everyone reviews data independently
- Write observations on sticky notes
- One observation per note
- No discussion yet

**Purpose:** Individual processing before group influence

### 2. Wall Posting (15 min)

- Put all notes on wall (random placement)
- Read aloud as posting (share with team)
- Still no discussion

**Purpose:** Share observations, build shared context

### 3. Silent Grouping (45 min)

- Move related notes together
- Create clusters
- Don't talk (forced focus)
- Duplicate notes if fits multiple clusters

**Purpose:** Pattern recognition without bias

### 4. Name Clusters (30 min)

- Discussion starts now
- Name each cluster (theme)
- Debate and refine groupings

**Purpose:** Align on meaning, refine categories

### 5. Identify Insights (60 min)

- For each cluster, discuss implications
- Write insights on different color notes
- Prioritize insights

**Purpose:** Move from observations to actions

## Tips & Best Practices

### Color Coding

Use different colored notes for different types of information:
- Yellow: Observations
- Pink: Needs/pain points
- Blue: Quotes
- Green: Insights

### Writing Guidelines

- Write big and bold (readable from 6 feet away)
- Use clear, concise language
- One idea per note
- Include participant ID if relevant

### Grouping Strategy

**Start broad, then refine:**
- First pass: ~5-10 high-level themes
- Second pass: Sub-themes within each

**Allow "orphan" notes:** Don't force fit everything. Some observations may not cluster - that's okay.

### Documentation

- Take photos throughout the process
- Document cluster names and key insights
- Capture board before dismantling
- Create digital artifact (slide deck or document)

## Common Pitfalls

**Forcing patterns:** Let patterns emerge naturally. Don't start with predetermined themes.

**Talking too early:** Silent phases are crucial for unbiased thinking.

**Overthinking clusters:** Move notes around freely. There's no "perfect" arrangement.

**Skipping naming:** Clear cluster names are essential for shared understanding.

**No follow-through:** The real work starts after affinity mapping - turn insights into action.

## Variations

### Speed Affinity (1 hour)

Condensed for time-constrained teams:
- 15 min: Write notes
- 10 min: Post to wall
- 20 min: Group together (not silent)
- 15 min: Name and discuss

### Remote Affinity

Adapting for distributed teams:
- Use digital whiteboard (Miro/Mural/FigJam)
- Screen share with cursor tracking
- Video on for non-verbal communication
- Longer timeboxes (remote = slower)
- More explicit turn-taking

### Solo Affinity

Individual synthesis when team synthesis isn't possible:
- Follow same steps
- Talk yourself through decisions
- Document reasoning
- Share results with team async
- Get feedback before finalizing
