# Executive Summary Template

One-page research summary for the team who need the highlights without details.

---

**Project:** [Research project name]
**Date:** [Completion date]
**Researcher:** [Name/team]

## Research Goals

- [Goal 1: What we wanted to learn]
- [Goal 2: What we wanted to validate]
- [Goal 3: What we wanted to explore]

## Methodology

**Participants:** [Number and description, e.g., "10 product managers at Series B-C startups"]
**Format:** [e.g., "30-minute remote interviews via Zoom"]
**Dates:** [When research was conducted]
**Approach:** [Brief description of method, e.g., "Semi-structured interviews with usability testing"]

## Key Findings

### 1. [Insight]: [One-sentence finding]
**Evidence:** [Brief supporting data]
**Recommendation:** [What we should do]

### 2. [Insight]: [One-sentence finding]
**Evidence:** [Brief supporting data]
**Recommendation:** [What we should do]

### 3. [Insight]: [One-sentence finding]
**Evidence:** [Brief supporting data]
**Recommendation:** [What we should do]

### 4. [Insight]: [One-sentence finding]
**Evidence:** [Brief supporting data]
**Recommendation:** [What we should do]

### 5. [Insight]: [One-sentence finding]
**Evidence:** [Brief supporting data]
**Recommendation:** [What we should do]

## Recommendations

**Quick Wins (Do First):**
1. [Action item with expected impact]
2. [Action item with expected impact]

**Strategic Improvements (Do Next):**
1. [Larger initiative with expected impact]
2. [Larger initiative with expected impact]

**Future Considerations:**
- [Item to revisit later]
- [Item to explore in future research]

## Next Steps

**Immediate actions:**
- [What happens now]
- [Who owns what]
- [Timeline]

**Follow-up research:**
- [What we still need to learn]
- [Suggested next research phase]

---

## Example: Executive Summary

**Project:** Onboarding Usability Study
**Date:** October 29, 2025
**Researcher:** Product Research team

### Research Goals
- Understand where users struggle in onboarding flow
- Identify friction points causing abandonment
- Validate new onboarding design concepts

### Methodology
**Participants:** 10 new users (mix of solo founders and small teams)
**Format:** 45-minute remote usability tests via Zoom
**Dates:** October 15-22, 2025
**Approach:** Think-aloud protocol testing current onboarding + concept validation

### Key Findings

**1. "Invite Team" step causes 60% abandonment**
Evidence: 8/10 users attempted to skip, average 45 seconds stuck on step
Recommendation: Make step optional with "Skip for now" + email reminder on Day 3

**2. Users don't understand value prop until step 4**
Evidence: 7/10 asked "What does this tool actually do?" during setup
Recommendation: Show example workspace/demo content earlier in flow

**3. Password requirements frustrate without clear indication**
Evidence: All 10 users failed first password attempt, 3 nearly abandoned
Recommendation: Add real-time validation with helpful error messages

**4. Users expect single sign-on options**
Evidence: 6/10 looked for Google/GitHub login, 4 explicitly asked for it
Recommendation: Add OAuth options (prioritize Google + GitHub)

**5. Mobile experience is non-functional**
Evidence: 2/10 tried on mobile first, both abandoned and switched to desktop
Recommendation: Either build mobile-responsive onboarding or block mobile with "Desktop required" message

### Recommendations

**Quick Wins (Do First):**
1. Make "Invite Team" optional (Low effort, High impact: potentially 2x activation)
2. Add real-time password validation (Low effort, Medium impact: reduce frustration)

**Strategic Improvements (Do Next):**
1. Add OAuth sign-in options (Medium effort, High impact: reduce friction + improve perception)
2. Show value earlier with example content (Medium effort, High impact: improve understanding)

**Future Considerations:**
- Mobile onboarding experience (Large effort, requires mobile strategy decision first)
- Personalized onboarding based on user role

### Next Steps

**Immediate actions:**
- Engineering: Implement "Skip for now" button (Owner: Sarah, Timeline: This sprint)
- Product: Design OAuth flow (Owner: Marcus, Timeline: Next sprint)
- Research: Test new onboarding flow once changes shipped (Timeline: 3 weeks)

**Follow-up research:**
- Longitudinal study: Track activation rates post-changes
- Concept testing: Validate OAuth flow design before build
