# Insight Card Template

One-page format for documenting and sharing individual insights from research.

---

## [Insight Title: Catchy statement that captures the finding]

### Insight Summary
[One-sentence summary of the key finding]

### Evidence

**Quotes:**
- "Quote 1 from research..." - [Participant role/ID]
- "Quote 2 from research..." - [Participant role/ID]
- "Quote 3 from research..." - [Participant role/ID]

**Data:**
- [Quantified finding, e.g., "8/10 users"]
- [Behavioral observation, e.g., "100% clicked X before Y"]
- [Frequency data, e.g., "Mentioned 12 times across 8 interviews"]

**Context:**
[When/where this occurred, what users were trying to do]

### Impact

**Why this matters:**
[Business impact, user impact, strategic importance]

**What's at stake:**
- Risk if not addressed: [What happens if we ignore this]
- Opportunity if addressed: [What we gain by acting on this]

### Recommendation

**Suggested action:**
[Specific, actionable recommendation]

**Expected outcome:**
[What we expect to achieve]

**Success metrics:**
[How we'll know it worked]

### Prioritization

**Priority:** High / Medium / Low

**Effort:** Low / Medium / High

**Urgency:** Now / Next / Later

**Owner:** [Team/person responsible]

**Dependencies:** [What else needs to happen first]

### Visual

[Screenshot, diagram, video clip, or photo that illustrates the insight]

---

## Example: Insight Card

### Insight Summary
Users abandon onboarding at the "Invite Team" step because they don't have teammate emails readily available

### Evidence

**Quotes:**
- "I don't have their emails memorized. Can I skip this and come back later?" - PM at Series B
- "I'm setting this up myself first. I'll add the team once I understand it." - Solo founder
- "This feels premature. I don't even know if I like the tool yet." - Engineering lead

**Data:**
- 8/10 users attempted to skip this step
- 60% abandonment rate at this point in onboarding
- Average time spent on step: 45 seconds (vs 10 sec on other steps)

**Context:**
Occurs at step 3 of 5 in onboarding flow, after account creation and workspace setup

### Impact

**Why this matters:**
This is our highest drop-off point in onboarding. Losing 60% of new signups before they reach core product.

**What's at stake:**
- Risk: Continue losing majority of new users before activation
- Opportunity: Improving this step could double activation rate (60% → 30% drop-off = 2x activations)

### Recommendation

**Suggested action:**
Make "Invite Team" step optional with clear "Skip for now" button. Add reminder on Day 3 via email.

**Expected outcome:**
- Reduce onboarding abandonment from 60% to <30%
- Increase users reaching core product experience
- Maintain team invitation rate through email reminder

**Success metrics:**
- Onboarding completion rate (target: 70%+)
- Time to first core action (target: <5 minutes)
- Team invitations within 7 days (maintain current rate)

### Prioritization

**Priority:** High
**Effort:** Low (frontend change + email trigger)
**Urgency:** Now (quick win, high impact)
**Owner:** Product team + Engineering
**Dependencies:** None - standalone change

### Visual
[Screenshot of current onboarding step with 60% drop-off annotation]
