# Persona Template

Data-driven persona format for creating user archetypes based on research synthesis.

---

## Creating Personas from Research

### Process

**1. Identify Behavioral Patterns**
- How do users differ in behaviors?
- What are their distinct goals and motivations?
- What workflows do they follow?

**2. Cluster Users**
- Group users with similar patterns
- 3-5 distinct clusters is typical
- Look for meaningful differences (not superficial demographics)

**3. Define Persona Archetypes**
- Name each cluster (memorable, alliterative names help)
- Create representative profile for each
- Base on real data, not assumptions

**4. Validate**
- Do real users fit into these archetypes?
- Are the differences meaningful for product decisions?
- Can the team use these for decision-making?

---

## Persona Template

### [Persona Name: Alliterative and memorable]

**Tagline:** [One-sentence description capturing essence]

#### Demographics (only if relevant to product decisions)
- Role: [Job title]
- Company size: [e.g., "Series B startup, 50-100 employees"]
- Industry: [If relevant]
- Experience level: [Junior/Mid/Senior]

#### Goals
*What are they trying to achieve?*
- [Primary goal]
- [Secondary goal]
- [Aspirational goal]

#### Behaviors
*How do they use the product?*
- **Frequency:** [Daily, weekly, monthly]
- **Features used:** [Which features, in what order]
- **Workflow:** [Typical use pattern]
- **Context:** [Where, when, why they use it]

#### Pain Points
*What frustrates them?*
- [Pain point 1: Current struggle]
- [Pain point 2: Unmet need]
- [Pain point 3: Friction point]

#### Needs
*What would help them succeed?*
- [Need 1: Capability they're missing]
- [Need 2: Improvement they want]
- [Need 3: Support they require]

#### Motivations
*Why do they use the product?*
- [Motivation 1: What drives them]
- [Motivation 2: What success looks like]

#### Technology Profile
- Technical skill level: [Low/Medium/High]
- Tools they use: [Complementary products]
- Platform preference: [Desktop, mobile, etc.]

#### Quote
> "A memorable quote that captures their essence and attitude toward your product/problem space"

#### Photo
[Stock photo for humanization - choose representative but avoid stereotypes]

---

## Example Persona: Power-User Paula

**Tagline:** Experienced PM who lives in the product and needs speed + flexibility

### Demographics
- Role: Senior Product Manager
- Company: Series B startup, 80 employees
- Industry: B2B SaaS
- Experience: 7 years in product management

### Goals
- Ship features quickly without sacrificing quality
- Keep distributed team aligned on roadmap
- Make data-driven decisions with minimal manual work

### Behaviors
- **Frequency:** Uses product 5-10 times daily
- **Features used:** Advanced features, keyboard shortcuts, integrations, API
- **Workflow:** Checks dashboard first thing morning, updates throughout day, reviews metrics end of week
- **Context:** Always at desktop, multiple monitors, context-switching between tools

### Pain Points
- Reporting takes too long - manually compiles data from 3 sources for weekly update
- Missing integrations with key tools (Jira, Amplitude)
- No admin controls for managing team permissions
- Mobile app is too limited for quick updates on the go

### Needs
- Automation for routine tasks (reporting, status updates)
- API access for custom integrations
- Advanced permissions and team management
- Keyboard shortcuts for everything

### Motivations
- Wants to be seen as efficient and data-driven
- Values speed and flexibility over hand-holding
- Proud of mastering complex tools
- Success = shipping features that move metrics

### Technology Profile
- Technical skill: High (comfortable with APIs, SQL, JSON)
- Tools: Jira, Amplitude, Figma, Slack, Linear, Notion
- Platform: Desktop primary (Mac), occasionally mobile for quick checks

### Quote
> "I live in this tool 8 hours a day. I need it to be fast, flexible, and get out of my way. I don't need tutorials - I need power features."

### Photo
[Professional woman, 30s, at desk with multiple monitors, focused expression]

---

## Example Persona: Onboarding Olivia

**Tagline:** New PM transitioning from engineering, learning product fundamentals

### Demographics
- Role: Product Manager (first PM role)
- Company: Series A startup, 25 employees
- Industry: Consumer tech
- Experience: 6 months as PM, 3 years prior as engineer

### Goals
- Learn product management best practices
- Build credibility with team coming from engineering
- Ship first major feature successfully

### Behaviors
- **Frequency:** Uses product 2-3 times per week
- **Features used:** Basic features only, follows templates, sticks to recommended workflows
- **Workflow:** Checks before 1:1s and team meetings, updates after decisions made
- **Context:** Laptop (work from anywhere), often in coffee shops or co-working

### Pain Points
- Overwhelmed by options - doesn't know "the right way" to do things
- Imposter syndrome - worries she's not doing PM work correctly
- Hard to find features - gets lost in navigation
- Jargon and terminology confusing (coming from engineering background)

### Needs
- Guided workflows and templates
- Educational content and best practices
- Simple, clear navigation
- Examples and inspiration from other PMs

### Motivations
- Wants to prove she can succeed in PM role
- Values learning and professional development
- Success = shipping features and getting positive team feedback
- Aspires to be strategic, data-driven PM like mentors she admires

### Technology Profile
- Technical skill: Medium-High (technical background but new to PM tools)
- Tools: Jira, Slack, Figma, Google Docs (learning PM-specific tools)
- Platform: Laptop primary (MacBook), occasional mobile for reading

### Quote
> "I'm still learning product management. I need guidance and examples so I don't mess this up. Show me the best way to do things."

### Photo
[Professional woman, late 20s, laptop at co-working space, thoughtful expression]

---

## Persona Anti-Patterns to Avoid

**Demographics without behavior:**
Don't create personas based only on age/gender/location. Focus on behaviors and goals.

**Too many personas:**
More than 5 personas becomes unmanageable. Focus on the most distinct and important segments.

**Marketing personas:**
Product personas differ from marketing personas. Focus on product usage, not buyer journey.

**Fake personas:**
Base on real research data, not assumptions or "we think users are like..."

**Decorative personas:**
If the team doesn't use personas to make decisions, they're just decoration. Make them actionable.

## Using Personas Effectively

**In product decisions:**
"Would Power-User Paula care about this feature? What about Onboarding Olivia?"

**In design reviews:**
"Is this navigation clear for Onboarding Olivia, or only obvious to Power-User Paula?"

**In prioritization:**
"This feature solves a problem for Paula but not Olivia. What's our priority?"

**In roadmap planning:**
"Q1 focused on Paula's needs. Q2 let's address Olivia's onboarding issues."
