# Research Report Template

Comprehensive research report format for full documentation of findings, methodology, and recommendations.

---

## 1. Executive Summary (1 page)

**Project:** [Name]
**Date:** [Date]
**Researcher:** [Name/team]

**Research Goals:**
- [Goal 1]
- [Goal 2]
- [Goal 3]

**Methodology:**
[Brief description: participants, format, dates]

**Key Findings:**
1. [Insight]: [Evidence] → [Recommendation]
2. [Insight]: [Evidence] → [Recommendation]
3. [Insight]: [Evidence] → [Recommendation]

**Top Recommendations:**
- [Priority action 1]
- [Priority action 2]
- [Priority action 3]

---

## 2. Background (1 page)

### Research Context
[Why we conducted this research, what prompted it]

### Research Questions
1. [Question we wanted to answer]
2. [Question we wanted to answer]
3. [Question we wanted to answer]

### Why This Matters
[Business context, strategic importance, impact on product/users]

### Hypotheses (if applicable)
- Hypothesis 1: [What we believed before research]
- Hypothesis 2: [What we believed before research]

---

## 3. Methodology (1-2 pages)

### Participants

**Recruitment:**
- [How we found participants]
- [Screening criteria used]
- [Incentive offered, if any]

**Sample:**
- Total participants: [Number]
- Demographics: [Relevant details]
- Segmentation: [How we grouped participants]

**Participant breakdown:**
| ID | Role | Company Size | Experience Level |
|----|------|--------------|------------------|
| P1 | [Role] | [Size] | [Level] |
| P2 | [Role] | [Size] | [Level] |
| ... | ... | ... | ... |

### Research Format

**Method:** [e.g., "Semi-structured interviews with usability testing"]

**Session structure:**
- Introduction (5 min)
- [Activity 1] (15 min)
- [Activity 2] (20 min)
- Wrap-up (5 min)

**Materials used:**
- [Interview guide / test script]
- [Prototype / product version]
- [Other materials]

**Data collection:**
- Recorded: [Yes/No, what was recorded]
- Notes: [Note-taking approach]
- Artifacts: [Screenshots, sketches, etc.]

### Analysis Approach

**Synthesis method:**
[e.g., "Affinity mapping with thematic analysis"]

**Team involvement:**
- [Who participated in synthesis]
- [How findings were validated]

### Limitations

**What we didn't test:**
- [Scope exclusions]
- [Limitations of method]

**Caveats:**
- [Sample bias concerns]
- [Environmental factors]
- [Other limitations]

---

## 4. Findings (5-10 pages)

### Theme 1: [Name of theme]

**Insight:**
[One-sentence key finding]

**Evidence:**

*Frequency:* [How often this occurred]

*Behavioral observations:*
- [What we saw users do]
- [Patterns in behavior]

*Quotes:*
> "Quote 1" - Participant role
> "Quote 2" - Participant role
> "Quote 3" - Participant role

*Supporting data:*
- [Quantified findings]
- [Task completion rates, time on task, etc.]

**Implications:**
[What this means for the product, why it matters]

---

### Theme 2: [Name of theme]

**Insight:**
[One-sentence key finding]

**Evidence:**
[Repeat same structure as Theme 1]

**Implications:**
[What this means for the product]

---

### Theme 3: [Name of theme]

[Continue pattern for 3-7 themes]

---

## 5. Recommendations (1-2 pages)

### Quick Wins (Do First)

#### 1. [Recommendation title]
**Problem:** [What issue this addresses]
**Solution:** [Specific action to take]
**Expected impact:** [What we expect to achieve]
**Effort:** Low
**Timeline:** [Suggested timeframe]
**Owner:** [Team/person]

#### 2. [Recommendation title]
[Same structure]

### Strategic Improvements (Do Next)

#### 1. [Recommendation title]
**Problem:** [What issue this addresses]
**Solution:** [Specific action to take]
**Expected impact:** [What we expect to achieve]
**Effort:** Medium-High
**Timeline:** [Suggested timeframe]
**Owner:** [Team/person]

#### 2. [Recommendation title]
[Same structure]

### Long-Term Opportunities

- [Larger initiative or future consideration]
- [Item requiring more research or strategy]

### Recommendations Not to Pursue

**[Idea that came up but we recommend against]:**
[Why we don't recommend this despite it coming up in research]

---

## 6. Appendix

### Full Participant List

| ID | Role | Company | Recruited via | Session date |
|----|------|---------|--------------|--------------|
| P1 | [Role] | [Company] | [Source] | [Date] |
| ... | ... | ... | ... | ... |

### Interview Guide / Test Script

[Include full research protocol]

### Detailed Session Notes (Optional)

**Participant 1:**
[Expanded notes from session]

**Participant 2:**
[Expanded notes from session]

### Additional Quotes

[Supplementary quotes that support findings but didn't fit in main body]

### Visual Artifacts

[Screenshots, photos, diagrams from research sessions]

---

## Report Metadata

**Distribution:**
- [Who should receive this report]
- [Internal link/storage location]

**Contact:**
- Researcher: [Name, email]
- Project sponsor: [Name]

**Version history:**
- v1.0: [Date] - Initial report
- v1.1: [Date] - [What changed]
