# Five-Step Synthesis Process Template

Use this process to transform raw research data into actionable insights.

## Step 1: Immersion (Consume Raw Data)

**Activities:**
- Review all notes, transcripts, recordings
- Watch video clips
- Read verbatim quotes
- Immerse in data without judgment

**Goal:** Familiarize yourself with all data

**Time:** 20-30% of synthesis time

**Mindset:** Open, curious, non-judgmental. Don't start with hypothesis - let data speak

## Step 2: Extraction (Identify Observations)

**Activities:**
- Pull out individual observations
- One idea per note (atomic notes)
- Include verbatim quotes
- Capture behavioral observations

**Format:** Post-it notes (physical or digital)

**Example observations:**
- "Struggled to find 'Settings' menu" (behavior)
- "Wanted to invite team but couldn't find button" (need)
- "Said: 'This is confusing'" (sentiment)
- "Used spreadsheet workaround" (current solution)

**Goal:** Break down data into manageable pieces

**Time:** 20-30% of synthesis time

## Step 3: Grouping (Find Patterns)

**Activities:**
- Group similar observations
- Look for themes
- Create clusters
- Name each cluster

**Method:** Affinity mapping

**Example clusters:**
- "Onboarding confusion" (8 observations)
- "Team collaboration pain" (12 observations)
- "Pricing concerns" (5 observations)

**Goal:** Identify recurring themes

**Time:** 30-40% of synthesis time

**Key:** Let patterns emerge (don't force predetermined themes)

## Step 4: Insight Generation (So What?)

**Activities:**
- For each cluster, ask "So what?"
- What does this mean for the product?
- What should we do about it?
- Prioritize insights

**Formula:** Observation + Pattern + Implication = Insight

**Example:**

Bad (not an insight): "Users mentioned onboarding"

Good: "8/10 users abandoned onboarding at 'Invite Team' step because they didn't have teammate emails ready, suggesting we should allow skipping this step"

**Goal:** Actionable insights

**Time:** 15-20% of synthesis time

## Step 5: Communication (Share Findings)

**Activities:**
- Create deliverables (report, presentation)
- Tailor to audience
- Include evidence (quotes, clips)
- Provide recommendations

**Formats:**
- Executive summary (1 page)
- Full report (5-10 pages)
- Presentation (15-20 slides)
- Video highlight reel (2-3 min)

**Goal:** Drive decisions and action

**Time:** 10-20% of synthesis time

---

## Time Allocation Summary

- Immersion: 20-30%
- Extraction: 20-30%
- Grouping: 30-40%
- Insights: 15-20%
- Communication: 10-20%

Total estimated time: 8-16 hours for typical research project
