# Synthesis Workshop Guide

Complete guide to running collaborative team synthesis workshops that transform research into actionable insights.

## Why Collaborative Synthesis?

**Benefits of team synthesis:**
- Shared understanding across team
- Multiple perspectives catch more patterns
- Buy-in through participation
- Faster insight → action
- Better context for future decisions

**When to use:**
- After major research initiatives
- When insights need team buy-in
- When diverse perspectives add value
- When you want team ownership of findings

## Pre-Workshop Preparation

### 1. Prepare Materials (2-3 days before)

**Synthesize basics:**
- Review all raw data yourself first
- Pull out key quotes and observations
- Identify preliminary patterns (don't share yet)
- Create synthesis artifacts (notes, highlights)

**Prepare for sharing:**
- 10-15 minute research summary document
- 3-5 video clips showing key moments (2-3 min each)
- Highlight reel of best quotes
- Link to full notes/transcripts (optional)

**Physical setup (if in-person):**
- Book room with wall space
- Order sticky notes (multiple colors)
- Get thick markers (readable from distance)
- Set up camera to document wall

**Digital setup (if remote):**
- Create Miro/Mural/FigJam board
- Set up sticky note templates
- Test everyone can access/edit
- Prepare breakout rooms if needed

### 2. Invite Right Participants

**Core team (required):**
- Product Manager
- Designer
- Engineering lead
- User researcher

**Extended team (if relevant):**
- Marketing
- Customer success
- Sales
- Executives (if decisions need their approval)

**Size:** 4-8 people ideal (too many = inefficient, too few = lack perspectives)

### 3. Send Pre-Work (30 min, 1 day before)

**Email attendees:**
- Research goals and questions
- Brief summary (1-page)
- 3-5 video clips or quote highlights
- Request: "Review before workshop"

**Why:** Primed participants contribute better insights

## 2-Hour Workshop Agenda

### Part 1: Context Setting (0:00-0:15, 15 min)

**Lead researcher presents:**

**Research context (5 min):**
- Why we did this research
- What we wanted to learn
- Who we talked to (participant overview)

**Research questions (3 min):**
- 3-5 key questions we explored
- What we hoped to validate or discover

**Methodology (2 min):**
- How we conducted research (interviews, tests, etc.)
- Number of participants
- Format and structure

**What to expect today (2 min):**
- Workshop process overview
- How we'll synthesize together
- Expected outcomes

**Workshop norms (3 min):**
- Silent phases are silent (no talking)
- All ideas are valid (no "that's wrong")
- Focus on patterns, not pet ideas
- Disagree with curiosity ("tell me more about that")

### Part 2: Affinity Mapping (0:15-0:45, 30 min)

**Step 2a: Silent Note Writing (15 min)**

Instructions:
> "Review the research materials. On sticky notes, write individual observations - one per note. Include quotes, behaviors, pain points, needs, anything interesting. Work silently."

**Tips:**
- One idea per note
- Be specific (not "navigation problems", but "User clicked wrong button 3 times")
- Include participant ID if relevant
- Yellow notes for observations

**Facilitator role:**
- Set timer, keep time
- Gently enforce silence
- Circulate and help if stuck
- Aim for 20-40 notes per person

**Step 2b: Wall Posting & Sharing (15 min)**

Instructions:
> "Post your notes on the wall. As you post, read each note aloud so everyone hears."

**Physical:** Stick notes on wall randomly
**Digital:** Add sticky notes to board, unmute to read

**Tips:**
- Random placement (not organized yet)
- Read clearly and briefly
- No discussion or debate yet
- Duplicate notes = signal (keep both)

**Facilitator role:**
- Keep energy up
- Keep moving (don't get stuck discussing)
- Note patterns you're seeing (don't share yet)

### Part 3: Grouping & Themes (0:45-1:15, 30 min)

**Step 3a: Silent Clustering (15 min)**

Instructions:
> "Move related notes together. Create clusters. Don't talk. Move notes freely. If a note fits in multiple clusters, duplicate it."

**Physical:** Move sticky notes on wall
**Digital:** Move sticky notes on board, use color/grouping

**Tips:**
- Start broad (large clusters)
- Let patterns emerge (don't force predetermined themes)
- It's okay to have orphan notes
- It's okay to move notes others placed

**Facilitator role:**
- Enforce silence strictly
- Watch for patterns
- Take photos periodically
- Prepare to capture cluster names

**Step 3b: Naming Clusters (15 min)**

Instructions:
> "Now you can talk. For each cluster, discuss: What's the theme? Name it."

**Process:**
- Pick largest cluster first
- Read through notes in cluster
- Discuss: What connects these?
- Agree on descriptive name (write on different color note)
- Move to next cluster

**Tips:**
- Names should be descriptive (not generic "problems")
- Capture the essence, not just list
- Aim for 5-10 clusters (if more, look for meta-clusters)
- It's okay to split or merge clusters

**Facilitator role:**
- Keep discussions moving (max 2-3 min per cluster)
- Push for specificity in names
- Document cluster names
- Capture any "aha" moments

### Part 4: Insight Generation (1:15-1:45, 30 min)

**Step 4a: So What? (20 min)**

Instructions:
> "For each theme, discuss: So what? What does this mean for our product? What should we do?"

**Process per theme:**
1. Review cluster and name
2. Discuss implications
3. Generate insight statement
4. Identify potential actions
5. Write insight on green sticky note
6. Add to cluster

**Insight formula:**
"[X] users [did/said Y] because [reason], suggesting we should [action] to [outcome]"

**Example:**
Theme: "Onboarding abandonment"
Insight: "8/10 users abandoned at 'Invite Team' step because they lacked emails, suggesting we make this optional to reduce abandonment from 60% to target 30%"

**Tips:**
- One insight per theme minimum
- Make insights specific and actionable
- Include evidence (quotes, numbers)
- Connect to product strategy

**Facilitator role:**
- Push for specific insights (not vague)
- Ask "so what?" repeatedly
- Connect insights to business goals
- Keep moving (can always revisit)

**Step 4b: Prioritize Insights (10 min)**

Instructions:
> "Dot voting: Each person gets 5 dots. Place dots on insights you think are most important."

**Criteria:**
- Impact: How many users affected? How severe?
- Urgency: How soon must we address?
- Strategic fit: Alignment with roadmap/vision?

**Result:** Top 5-7 insights emerge from voting

**Facilitator role:**
- Explain voting criteria
- Ensure everyone votes
- Tally dots visually
- Identify top insights

### Part 5: Action Planning (1:45-2:00, 15 min)

**Step 5a: Quick Wins vs Strategic (8 min)**

For top 5 insights, categorize:

**Quick Wins:**
- Low effort, high impact
- Can ship in 1-2 sprints
- Clear how to implement

**Strategic Improvements:**
- Higher effort
- Requires planning/design
- Bigger impact potential

**Process:**
- Review top 5 insights
- For each: "Quick win or strategic?"
- Discuss briefly (1-2 min each)
- Categorize

**Step 5b: Assign Owners & Next Steps (7 min)**

For each top insight:
- Who owns this?
- What's the next step?
- When will it be done?

**Document in simple format:**
```
Insight: [Statement]
Owner: [Name]
Next step: [Specific action]
Timeline: [Date/sprint]
```

**Facilitator role:**
- Get specific commitments
- Ensure someone owns each insight
- Define "next step" clearly
- Set follow-up check-in

### Workshop Wrap-Up (2-3 min)

**Celebrate:**
- "Great work team! Look at all these insights."

**Document:**
- Take photos of full wall/board
- Capture all cluster names
- Save dot voting results
- Document action items

**Next steps:**
- "I'll send out summary tomorrow"
- "Owners: Start on your action items"
- "We'll review progress in 2 weeks"

## Post-Workshop (Day After)

### 1. Document Synthesis (2-3 hours)

Create deliverable with:

**1-page executive summary:**
- Top 5 insights
- Recommendations
- Action plan with owners

**Full synthesis:**
- All themes identified
- Supporting evidence
- Detailed recommendations
- Photos of workshop

**Distribution:**
- Share with workshop participants
- Share with broader team
- Add to research repository

### 2. Start Quick Wins

**Immediate:**
- Identify 1-2 quick wins
- Create tickets/tasks
- Assign to owners
- Ship within 1-2 sprints

**Momentum:** Quick wins build confidence and show research impact

### 3. Plan Strategic Work

**Next:**
- Add strategic improvements to roadmap
- Create design briefs
- Schedule planning sessions
- Define success metrics

## Workshop Variations

### Speed Synthesis (1 hour)

Condensed for time-constrained teams:
- 0:00-0:10: Context (10 min)
- 0:10-0:25: Note writing + posting (15 min combined)
- 0:25-0:40: Grouping together (15 min, not silent)
- 0:40-0:55: Insights (15 min)
- 0:55-1:00: Actions (5 min)

**Trade-off:** Less thorough, but better than no synthesis

### Remote Synthesis

Adaptations for distributed teams:

**Before workshop:**
- Pre-work is critical (more context needed)
- Test tech setup (board access, video, etc.)
- Send clear instructions

**During workshop:**
- Longer timeboxes (remote = slower)
- More explicit turn-taking
- Regular breaks (remote fatigue)
- Use breakout rooms for parallel work

**Tips:**
- Keep video on (read the room)
- Use board features (timers, voting)
- Mute during silent phases
- Record for those who can't attend

### Async Synthesis

When live workshop isn't possible:

**Process:**
1. Share materials in Miro/Mural
2. Give 2-3 days for note writing (async)
3. Schedule 30-min live session for clustering
4. Async discussion of insights in comments
5. Live 30-min wrap-up for prioritization

**Trade-off:** Longer overall, but fits schedules better

### Team Workshop

When executives need to participate:

**Adaptations:**
- Shorter (90 min max)
- Lead with insights (skip note writing)
- Focus on implications and prioritization
- Make it easy to participate (they're busy)

**Process:**
- 0:00-0:15: Present synthesis done already
- 0:15-0:45: Discuss implications
- 0:45-1:15: Prioritize and plan
- 1:15-1:30: Commit to actions

## Facilitation Tips

**Create safety:**
- All ideas welcome
- Disagree with curiosity
- No wrong answers in synthesis

**Enforce timeboxes:**
- Use visible timer
- Give 2-minute warnings
- Move on when time's up (can revisit)

**Balance participation:**
- Invite quiet people ("Alex, what do you think?")
- Gently redirect over-talkers ("Let's hear from others")
- Silent phases prevent loud voices from dominating

**Manage disagreement:**
- "Both perspectives are valid - tell me more"
- "Let's capture both and see where we land"
- Focus on patterns, not pet theories

**Keep energy up:**
- Take breaks if needed
- Celebrate progress ("Look at all these insights!")
- Vary activities (silent, group, individual)

**Document everything:**
- Photos at each stage
- Capture good quotes from discussions
- Note dissenting opinions
- Save board/wall state

## Common Workshop Challenges

**Challenge: Too many notes**
- Solution: Look for meta-patterns, create higher-level themes

**Challenge: Can't agree on cluster names**
- Solution: Document both options, move on, revisit if needed

**Challenge: Someone dominates discussion**
- Solution: "Let's hear from others first" + enforce silent phases

**Challenge: Participants didn't do pre-work**
- Solution: Add 10-15 min at start for review, adjust agenda

**Challenge: Running out of time**
- Solution: Prioritize ruthlessly, skip lower-value clusters, schedule follow-up

**Challenge: Insights are too generic**
- Solution: Push for specificity, ask "so what?" repeatedly, add evidence

**Challenge: No clear owner for actions**
- Solution: Don't end until someone commits, make it specific

## Measuring Workshop Success

**Good outcomes:**
- 5-10 clear themes identified
- 3-5 prioritized, actionable insights
- Owners assigned to each insight
- Team has shared understanding
- Action items started within 1 week

**Warning signs:**
- Team didn't participate actively
- Insights are vague or generic
- No clear actions or owners
- Disagreement about findings
- Nothing ships after workshop

## Follow-Up

**2 weeks later:**
- Check progress on action items
- Celebrate quick wins shipped
- Adjust plans based on learnings

**1 month later:**
- Review impact of changes
- Measure success metrics
- Share results with the team
- Plan next research based on gaps

**Build culture:**
- Make synthesis workshops regular practice
- Improve facilitation over time
- Document patterns in workshop success
- Train others to facilitate
