# Thematic Analysis Guide

Systematic approach to coding qualitative data and identifying themes in research.

## What is Thematic Analysis?

**Definition:** A method for identifying, analyzing, and reporting patterns (themes) within qualitative data.

**Use when:**
- Analyzing interview transcripts
- Synthesizing open-ended survey responses
- Reviewing customer feedback
- Making sense of observational notes

**Output:** Set of themes that capture important patterns in the data

## The Three Levels of Coding

Coding is the process of labeling and organizing qualitative data.

### Level 1: Descriptive Codes

**What:** Labels describing what was said or done

**Characteristics:**
- Close to the data
- Factual, not interpretive
- Often nouns or short phrases
- Many codes (30-100+ possible)

**Examples:**
- "Mentioned pricing"
- "Clicked wrong button"
- "Expressed frustration"
- "Used spreadsheet"
- "Compared to competitor"
- "Asked for help"

**Purpose:** Break data into manageable chunks

### Level 2: Interpretive Codes

**What:** Meaning behind the descriptive codes

**Characteristics:**
- One step removed from data
- Interprets what codes mean
- Groups related descriptive codes
- Fewer codes (10-30)

**Examples:**
- "Mentioned pricing" → "Price sensitivity"
- "Clicked wrong button" → "Navigation confusion"
- "Expressed frustration" → "Emotional response to friction"
- "Used spreadsheet" → "Workaround behavior"

**Purpose:** Move from what happened to what it means

### Level 3: Pattern Codes (Themes)

**What:** Overarching patterns and big-picture insights

**Characteristics:**
- Abstract, conceptual
- Connect multiple interpretive codes
- Core themes (5-10 max)
- Answers research questions

**Examples:**
- "Price sensitivity" → "Value perception issue"
- "Navigation confusion" → "Information architecture problem"
- "Emotional response" → "User expectations mismatch"
- "Workaround behavior" → "Unmet workflow needs"

**Purpose:** Identify key insights and patterns

## The Coding Process

### Phase 1: First Pass - Open Coding

**Goal:** Generate initial codes from data

**Process:**
1. Read through all data (immersion)
2. Apply codes liberally to segments
3. Create new codes as needed
4. Don't worry about organization yet

**Tips:**
- Code anything interesting or relevant
- Use participants' own words when possible ("in vivo coding")
- Err on side of more codes (can consolidate later)
- One code can apply to multiple segments
- One segment can have multiple codes

**Example:**

Interview excerpt:
> "I tried clicking the blue button, but nothing happened. I clicked again and again. It's so frustrating when things don't work. I eventually gave up and used the menu instead."

Open codes applied:
- [Button interaction]
- [Technical failure]
- [Repeated attempts]
- [Frustration]
- [Abandonment]
- [Workaround found]
- [Menu usage]

**Result:** Long list of codes (30-100+)

### Phase 2: Second Pass - Axial Coding

**Goal:** Group related codes into categories

**Process:**
1. Review all codes generated
2. Look for relationships between codes
3. Group related codes together
4. Create category names
5. Connect codes to emerging themes

**Tips:**
- Look for codes that appear frequently together
- Use sticky notes or digital tools to cluster
- Some codes won't fit anywhere (that's okay)
- Categories should be mutually exclusive where possible

**Example:**

Grouping codes from Phase 1:

**Category: "Usability Issues"**
- Button interaction
- Technical failure
- Navigation confusion

**Category: "User Behavior"**
- Repeated attempts
- Abandonment
- Workaround found
- Menu usage

**Category: "Emotional Response"**
- Frustration
- Disappointment
- Confusion

**Result:** 10-30 categories organizing codes

### Phase 3: Third Pass - Selective Coding

**Goal:** Refine categories into core themes

**Process:**
1. Review categories from Phase 2
2. Identify 5-10 core themes
3. Ensure themes are distinct
4. Support with evidence
5. Name themes clearly

**Tips:**
- Themes should answer research questions
- Each theme should be distinct (minimal overlap)
- Themes should be supported by substantial evidence
- Name themes descriptively (not generic labels)

**Example:**

From categories to themes:

**Theme 1: "Unresponsive UI Elements Erode Trust"**
- Combines: Usability issues + Technical failures + Emotional response
- Evidence: 8/10 participants experienced button failures, all expressed frustration with reliability

**Theme 2: "Users Are Resilient Problem-Solvers"**
- Combines: Workaround behavior + Alternative paths
- Evidence: When primary path fails, users try 2-3 alternatives before abandoning

**Result:** 5-10 core themes

### Phase 4: Validation

**Goal:** Ensure themes are valid and reliable

**Validation checks:**
- [ ] Does theme appear across multiple participants? (not just one person)
- [ ] Is there sufficient evidence? (multiple examples)
- [ ] Does theme answer research questions?
- [ ] Are themes distinct from each other?
- [ ] Can someone else understand the theme from name/description?

**Cross-validation:**
- Have second researcher code subset of data
- Compare codes (should be 80%+ agreement)
- Discuss disagreements to refine

## Coding Tools and Techniques

### Manual Coding (Small Projects)

**Tools:**
- Sticky notes (physical)
- Spreadsheet with color coding
- Word document with comments/highlights

**Best for:**
- <10 interviews
- Quick synthesis
- Small team

### Digital Tools (Larger Projects)

**Dedicated tools:**
- NVivo
- Atlas.ti
- Dedoose
- MAXQDA

**Collaboration tools:**
- Miro/Mural (digital sticky notes)
- Airtable (structured coding)
- Notion (flexible organization)

**Best for:**
- 10+ interviews
- Team collaboration
- Need for rigor/audit trail

### Coding in Practice

**Line-by-line coding:**
Apply codes to every line or sentence
- Most thorough
- Most time-consuming
- Best for critical research

**Paragraph-level coding:**
Apply codes to meaningful chunks
- Balanced approach
- Most common
- Good for most projects

**Whole-document coding:**
Apply themes to entire transcript
- Quick but less rigorous
- Good for preliminary analysis
- Risk of missing nuances

## Common Coding Patterns

### Structural Coding

Code by topic or question asked

**Example codes:**
- [Onboarding experience]
- [Feature usage]
- [Pricing concerns]
- [Competitor comparison]

**Use:** When you want to quickly find all responses about specific topics

### Process Coding

Code actions and behaviors

**Example codes:**
- [Searching for feature]
- [Asking for help]
- [Creating workaround]
- [Comparing options]

**Use:** When you want to understand user workflows and behaviors

### Emotion Coding

Code emotional responses

**Example codes:**
- [Frustration]
- [Delight]
- [Confusion]
- [Anxiety]
- [Confidence]

**Use:** When emotional experience is central to research questions

### Values Coding

Code underlying values and motivations

**Example codes:**
- [Efficiency valued]
- [Control important]
- [Trust concerns]
- [Status seeking]

**Use:** When trying to understand deeper motivations

## From Codes to Themes: Worked Example

### Interview Excerpt

> "When I'm preparing for my weekly meeting with the CEO, I spend 2-3 hours pulling data from Jira, GitHub, and Slack. I have to manually copy everything into a spreadsheet because there's no other way to get it all in one place. It's so tedious. Sometimes I miss things and then I look unprepared in the meeting, which is embarrassing. I wish there was just a button I could press that would generate the whole report."

### Phase 1: Open Coding

Applied codes:
- [Weekly CEO meeting] - context
- [2-3 hours spent] - time investment
- [Multi-tool data pulling] - process
- [Jira, GitHub, Slack] - tools used
- [Manual copying] - workaround
- [Spreadsheet solution] - current tool
- [No alternative] - limitation
- [Tedious process] - frustration
- [Errors made] - accuracy issues
- [Looking unprepared] - consequence
- [Embarrassment] - emotion
- [Desired automation] - feature request

### Phase 2: Axial Coding

Grouped into categories:

**Category A: "Time-intensive manual process"**
- 2-3 hours spent
- Multi-tool data pulling
- Manual copying
- Tedious process

**Category B: "Inadequate current tooling"**
- Spreadsheet solution
- No alternative
- Tools used: Jira, GitHub, Slack

**Category C: "Quality and credibility concerns"**
- Errors made
- Looking unprepared
- Embarrassment

**Category D: "Desire for automation"**
- Desired automation

### Phase 3: Selective Coding (Theme)

**Theme: "Manual Status Reporting Threatens Professional Credibility"**

**Description:**
PMs spend 2-3 hours weekly manually compiling project status from multiple tools (Jira, GitHub, Slack) into spreadsheets. This time-intensive process is error-prone, and mistakes lead to appearing unprepared in leadership meetings, causing embarrassment and eroding credibility. Users desire automated report generation that consolidates data from multiple sources.

**Evidence:**
- Quantified time: "2-3 hours weekly"
- Process description: Manual copying from 3 tools
- Consequence: "Look unprepared", "embarrassing"
- Explicit request: "Wish there was a button"

**Implications:**
- High-value job to be done: Leadership reporting
- Current solutions inadequate (no good alternative)
- Stakes are high: Professional credibility
- Automation is desired solution

## Theme Quality Checklist

Good themes have these characteristics:

- [ ] **Coherent:** Theme makes sense as a unified concept
- [ ] **Distinct:** Clearly different from other themes
- [ ] **Consistent:** Appears across multiple participants
- [ ] **Substantive:** Supported by substantial evidence
- [ ] **Relevant:** Answers research questions
- [ ] **Clear:** Can be understood from name and description
- [ ] **Actionable:** Has implications for product/design

## Common Thematic Analysis Pitfalls

**Pitfall 1: Too many themes**
- More than 10 themes = probably not themes, still categories
- Solution: Consolidate, find higher-level patterns

**Pitfall 2: Themes overlap too much**
- Can't tell where one theme ends and another begins
- Solution: Refine definitions, merge themes, or split

**Pitfall 3: Weak themes**
- Based on one or two participants
- Solution: Validate across more participants or demote to finding (not theme)

**Pitfall 4: Generic theme names**
- "User experience" (too broad)
- "Problems" (not descriptive)
- Solution: Be specific, use descriptive names

**Pitfall 5: Solution masquerading as theme**
- "Need feature X" is not a theme
- Theme describes the problem/pattern, not solution

**Pitfall 6: Confirmation bias**
- Only coding things that support hypothesis
- Solution: Code everything, look for disconfirming evidence

## Advanced Techniques

### Thematic Networks

Map relationships between themes:
- Global themes (highest level)
- Organizing themes (mid-level)
- Basic themes (specific patterns)

**Example:**
```
Global: "Trust Issues with Product"
  ├─ Organizing: "Reliability Concerns"
  │   ├─ Basic: "Features don't work"
  │   └─ Basic: "Data inaccuracies"
  └─ Organizing: "Transparency Concerns"
      ├─ Basic: "Unclear pricing"
      └─ Basic: "Hidden limitations"
```

### Thematic Comparison

Compare themes across segments:
- Do new users have different themes than power users?
- Do themes differ by company size, role, industry?

**Use:** Identify segment-specific patterns

### Temporal Thematic Analysis

How do themes change over time?
- First use vs 6 months later
- Before vs after feature launch
- Throughout customer journey

**Use:** Understand how experience evolves

## Reporting Themes

### Theme Description Template

**Theme Name:** [Clear, descriptive name]

**Definition:** [One-paragraph description of what this theme encompasses]

**Frequency:** [How many participants, how often mentioned]

**Supporting Evidence:**
- Quote 1: "..." - [Participant]
- Quote 2: "..." - [Participant]
- Behavioral observation: [Description]

**Implications:** [What this means for product/design]

**Related Themes:** [Connections to other themes]

---

## Further Reading

- Braun & Clarke (2006): "Using thematic analysis in psychology" - foundational paper
- Saldaña (2015): "The Coding Manual for Qualitative Researchers" - comprehensive coding guide
- Guest et al. (2011): "Applied Thematic Analysis" - practical applications
