---
name: taiyo-rewriter
description: 既存コンテンツを太陽スタイルに変換するリライトスキル。文章構造・語尾・キラーワード・心理トリガーを最適化して成約率を向上。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [rewrite, optimization, taiyo-style, copywriting]
dependencies: [taiyo-analyzer]
---

# 太陽 Rewriter Skill

## Overview

**既存コンテンツを太陽スタイルに変換**するリライトスキル。
taiyo-analyzerと連携し、スコアが低い部分を自動検出・改善提案・リライトを実行。

## When to Use

```
「この文章を太陽スタイルにリライトして」
「セールスレターを改善して」
「/taiyo-rewriter」
「このLPを太陽化して」
```

## リライトフレームワーク

### 全体フロー

```
┌─────────────────────────────────────────────────────────────┐
│               太陽 Rewriter Flow                             │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  1. 入力コンテンツ受け取り                                   │
│       ↓                                                     │
│  2. taiyo-analyzer でスコアリング                             │
│       ↓                                                     │
│  3. 改善ポイント特定（6次元分析）                            │
│       ↓                                                     │
│  4. 優先度順にリライト実行                                   │
│       ↓                                                     │
│  5. 再スコアリングで効果確認                                 │
│       ↓                                                     │
│  6. Before/After比較レポート出力                             │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

## 6次元リライト戦略

### 1. 語尾パターン最適化

**診断基準**:
```
現状の語尾比率を分析
↓
黄金比率との差分を計算
↓
調整が必要な語尾を特定
```

**リライトルール**:

| 現状 | 問題 | リライト方向 |
|-----|------|------------|
| 断定形が多すぎ | 押しつけがましい | 疑問形・読者巻き込み型を追加 |
| 疑問形が多すぎ | 自信がなく見える | 断定形を増やす |
| 説明形が多すぎ | 退屈になる | 感嘆・強調型を追加 |

**Before/After例**:
```
Before（断定形90%）:
「これは最高の方法です。絶対に成功します。間違いありません。」

After（バランス調整）:
「これは最高の方法です。
なぜ成功すると言い切れるのか？
それは、すでに1,247名が証明しているからです。」
```

### 2. キラーワード配置最適化

**診断基準**:
```
カテゴリ別キラーワード出現数を計測
↓
不足カテゴリを特定
↓
配置すべき箇所を提案
```

**リライトルール**:

| 不足カテゴリ | 追加方法 |
|------------|---------|
| 数値系 | 具体的な数字を追加（端数含む） |
| 恐怖系 | 損失シナリオを追加 |
| 希望系 | 成功後の姿を追加 |
| 緊急性系 | 締切・限定を追加 |

**Before/After例**:
```
Before（数値系不足）:
「多くの人が成功しています。短期間で結果が出ます。」

After（数値系追加）:
「すでに1,247名が成功しています。
平均87日で最初の成果が出ています。
成功率は93.7%です。」
```

### 3. 心理トリガー配置最適化

**診断基準**:
```
セクションごとのトリガー配置を分析
↓
理想配置との差分を計算
↓
追加・移動すべきトリガーを特定
```

**リライトルール**:

| セクション | 必要トリガー | 追加方法 |
|-----------|------------|---------|
| オープニング | 恐怖 + 希望 | 問題提起 + 解決の予感 |
| ボディ前半 | 恐怖深化 | 最悪シナリオ描写 |
| ボディ中盤 | 希望 + 証明 | 成功事例 + 実績数字 |
| クロージング | 緊急性 + 希少性 | 締切 + 限定条件 |

**Before/After例**:
```
Before（オープニングに恐怖トリガーなし）:
「今日は素晴らしい方法をお伝えします。
この方法を使えば、あなたも成功できます。」

After（恐怖→希望サイクル追加）:
「あなたは今、重大な岐路に立っています。

このまま何もしなければ、
1年後も同じ場所で同じ悩みを抱えているでしょう。

でも、今日この手紙を読むことで、
その未来は180度変わります。」
```

### 4. 文章リズム最適化

**診断基準**:
```
文長分布を分析
↓
短文/中文/長文比率を計算
↓
理想比率との差分を特定
```

**リライトルール**:

| 問題 | 対処法 |
|-----|-------|
| 長文が多すぎ | 文を分割、短文化 |
| 短文ばかり | 一部を結合、説明を追加 |
| リズムが単調 | 意図的な変化を追加 |
| 空白行が少ない | 段落間に空白を追加 |

**Before/After例**:
```
Before（長文多め、空白なし）:
「この方法は、私が10年かけて開発したもので、すでに多くの人が成功しており、あなたも同じ結果を得ることができます。なぜなら、この方法は誰にでも再現可能なステップに分解されているからです。」

After（短文化、空白追加）:
「この方法は、私が10年かけて開発しました。

すでに多くの人が成功しています。
あなたも同じ結果を得ることができます。

なぜか？

この方法は、誰にでも再現可能な
ステップに分解されているからです。」
```

### 5. ストーリー構造最適化

**診断基準**:
```
7幕構成の有無をチェック
↓
感情曲線の起伏を分析
↓
不足要素を特定
```

**リライトルール**:

| 不足要素 | 追加方法 |
|---------|---------|
| どん底描写 | 具体的な苦悩シーンを追加 |
| 転機 | 出会い・発見の瞬間を追加 |
| 成功体験 | 具体的な成果描写を追加 |
| 読者への橋渡し | 「あなたも」の文脈を追加 |

### 6. 全体バランス最適化

**診断基準**:
```
80項目チェックリストでスキャン
↓
未達成項目を特定
↓
優先度順に改善
```

## リライトモード

### モード1: 軽微調整（スコア70-79）
```
対象: 基本はできているが微調整が必要
作業: 語尾調整、キラーワード追加
所要時間: 短い
変更量: 10-20%
```

### モード2: 部分リライト（スコア60-69）
```
対象: 一部セクションに問題がある
作業: 問題セクションの書き直し
所要時間: 中程度
変更量: 30-50%
```

### モード3: 全面リライト（スコア60未満）
```
対象: 構造から見直しが必要
作業: フレームワークに沿って再構築
所要時間: 長い
変更量: 70-100%
```

## リライト実行プロセス

### Step 1: 入力と分析
```
入力: 既存コンテンツ
↓
taiyo-analyzer実行
↓
6次元スコア取得
↓
改善優先度決定
```

### Step 2: 改善計画作成
```
各次元の改善ポイントをリスト化
↓
優先度順にソート
↓
リライト計画を提示
```

### Step 3: リライト実行
```
優先度1から順に改善
↓
各改善後に部分スコアチェック
↓
全体リライト完了
```

### Step 4: 効果検証
```
Before/Afterスコア比較
↓
改善率算出
↓
残課題の特定
```

## 出力フォーマット

### 分析レポート
```markdown
# 太陽 Rewriter 分析レポート

## Before スコア
| 項目 | スコア | 評価 |
|-----|-------|-----|
| 語尾パターン | 12/20 | 要改善 |
| キラーワード | 8/20 | 要改善 |
| 心理トリガー | 14/20 | 普通 |
| 文章リズム | 9/15 | 要改善 |
| ストーリー構造 | 11/15 | 普通 |
| 全体バランス | 6/10 | 要改善 |
| **合計** | **60/100** | **C** |

## 改善計画

### 優先度1: キラーワード追加
- 現状: 数値系0個、恐怖系2個
- 目標: 数値系5個、恐怖系5個
- 追加箇所: [具体的な箇所]

### 優先度2: 語尾バランス調整
- 現状: 断定形85%
- 目標: 断定形60%、疑問形25%
- 変更箇所: [具体的な箇所]

...
```

### リライト結果
```markdown
# 太陽 Rewriter リライト結果

## Before/After スコア比較

| 項目 | Before | After | 改善 |
|-----|--------|-------|-----|
| 語尾パターン | 12 | 17 | +5 |
| キラーワード | 8 | 16 | +8 |
| 心理トリガー | 14 | 18 | +4 |
| 文章リズム | 9 | 13 | +4 |
| ストーリー構造 | 11 | 14 | +3 |
| 全体バランス | 6 | 8 | +2 |
| **合計** | **60** | **86** | **+26** |
| **ランク** | **C** | **A** | **↑2** |

## リライト済みコンテンツ

[リライト後の全文]

---

## 変更箇所ハイライト

### 変更1: ヘッドライン
**Before:**
> [元の文]

**After:**
> [変更後の文]

**変更理由:** 数値系キラーワード追加

### 変更2: ...
```

## 品質保証

### リライト後の必達基準
- [ ] スコア80点以上
- [ ] 語尾バランスが黄金比率±10%
- [ ] 全キラーワードカテゴリを使用
- [ ] 恐怖→希望サイクル5回以上
- [ ] 1文1行率90%以上

### リライト禁止事項
- 意味を変えてしまう改変
- 専門用語の誤った置換
- 過度な誇張表現の追加
- 事実と異なる数字の追加

## 関連スキル

- `taiyo-analyzer` - スコアリング（必須連携）
- `taiyo-style-sales-letter` - セールスレター
- `taiyo-style-step-mail` - ステップメール
- `taiyo-style-lp` - LP作成
- `copywriting-helper` - コピーライティング支援
