---
name: taiyo-style-bullet
description: 太陽スタイル完全準拠のブレット（箇条書き）・ベネフィットリスト生成。特徴→ベネフィット変換で購買意欲を最大化。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [bullet, benefit, taiyo-style, copywriting]
dependencies: [taiyo-analyzer]
---

# Taiyo Style Bullet Skill

## Overview

**購買意欲を3.8倍**に高める太陽スタイルのブレット（箇条書き）・ベネフィットリスト生成スキル。
特徴をベネフィットに変換し、感情を動かす箇条書きを作成。

## When to Use

```
「太陽スタイルでベネフィットリストを作って」
「この商品の特徴をブレットにして」
「/taiyo-style-bullet」
「特典一覧を魅力的に書いて」
```

## ブレット8つの黄金パターン

### パターン1: 数字+成果型
```
【公式】✅ [期間]で[数字の成果]を達成できる[方法/ノウハウ]

例:
✅ たった3日で月収10万円を達成できる即金ノウハウ
✅ わずか5分の作業で毎日3,000円が入る仕組み
✅ 24時間以内に最初の売上を立てる具体的手順
```

### パターン2: 恐怖回避型
```
【公式】✅ [恐怖/失敗]を避けるための[解決策]

例:
✅ 詐欺商材に騙されないための7つのチェックリスト
✅ 副業で失敗する人の共通パターンと回避法
✅ 時間とお金を無駄にしないための最短ルート
```

### パターン3: 秘密暴露型
```
【公式】✅ [権威者]だけが知っている[秘密/テクニック]

例:
✅ トップ営業マンだけが使う心理テクニック
✅ 成功者が絶対に口外しない稼ぎ方の本質
✅ 億万長者が実践している時間術の秘密
```

### パターン4: 簡単・シンプル型
```
【公式】✅ [難しそうなこと]を[簡単に]できる[方法]

例:
✅ パソコン苦手でも5分でできる自動化設定
✅ 文章力ゼロでも売れるセールスレターの型
✅ 知識ゼロからでも始められる完全初心者向けカリキュラム
```

### パターン5: Before→After型
```
【公式】✅ [Before状態]が[After状態]に変わる

例:
✅ 「何を書けばいいかわからない」→「手が止まらない」状態に
✅ 月収15万円→月収100万円への具体的ステップ
✅ 「いつか」が「今すぐ」に変わる行動トリガー
```

### パターン6: 限定・希少型
```
【公式】✅ [ここでしか/今だけ]手に入らない[価値]

例:
✅ 門外不出のトップシークレットを特別公開
✅ 今回限りの参加者だけに渡す極秘資料
✅ 他では絶対に学べない独自メソッド
```

### パターン7: 証拠・実績型
```
【公式】✅ [具体的な実績/証拠]に基づく[内容]

例:
✅ 1,247名が実証済みの再現性の高いノウハウ
✅ 累計売上10億円を生み出した販売戦略
✅ 93.7%の成功率を誇る独自システム
```

### パターン8: 感情・未来型
```
【公式】✅ [感情的な状態]を手に入れる

例:
✅ 毎朝目覚まし無しで起きる自由な生活
✅ 「会社に行きたくない」から解放される方法
✅ 家族に誇れる自分になるためのロードマップ
```

## 特徴→ベネフィット変換法

### 変換公式
```
特徴 → 「だから」 → メリット → 「つまり」 → ベネフィット → 「結果」 → 感情

例:
特徴: 動画100本
↓「だから」
メリット: 体系的に学べる
↓「つまり」
ベネフィット: 最短で結果が出る
↓「結果」
感情: 早く自由になれる
```

### 変換テンプレート

| 特徴 | → | ベネフィット表現 |
|-----|---|----------------|
| 24時間対応 | → | 「深夜2時に困ってもすぐ解決。もう一人で悩まない」 |
| PDF100ページ | → | 「迷った時にすぐ答えが見つかる辞書的バイブル」 |
| 個別コンサル付き | → | 「あなた専用の成功プランを一緒に作る」 |
| 返金保証 | → | 「リスクゼロで試せるから安心して始められる」 |
| 会員サイト | → | 「スマホでいつでもどこでも学べる」 |

## 用途別ブレット設計

### 商品内容リスト（セールスレター）
```
【このプログラムに含まれるもの】

✅ 本編動画全87本（総収録時間23時間17分）
   → 1日30分×3ヶ月で完全マスター

✅ 実践ワークシート42種（PDF形式）
   → 手を動かしながら確実に身につく

✅ 個別コンサルティング（月1回×6ヶ月）
   → あなた専用の成功プランを作成

✅ 会員限定コミュニティ（永久参加権）
   → 仲間と切磋琢磨、モチベーション維持

✅ 最新版アップデート（永久無料）
   → 一度購入すれば追加料金なし
```

### 特典リスト
```
【今だけの限定特典】

🎁 特典1: 即金マニュアル（通常19,800円相当）
   「24時間以内に最初の1万円を稼ぐ」具体的手順書
   → 今すぐ成果を出したい人の即効薬

🎁 特典2: テンプレート集50種（通常29,800円相当）
   コピペで使えるメール・LP・広告文の型
   → 文章力ゼロでもプロ級のコピーが書ける

🎁 特典3: 秘密のZoomセミナー招待（非売品）
   他では絶対に話さない裏ノウハウを公開
   → 参加者だけが知る最新戦略
```

### 悩みリスト（共感セクション）
```
【こんなお悩みありませんか？】

□ 副業を始めたいけど何から始めればいいかわからない
□ いろいろ試したけど結局1円も稼げていない
□ 時間がなくて副業に取り組む余裕がない
□ パソコンが苦手で難しいことはできない
□ 家族に内緒で始めたいけどバレないか不安
□ 詐欺商材に騙されたことがあって怖い
□ 本当に自分にもできるのか自信がない

→ 一つでも当てはまるなら、この続きを読んでください
```

### 実績リスト
```
【受講生の成果（一部抜粋）】

📈 Aさん（40代・会社員）
   開始3ヶ月で月収87.3万円達成

📈 Bさん（30代・主婦）
   副業から始めて6ヶ月で独立

📈 Cさん（50代・経営者）
   既存ビジネスに応用して売上3.2倍

📈 Dさん（20代・フリーター）
   完全未経験から年商1億円達成
```

## ブレットの黄金法則

### 法則1: 1ブレット1ベネフィット
```
❌ 「動画100本で体系的に学べて最短で結果が出る」

✅ 「動画100本で体系的に学べる」
✅ 「最短ルートで結果を出せる」
```

### 法則2: 数字は端数で
```
❌ 「100名が成功」
✅ 「127名が成功」

❌ 「3ヶ月で成果」
✅ 「87日で成果」
```

### 法則3: 感情を入れる
```
❌ 「収入が増える」
✅ 「給料日前の不安から解放される」

❌ 「時間ができる」
✅ 「子供の寝顔を見る余裕ができる」
```

### 法則4: 具体的にする
```
❌ 「サポートが充実」
✅ 「24時間以内に必ず返信。深夜2時の質問にも対応」

❌ 「わかりやすい」
✅ 「小学5年生でも理解できるように解説」
```

### 法則5: リズムを作る
```
短い → 短い → 長め → 短い → 長め

✅ 即金ノウハウ公開
✅ テンプレート50種
✅ プロのライターが3年かけて作った売れるコピーの型
✅ 個別コンサル付き
✅ あなた専用の成功プランを一緒に作る権利
```

## 品質チェックリスト

### 各ブレットのチェック
- [ ] 具体的な数字が入っている
- [ ] ベネフィット（結果・感情）が含まれている
- [ ] 1ブレット1メッセージ
- [ ] 感情を動かすワードがある
- [ ] 読みやすいリズム

### リスト全体のチェック
- [ ] 5-10項目程度（多すぎない）
- [ ] パターンが分散している
- [ ] 最重要ベネフィットが最初と最後
- [ ] 視覚的に見やすい

## 出力フォーマット

```markdown
# ブレットリスト生成結果

## 入力情報
- 商品/サービス: ◯◯
- 特徴リスト: [入力された特徴]
- 用途: [商品内容/特典/悩み/実績]

## 生成ブレット

### 商品内容ブレット
✅ [ブレット1]
   → [ベネフィット補足]

✅ [ブレット2]
   → [ベネフィット補足]

...

### 特典ブレット
🎁 特典1: [特典名]（◯◯円相当）
   [説明]
   → [ベネフィット]

...

## 品質スコア
- 太陽スコア: XX/100
- 具体性: ⭐⭐⭐⭐☆
- 感情訴求: ⭐⭐⭐⭐⭐
- リズム: ⭐⭐⭐⭐☆
```

## 関連スキル

- `taiyo-analyzer` - スコアリング
- `taiyo-style-sales-letter` - セールスレター
- `taiyo-style-lp` - LP作成
- `copywriting-helper` - コピーライティング支援
