---
name: taiyo-style-headline
description: 太陽スタイル完全準拠のヘッドライン・キャッチコピー生成。開封率・クリック率・注目率を最大化する衝撃的な見出しを作成。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [headline, catchcopy, taiyo-style, copywriting]
dependencies: [taiyo-analyzer]
---

# Taiyo Style Headline Skill

## Overview

**開封率3.2倍、クリック率4.7倍**を実現する太陽スタイルのヘッドライン・キャッチコピー生成スキル。
12の黄金パターンと心理トリガーを組み合わせ、一瞬で心を掴む見出しを作成。

## When to Use

```
「太陽スタイルでヘッドラインを作って」
「キャッチコピーを10案考えて」
「/taiyo-style-headline」
「メルマガの件名を最適化して」
```

## ヘッドライン12の黄金パターン

### パターン1: 数字+ベネフィット型
```
【公式】[数字] + [期間] + [ベネフィット]

例:
「たった3日で月収127.8万円を達成した方法」
「わずか5分で英語が話せるようになる秘密」
「24時間以内に最初の1万円を稼ぐ仕組み」
```
**効果**: 具体性UP、信憑性UP
**使用場面**: LP、セールスレター、メルマガ

### パターン2: 疑問+好奇心型
```
【公式】なぜ[逆説的事実]なのか？

例:
「なぜ97.3%の人が副業で失敗するのか？」
「なぜ努力する人ほど稼げないのか？」
「なぜ頭の良い人ほど騙されるのか？」
```
**効果**: 好奇心喚起、続きを読ませる
**使用場面**: メルマガ件名、ブログタイトル

### パターン3: 警告+恐怖型
```
【公式】【警告】[ターゲット]が知らない[リスク]

例:
「【警告】副業初心者が陥る3つの致命的な罠」
「【緊急】このまま何もしないと起こる最悪の未来」
「【要注意】99%の人が間違えている◯◯の常識」
```
**効果**: 危機感喚起、行動促進
**使用場面**: メルマガ、LP冒頭

### パターン4: Before→After型
```
【公式】[どん底の状態] → [成功した状態]

例:
「借金300万円→年収3000万円になった逆転劇」
「月収15万円の派遣社員が→月商1億円の社長に」
「英語力ゼロ→TOEIC900点を3ヶ月で達成」
```
**効果**: 変化の可能性を示す
**使用場面**: お客様の声、ストーリー導入

### パターン5: 秘密暴露型
```
【公式】[権威者]が絶対に教えない[秘密]

例:
「銀行員が絶対に教えない資産運用の真実」
「成功者が隠している本当の稼ぎ方」
「誰も教えてくれなかった◯◯の裏側」
```
**効果**: 独占欲、特別感
**使用場面**: 無料オファー、メルマガ

### パターン6: 限定+緊急型
```
【公式】【期限】+ [限定条件] + [特典/機会]

例:
「【本日23:59まで】先着30名限定で無料公開」
「【残り3名】二度と手に入らない特別プログラム」
「【48時間限定】通常29.8万円→無料」
```
**効果**: 即決促進、FOMO喚起
**使用場面**: クロージング、追撃メール

### パターン7: 反常識型
```
【公式】[常識の否定] という衝撃の事実

例:
「努力するな、という成功者の教え」
「お金を使うほど貯まる不思議な法則」
「働かないほど稼げるビジネスの正体」
```
**効果**: 意外性、知的好奇心
**使用場面**: コンテンツタイトル、SNS

### パターン8: ターゲット特定型
```
【公式】[具体的なターゲット]限定

例:
「40代サラリーマン限定：退職金を3倍にする方法」
「子育て中のママだけに教える在宅ワークの秘密」
「年収500万円以下の人は絶対に見ないでください」
```
**効果**: 自分事化、除外による価値向上
**使用場面**: 広告、LP

### パターン9: ストーリー予告型
```
【公式】[衝撃的な結末]までの物語

例:
「無職の私が3ヶ月で億を稼ぐまでの全記録」
「詐欺に遭って全財産を失った男の復活劇」
「余命宣告を受けてから人生が変わった話」
```
**効果**: 感情移入、続きへの期待
**使用場面**: ステップメール、VSL

### パターン10: 証拠提示型
```
【公式】[具体的な証拠] を公開

例:
「銀行口座の残高1.27億円を全公開」
「実績者1,247名のリアルな声を公開」
「売上管理画面をそのままお見せします」
```
**効果**: 信頼性、具体性
**使用場面**: LP中盤、証拠セクション

### パターン11: 比較優位型
```
【公式】[競合/常識] vs [自分の方法]

例:
「YouTube vs ブログ：今から始めるならどっち？」
「努力型 vs 仕組み型：稼げるのはどっち？」
「大手vs個人：なぜ個人が勝てるのか」
```
**効果**: 差別化、選択の明確化
**使用場面**: 比較コンテンツ、教育

### パターン12: 約束型
```
【公式】この[コンテンツ]で[具体的な成果]を約束

例:
「この動画を見終わる頃、あなたは◯◯ができるようになっています」
「読むだけで月収10万円アップする方法を完全公開」
「この手紙があなたの人生を変えることを約束します」
```
**効果**: 期待感、コミットメント
**使用場面**: LP冒頭、動画冒頭

## 用途別テンプレート

### メルマガ件名（20-30文字）

| パターン | テンプレート | 例 |
|---------|------------|---|
| 数字型 | 「[数字]の[秘密/方法/理由]」 | 「月収100万円の3つの秘密」 |
| 疑問型 | 「なぜ[逆説]なのか？」 | 「なぜ頑張る人ほど貧乏なのか？」 |
| 緊急型 | 「【残り◯時間】[内容]」 | 「【残り3時間】最後のチャンス」 |
| 告白型 | 「正直に告白します...」 | 「正直に告白します...」 |
| 質問型 | 「◯◯で悩んでいませんか？」 | 「集客で悩んでいませんか？」 |

### LPヘッドライン（30-50文字）

| パターン | テンプレート |
|---------|------------|
| メイン | 「[期間]で[数字の成果]を達成する[方法/システム]」 |
| サブ | 「[ターゲット]でも[簡単さ]で[ベネフィット]」 |

### SNS投稿（15-25文字）

| パターン | テンプレート |
|---------|------------|
| 反常識 | 「[常識]は嘘だった」 |
| 暴露 | 「[業界/人]が隠している[真実]」 |
| 数字 | 「[数字]%の人が知らない[事実]」 |

## キラーワード配置

### 冒頭に使うキラーワード
```
【警告】【緊急】【限定】【無料】【秘密】
【暴露】【証拠】【真実】【発見】【革命】
```

### 数字の入れ方
```
❌ 「月収100万円」
✅ 「月収127.8万円」（端数で信憑性UP）

❌ 「3ヶ月で」
✅ 「たった87日で」（具体的で信憑性UP）

❌ 「多くの人が」
✅ 「1,247名が」（具体的で社会的証明）
```

### 感情を動かすワード
```
恐怖系: 「致命的」「取り返しのつかない」「手遅れ」
希望系: 「逆転」「脱出」「自由」「解放」
緊急系: 「今すぐ」「今日中」「残りわずか」
限定系: 「先着」「限定」「二度とない」
```

## ヘッドライン生成フロー

### Step 1: 情報収集
```
1. ターゲットは誰か？
2. 最大のベネフィットは？
3. 使える数字は？
4. 競合との違いは？
5. 緊急性の要素は？
```

### Step 2: パターン選択
```
目的に応じてパターンを選択：
- 開封率重視 → 疑問型、秘密暴露型
- クリック率重視 → 数字型、Before/After型
- 成約率重視 → 限定緊急型、約束型
```

### Step 3: 10案生成
```
選択パターンで10案を生成
↓
taiyo-analyzerでスコアチェック
↓
上位3案を最終候補に
```

### Step 4: A/Bテスト推奨
```
最終候補2-3案でA/Bテスト
↓
勝者を採用
```

## 品質チェックリスト

### 必須要素
- [ ] 具体的な数字が含まれている
- [ ] ターゲットが明確
- [ ] ベネフィットが伝わる
- [ ] 20-50文字以内（用途による）
- [ ] 感情を動かすワードがある

### NGパターン
- [ ] 抽象的すぎる（「成功する方法」）
- [ ] 長すぎる（60文字以上）
- [ ] 誇大すぎる（「100%成功」）
- [ ] ターゲット不明

## 出力フォーマット

```markdown
# ヘッドライン生成結果

## 入力情報
- ターゲット: ◯◯
- 商品/サービス: ◯◯
- 主要ベネフィット: ◯◯
- 用途: [メルマガ/LP/SNS]

## 生成案（10案）

### A案（数字+ベネフィット型）
「[ヘッドライン]」
- 文字数: ◯文字
- 強み: ◯◯
- 太陽スコア: XX/100

### B案（疑問+好奇心型）
...

## 推奨TOP3

1. **最推奨**: [A案]
   - 理由: ◯◯

2. **次点**: [D案]
   - 理由: ◯◯

3. **代替**: [G案]
   - 理由: ◯◯

## A/Bテスト提案
- テスト案1: [A案]
- テスト案2: [D案]
- 計測指標: 開封率/クリック率
```

## 関連スキル

- `taiyo-analyzer` - スコアリング
- `taiyo-style-sales-letter` - セールスレター
- `taiyo-style-step-mail` - ステップメール
- `copywriting-helper` - コピーライティング支援
