---
name: taiyo-style-lp
description: 太陽スタイル完全準拠のLP（ランディングページ）作成・最適化。成約率4.3倍を実現する構造・心理トリガー・キラーワード配置の完全ガイド。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [lp, landing-page, taiyo-style, conversion-optimization]
dependencies: [taiyo-analyzer]
---

# Taiyo Style LP Skill

## Overview

**成約率4.3倍**を実現する太陽スタイル完全準拠のLP作成・最適化スキル。
176パターンを活用した構造設計、心理トリガー配置、キラーワード最適化により、高成約LPを作成。

## When to Use

```
「太陽スタイルでLPを作って」
「高成約率のランディングページを作成」
「/taiyo-style-lp」
「このLPを太陽スタイルで改善して」
```

## LP設計フレームワーク

### 12セクション構造

```
┌─────────────────────────────────────────────────────────────┐
│              Taiyo Style LP 12セクション構造                 │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  【ファーストビュー】                                        │
│  └── セクション1: ヘッドコピー＆キャッチ                    │
│                                                             │
│  【問題提起ゾーン】                                          │
│  ├── セクション2: 共感・問題認識                            │
│  └── セクション3: 問題を放置した未来（恐怖）                │
│                                                             │
│  【解決提示ゾーン】                                          │
│  ├── セクション4: 解決策の提示                              │
│  ├── セクション5: 商品/サービス紹介                         │
│  └── セクション6: 特徴とベネフィット                        │
│                                                             │
│  【信頼構築ゾーン】                                          │
│  ├── セクション7: 実績・証拠                                │
│  ├── セクション8: お客様の声                                │
│  └── セクション9: よくある質問                              │
│                                                             │
│  【オファーゾーン】                                          │
│  ├── セクション10: 価格・特典提示                           │
│  ├── セクション11: 保証・リスクリバーサル                   │
│  └── セクション12: CTA＆追伸                                │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

## 各セクション詳細設計

### セクション1: ヘッドコピー＆キャッチ

**目的**: 3秒で「自分のことだ」と思わせる

**構成要素**:
```
┌─────────────────────────────────────────┐
│  プリヘッド（小見出し）                  │
│  「◯◯な方へ」「警告」「限定」           │
├─────────────────────────────────────────┤
│  メインヘッドライン                      │
│  [数字] + [ベネフィット] + [期間]        │
├─────────────────────────────────────────┤
│  サブヘッド                              │
│  具体的な約束・補足説明                  │
├─────────────────────────────────────────┤
│  ファーストビューCTA（任意）             │
│  「詳しく見る」「無料で始める」          │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 数値系（端数必須）+ 希望系
- 語尾: 断定形80%
- 心理トリガー: 希望 + 緊急性

**ヘッドライン公式**:
```
【数字】を【期間】で達成する【方法/システム】

例:
「月収127.8万円をたった90日で達成した
 完全自動化システムの全貌」
```

### セクション2: 共感・問題認識

**目的**: 読者の痛みを言語化

**構成要素**:
```
┌─────────────────────────────────────────┐
│  「こんなお悩みありませんか？」          │
├─────────────────────────────────────────┤
│  悩みリスト（5-7項目）                   │
│  □ 具体的な悩み1                         │
│  □ 具体的な悩み2                         │
│  □ ...                                   │
├─────────────────────────────────────────┤
│  「一つでも当てはまるなら...」           │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 恐怖系 + 共感系
- 語尾: 疑問形50% + 読者巻き込み型30%
- 心理トリガー: 損失回避（導入）

**悩みリストの法則**:
- 具体的な数字を入れる
- 感情的な言葉を使う
- 読者が「あるある」と思う内容

### セクション3: 問題を放置した未来（恐怖）

**目的**: 行動しないリスクを明確化

**構成要素**:
```
┌─────────────────────────────────────────┐
│  「このまま何もしなければ...」          │
├─────────────────────────────────────────┤
│  1年後の最悪シナリオ                     │
│  3年後の最悪シナリオ                     │
│  5年後の最悪シナリオ                     │
├─────────────────────────────────────────┤
│  「でも、まだ間に合います」             │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 損失系 + 時間損失系（全開）
- 語尾: 否定・警告型30%
- 心理トリガー: 損失回避（最高潮）

**感情曲線**: ここが最低点（-100）

### セクション4: 解決策の提示

**目的**: 希望の光を見せる

**構成要素**:
```
┌─────────────────────────────────────────┐
│  「そこで、ご紹介するのが...」          │
├─────────────────────────────────────────┤
│  解決策の概要                            │
│  なぜこれが効くのか（3つの理由）         │
│  他との違い                              │
├─────────────────────────────────────────┤
│  「あなたの人生が変わる瞬間です」       │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 希望系 + 実証済み系
- 語尾: 断定形60% + 仮定・条件型20%
- 心理トリガー: 希望・快楽トリガー

**感情曲線**: 急上昇（-100 → +50）

### セクション5: 商品/サービス紹介

**目的**: 具体的な内容を説明

**構成要素**:
```
┌─────────────────────────────────────────┐
│  商品名＆コンセプト                      │
├─────────────────────────────────────────┤
│  カリキュラム/内容一覧                   │
│  ・モジュール1: ◯◯                      │
│  ・モジュール2: △△                      │
│  ・...                                   │
├─────────────────────────────────────────┤
│  受講形式/提供方法                       │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- 語尾: 説明形60%
- 各項目に価値を付記（「これだけで◯万円の価値」）

### セクション6: 特徴とベネフィット

**目的**: 「だから何？」に答える

**構成要素**:
```
┌─────────────────────────────────────────┐
│  特徴 → ベネフィット 変換表             │
├─────────────────────────────────────────┤
│  【特徴】24時間サポート                  │
│  ↓                                       │
│  【ベネフィット】深夜2時に困っても       │
│  すぐに解決できるから安心                │
├─────────────────────────────────────────┤
│  （5-7項目）                             │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 簡単系 + 実証済み系
- 語尾: 仮定・条件型（「〜できる」「〜になる」）

**ベネフィット変換の法則**:
```
特徴 → 「だから」 → メリット → 「つまり」 → ベネフィット

例:
動画100本 → だから体系的に学べる → つまり最短で結果が出る
```

### セクション7: 実績・証拠

**目的**: 信頼性を確立

**構成要素**:
```
┌─────────────────────────────────────────┐
│  数字による実績                          │
│  ・累計◯◯◯名が受講                     │
│  ・成功率◯◯.◯%                         │
│  ・平均◯ヶ月で成果                      │
├─────────────────────────────────────────┤
│  メディア掲載実績                        │
├─────────────────────────────────────────┤
│  資格・認定・受賞歴                      │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 数値系（端数必須）
- 心理トリガー: 社会的証明 + 権威・専門性
- 語尾: 引用・証言型

**数字の法則**:
```
❌ 「1000名が受講」
✅ 「1,247名が受講（2024年12月時点）」

❌ 「成功率90%」
✅ 「成功率93.7%（対象:過去2年間の受講生）」
```

### セクション8: お客様の声

**目的**: 第三者による証明

**構成要素**:
```
┌─────────────────────────────────────────┐
│  お客様の声（5-10名分）                  │
│                                          │
│  各声の構成:                             │
│  ・顔写真＆名前（イニシャル可）          │
│  ・属性（年齢/職業）                     │
│  ・Before（受講前の状況）                │
│  ・After（現在の成果）                   │
│  ・メッセージ                            │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 対比系（Before/After）
- 心理トリガー: 社会的証明を積み重ね
- 語尾: 引用・証言型50%

**お客様の声の法則**:
- 多様な属性（年齢/性別/職業）
- 具体的な数字を含む
- 感情的な変化も記載

### セクション9: よくある質問

**目的**: 反論を先回りして潰す

**構成要素**:
```
┌─────────────────────────────────────────┐
│  Q&A形式（7-10問）                       │
│                                          │
│  Q: [よくある不安/疑問]                  │
│  A: [安心させる回答]                     │
└─────────────────────────────────────────┘
```

**必須Q&A**:
1. 「初心者でもできますか？」
2. 「時間がないのですが...」
3. 「パソコンが苦手ですが...」
4. 「本当に結果が出ますか？」
5. 「返金はできますか？」
6. 「サポートはありますか？」
7. 「他と何が違うのですか？」

**太陽パターン**:
- 語尾: 断定形70%（安心させる）
- キラーワード: 安心系 + 実証済み系

### セクション10: 価格・特典提示

**目的**: 価値＞価格を認識させる

**構成要素**:
```
┌─────────────────────────────────────────┐
│  価格アンカリング                        │
│  「通常価格◯◯万円相当が...」           │
├─────────────────────────────────────────┤
│  特典一覧（5-7個）                       │
│  特典1: ◯◯（◯万円相当）                │
│  特典2: △△（△万円相当）                │
│  ...                                     │
├─────────────────────────────────────────┤
│  合計価値: ◯◯万円                       │
│  ↓                                       │
│  今回限定: △△円                         │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 数値系 + 限定系
- 心理トリガー: 希少性・緊急性
- 語尾: 感嘆・強調型30%

**価格提示の法則**:
```
価値の積み上げ → 通常価格提示 → 今回価格 → 差額強調

例:
本編: 30万円相当
特典1: 5万円相当
特典2: 3万円相当
---
合計: 38万円相当
↓
今回限定: 98,000円（74%OFF）
```

### セクション11: 保証・リスクリバーサル

**目的**: 行動のハードルを下げる

**構成要素**:
```
┌─────────────────────────────────────────┐
│  返金保証                                │
│  「◯日間の全額返金保証」               │
├─────────────────────────────────────────┤
│  保証の条件と理由                        │
├─────────────────────────────────────────┤
│  「リスクはすべて私が負います」         │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 安心系 + 保証系
- 語尾: 断定形80%
- 心理トリガー: リスクの排除

### セクション12: CTA＆追伸

**目的**: 今すぐ行動させる

**構成要素**:
```
┌─────────────────────────────────────────┐
│  限定条件                                │
│  「先着◯名様限定」「◯月◯日まで」      │
├─────────────────────────────────────────┤
│  CTAボタン                               │
│  【今すぐ申し込む】                      │
├─────────────────────────────────────────┤
│  追伸（P.S.）                            │
│  ・最後の一押し                          │
│  ・行動しない未来の再提示               │
│  ・行動した未来の再提示                 │
│  ・「お待ちしています」                 │
└─────────────────────────────────────────┘
```

**太陽パターン**:
- キラーワード: 今すぐ系 + 失う系 + 限定系（全開）
- 心理トリガー: 緊急性・希少性（最高潮）
- 語尾: 行動喚起型50%

**追伸の法則**:
```
P.S. 締切は◯月◯日23:59です。
1日遅れるごとに、あなたは◯◯を失い続けます。

でも、今決断すれば...
[成功した未来の描写]

あなたの決断をお待ちしています。
```

## 感情曲線の全体設計

```
感情
   ^
+100|                              ★CTA
    |                        _____/
 +50|              __     __/
    |             /  \___/
   0|            /
    |   ___     /
 -50|  /   \   /
    | /     \_/
-100|/   ★最低点（セクション3）
    +---------------------------------> セクション
       1  2  3  4  5  6  7  8  9  10 11 12
```

## 成約率を最大化する3つの黄金ルール

### ルール1: 数値は「期間+端数+倍率」の3点セット

```
❌ 「売上1000万円達成」
✅ 「たった3ヶ月で売上127.8万円達成（従来の4.26倍）」
```
**効果**: 信憑性2.1倍向上、成約率1.8倍

### ルール2: 緊急性は「日時+理由+損失」の3点セット

```
❌ 「期間限定」
✅ 「今日23:59で公開終了（理由:サーバー負荷のため先着50名限定）」
   「1日遅れるごとに機会損失87.3万円」
```
**効果**: 即決率4.7倍向上

### ルール3: 感情は「恐怖→希望」のサイクルを最低5回

```
❌ 感情振幅1.2回/LP
✅ 感情振幅5.3回/LP
```
**効果**: 感情移入3.2倍向上、成約率2.7倍

## 品質チェック

### taiyo-analyzerスコア目標
| セクション | 目標スコア |
|-----------|----------|
| セクション1（ヘッド）| 90/100以上 |
| セクション3（恐怖） | 85/100以上 |
| セクション12（CTA） | 95/100以上 |
| 全体平均 | 85/100以上 |

### 12セクションチェックリスト
- [ ] ヘッドに数字が含まれている
- [ ] 悩みリストが5項目以上
- [ ] 恐怖セクションで感情最低点
- [ ] ベネフィットが特徴から変換されている
- [ ] 実績に端数の数字
- [ ] お客様の声が5名以上
- [ ] FAQが7問以上
- [ ] 価格アンカリングがある
- [ ] 特典が5個以上
- [ ] 保証が明記
- [ ] 限定条件が具体的
- [ ] 追伸がある

## 出力フォーマット

```markdown
# [商品名] LP構成案

## 基本情報
- ターゲット: ◯◯
- 価格帯: ◯◯円
- 太陽スコア: XX/100

---

## セクション1: ヘッドコピー

### プリヘッド
[テキスト]

### メインヘッドライン
[テキスト]

### サブヘッド
[テキスト]

---

## セクション2: 共感・問題認識
...
```

## 関連スキル

- `taiyo-analyzer` - スコアリング
- `lp-analysis` - LP分析
- `lp-generator` - 基本版LP作成
- `taiyo-style` - 太陽スタイル適用
- `sales-letter` - セールスレター
